/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.utils;

import java.io.File;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.naming.UNCName;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public final class FileInfo {
    private static final FileSystemView FILESYSTEMVIEW = FileSystemView.getFileSystemView();
    private static boolean IS_WINDOWS = Utilities.isWindows();
    public static final int FLAG_isFile = 0;
    public static final int FLAG_isDirectory = 1;
    public static final int FLAG_exists = 2;
    public static final int FLAG_isComputeNode = 3;
    public static final int FLAG_isUnixSpecialFile = 5;
    public static final int FLAG_isUNC = 6;
    public static final int FLAG_isFloppy = 7;
    public static final int FLAG_isConvertibleToFileObject = 9;
    private int isFile = -1;
    private int isDirectory = -1;
    private int exists = -1;
    private int isComputeNode = -1;
    private int isUnixSpecialFile = -1;
    private int isUNC = -1;
    private int isFloppy = -1;
    private int isConvertibleToFileObject = -1;
    private Integer id = null;
    private FileInfo root = null;
    private final File file;
    private FileInfo parent = null;
    private FileNaming fileNaming = null;
    private FileObject fObject = null;

    public FileInfo(File file) {
        this.file = file;
    }

    public FileInfo(FileInfo fileInfo, File file) {
        this(file);
        this.parent = fileInfo;
    }

    public boolean isFile() {
        if (this.isFile == -1) {
            this.isFile = this.getFile().isFile() ? 1 : 0;
        }
        return this.isFile != 0;
    }

    public boolean isDirectory() {
        if (this.isDirectory == -1) {
            this.isDirectory = this.getFile().isDirectory() ? 1 : 0;
        }
        return this.isDirectory != 0;
    }

    public boolean exists() {
        if (this.exists == -1) {
            this.exists = this.getFile().exists() ? 1 : 0;
        }
        return this.exists != 0;
    }

    public boolean isComputeNode() {
        if (this.isComputeNode == -1) {
            this.isComputeNode = FILESYSTEMVIEW.isComputerNode(this.getFile()) ? 1 : 0;
        }
        return this.isComputeNode == 1;
    }

    public boolean isWindowsFloppy() {
        if (this.isFloppy == -1) {
            this.isFloppy = FILESYSTEMVIEW.isFloppyDrive(this.getFile()) ? 1 : 0;
        }
        return this.isFloppy == 1;
    }

    public boolean isUnixSpecialFile() {
        if (this.isUnixSpecialFile == -1) {
            this.isUnixSpecialFile = !IS_WINDOWS && !this.isDirectory() && !this.isFile() && this.exists() ? 1 : 0;
        }
        return this.isUnixSpecialFile == 1;
    }

    public boolean isUNCFolder() {
        if (this.isUNC == -1) {
            this.isUNC = this.getFile() instanceof UNCName.UNCFile || this.isWindows() && !this.isFile() && !this.isDirectory() && !this.exists() && this.isComputeNode() ? 1 : 0;
        }
        return this.isUNC == 1;
    }

    public boolean isWindows() {
        return IS_WINDOWS;
    }

    public boolean isFloppy() {
        if (this.isFloppy == -1) {
            this.isFloppy = FILESYSTEMVIEW.isFloppyDrive(this.getFile()) ? 1 : 0;
        }
        return this.isFloppy == 1;
    }

    public boolean isConvertibleToFileObject() {
        if (this.isConvertibleToFileObject == -1) {
            this.isConvertibleToFileObject = this.exists() && this.isSupportedFile() ? 1 : 0;
        }
        return this.isConvertibleToFileObject == 1;
    }

    public boolean isSupportedFile() {
        return !this.getFile().getName().equals(".nbattrs") && !WriteLockUtils.hasActiveLockFileSigns(this.getFile().getAbsolutePath()) && (this.getFile().getParent() != null || !this.isWindowsFloppy());
    }

    public FileInfo getRoot() {
        if (this.root == null) {
            File file;
            File file2 = file = this.getFile();
            while (file != null) {
                file2 = file;
                file = file.getParentFile();
            }
            this.root = new FileInfo(file2);
        }
        return this.root;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getID() {
        if (this.id == null) {
            this.id = NamingFactory.createID(this.getFile());
        }
        return this.id;
    }

    public FileInfo getParent() {
        return this.parent;
    }

    public void setValueForFlag(int n, boolean bl) {
        switch (n) {
            case 2: {
                this.exists = bl ? 1 : 0;
                break;
            }
            case 3: {
                this.isComputeNode = bl ? 1 : 0;
                break;
            }
            case 9: {
                this.isConvertibleToFileObject = bl ? 1 : 0;
                break;
            }
            case 1: {
                this.isDirectory = bl ? 1 : 0;
                break;
            }
            case 0: {
                this.isFile = bl ? 1 : 0;
                break;
            }
            case 7: {
                this.isFloppy = bl ? 1 : 0;
                break;
            }
            case 6: {
                this.isUNC = bl ? 1 : 0;
                break;
            }
            case 5: {
                this.isUnixSpecialFile = bl ? 1 : 0;
            }
        }
    }

    public FileNaming getFileNaming() {
        return this.fileNaming;
    }

    public void setFileNaming(FileNaming fileNaming) {
        this.fileNaming = fileNaming;
    }

    public FileObject getFObject() {
        return this.fObject;
    }

    public void setFObject(FileObject fileObject) {
        this.fObject = fileObject;
    }

    public String toString() {
        return this.getFile().toString();
    }

    public static final String composeName(String string, String string2) {
        return string2 != null && string2.length() > 0 ? string + "." + string2 : string;
    }

    public static final String getName(String string) {
        int n = string.lastIndexOf(46);
        return n <= 0 || n == string.length() - 1 ? string : string.substring(0, n);
    }

    public static final String getExt(String string) {
        int n = string.lastIndexOf(46) + 1;
        return n <= 1 || n == string.length() ? "" : string.substring(n);
    }
}

