/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.lexer.DelegatingInputBridge;
import org.netbeans.modules.languages.lexer.InputBridge;
import org.netbeans.modules.languages.lexer.STokenId;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.netbeans.spi.lexer.TokenPropertyProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLexer
implements Lexer<STokenId>,
Parser.Cookie {
    private Language language;
    private CharInput input;
    private TokenFactory<STokenId> tokenFactory;
    private Map<Integer, STokenId> tokenIDToType;
    private Parser parser;
    private Object state;
    private Feature tokenProperties;

    SLexer(Language language, Map<Integer, STokenId> map, LexerRestartInfo<STokenId> lexerRestartInfo) {
        this.language = language;
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        this.tokenIDToType = map;
        this.state = lexerRestartInfo.state();
        this.parser = language.getParser();
        String string = lexerRestartInfo.languagePath().language(0).mimeType();
        try {
            Language language2 = LanguagesManager.getDefault().getLanguage(string);
            this.input = SLexer.createInputBridge(lexerRestartInfo.input(), language2);
        }
        catch (ParseException parseException) {
            this.input = SLexer.createInputBridge(lexerRestartInfo.input(), Language.create(string));
        }
    }

    public Token<STokenId> nextToken() {
        int n = this.input.getIndex();
        if (this.state != null && "Fukala".equals(this.state)) {
            if (this.input.eof()) {
                return null;
            }
            while (!this.input.eof() && this.input.next() != '\'' && this.input.next() != '\"' && this.input.next() != '\n' && this.input.next() != '\r') {
                if (this.input.next() == '\\') {
                    this.input.read();
                }
                this.input.read();
            }
            this.input.read();
            if (!this.input.eof()) {
                this.state = -1;
            }
            if ("text/javascript".equals(this.language.getMimeType())) {
                return this.createToken(this.language.getTokenID("js_string"), n);
            }
            return this.createToken(this.language.getTokenID("css_string"), n);
        }
        if (this.state instanceof Marenka) {
            return this.createToken((Marenka)this.state);
        }
        Object object = this.state;
        if (this.input.eof()) {
            return this.createToken(n);
        }
        ASTToken aSTToken = null;
        aSTToken = this.parser.read(this, this.input, this.language);
        if (aSTToken == null) {
            char c;
            if (this.input.eof() && ("text/javascript".equals(this.language.getMimeType()) || "text/x-css".equals(this.language.getMimeType())) && ((c = this.input.getString(n, n + 1).charAt(0)) == '\"' || c == '\'')) {
                this.state = "Fukala";
                if ("text/javascript".equals(this.language.getMimeType())) {
                    return this.createToken(this.language.getTokenID("js_string"), n);
                }
                return this.createToken(this.language.getTokenID("css_string"), n);
            }
            if (this.input.getIndex() > n + 1) {
                this.input.setIndex(n + 1);
            } else if (this.input.getIndex() == n) {
                this.input.read();
            }
            return this.createToken(this.language.getTokenID("error"), n);
        }
        if (this.state != object && n == this.input.getIndex()) {
            return this.nextToken();
        }
        return this.createToken(aSTToken.getTypeID(), n);
    }

    public Object state() {
        return this.state;
    }

    public void release() {
    }

    @Override
    public int getState() {
        if (this.state == null) {
            return -1;
        }
        return (Integer)this.state;
    }

    @Override
    public void setState(int n) {
        this.state = new Integer(n);
    }

    @Override
    public void setProperties(Feature feature) {
        this.tokenProperties = feature;
    }

    private static CharInput createInputBridge(LexerInput lexerInput, Language language) {
        Feature feature = language.getPreprocessorImport();
        if (feature != null) {
            return new DelegatingInputBridge(new InputBridge(lexerInput), feature.getPattern("start"), feature.getPattern("end"), language.getTokenID("PE"));
        }
        return new InputBridge(lexerInput);
    }

    private Token<STokenId> createToken(int n, int n2) {
        STokenId sTokenId = this.tokenIDToType.get(n);
        assert (sTokenId != null) : "Unknown token type \"" + n + "\"";
        if (!(this.input instanceof DelegatingInputBridge)) {
            return this.tokenFactory.createToken((TokenId)sTokenId);
        }
        List<Vojta> list = ((DelegatingInputBridge)this.input).getEmbeddings();
        if (list.isEmpty()) {
            return this.tokenFactory.createToken((TokenId)sTokenId);
        }
        Map<String, Feature> map = this.language.getTokenImports();
        if (map.containsKey(n)) {
            return this.tokenFactory.createToken((TokenId)sTokenId);
        }
        Marenka marenka = new Marenka((Integer)this.state);
        String string = "S";
        for (Vojta vojta : list) {
            if (n2 < vojta.startOffset) {
                marenka.add(new Vojta(n, n2, vojta.startOffset, string));
                string = "C";
            }
            marenka.add(vojta);
            n2 = vojta.endOffset;
        }
        if (n2 < this.input.getIndex()) {
            marenka.add(new Vojta(n, n2, this.input.getIndex(), string));
        }
        return this.createToken(marenka);
    }

    private Token<STokenId> createToken(int n) {
        if (!(this.input instanceof DelegatingInputBridge)) {
            return null;
        }
        List<Vojta> list = ((DelegatingInputBridge)this.input).getEmbeddings();
        if (list.isEmpty()) {
            return null;
        }
        Marenka marenka = new Marenka((Integer)this.state);
        String string = "S";
        for (Vojta vojta : list) {
            assert (n == vojta.startOffset);
            marenka.add(vojta);
            n = vojta.endOffset;
        }
        assert (n == this.input.getIndex());
        return this.createToken(marenka);
    }

    private Token<STokenId> createToken(Marenka marenka) {
        Vojta vojta = marenka.removeFirst();
        STokenId sTokenId = this.tokenIDToType.get(vojta.type);
        assert (sTokenId != null) : "Unknown type " + vojta.type;
        this.input.setIndex(vojta.endOffset);
        this.state = marenka.isEmpty() ? marenka.getState() : marenka;
        if (vojta.property instanceof TokenProperties) {
            return this.tokenFactory.createPropertyToken((TokenId)sTokenId, vojta.endOffset - vojta.startOffset, (TokenPropertyProvider)((TokenProperties)vojta.property), PartType.COMPLETE);
        }
        return this.tokenFactory.createPropertyToken((TokenId)sTokenId, vojta.endOffset - vojta.startOffset, (TokenPropertyProvider)new TokenPropProvider(vojta.property), PartType.COMPLETE);
    }

    private static String e(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (charSequence.charAt(i) == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (charSequence.charAt(i) == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            stringBuilder.append(charSequence.charAt(i));
        }
        return stringBuilder.toString();
    }

    static class Marenka {
        Integer state;
        LinkedList<Vojta> vojta = new LinkedList();

        Marenka(Integer n) {
            this.state = n;
        }

        void add(Vojta vojta) {
            this.vojta.add(vojta);
        }

        Vojta removeFirst() {
            return this.vojta.removeFirst();
        }

        boolean isEmpty() {
            return this.vojta.isEmpty();
        }

        Integer getState() {
            return this.state;
        }
    }

    static class Vojta {
        int type;
        int startOffset;
        int endOffset;
        Object property;

        Vojta(int n, int n2, int n3, Object object) {
            this.type = n;
            this.startOffset = n2;
            this.endOffset = n3;
            this.property = object;
        }

        int size() {
            return this.endOffset - this.startOffset;
        }
    }

    static class TokenProperties
    implements TokenPropertyProvider {
        private String type;
        private int startSkipLength;
        private int endSkipLength;

        TokenProperties(String string, int n, int n2) {
            this.type = string;
            this.startSkipLength = n;
            this.endSkipLength = n2;
        }

        public Object getValue(Token token, Object object) {
            if ("type".equals(object)) {
                return this.type;
            }
            if ("startSkipLength".equals(object)) {
                return new Integer(this.startSkipLength);
            }
            if ("endSkipLength".equals(object)) {
                return new Integer(this.endSkipLength);
            }
            return null;
        }
    }

    private static final class TokenPropProvider
    implements TokenPropertyProvider {
        private final Object value;

        TokenPropProvider(Object object) {
            this.value = object;
        }

        public Object getValue(Token token, Object object) {
            if ("type".equals(object)) {
                return this.value;
            }
            return null;
        }
    }
}

