/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepoImageCache;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class JrxmLookupListener
implements LookupListener {
    private final Lookup.Result<JasperDesign> result;
    private RepositoryReportUnit parentReportUnit = null;
    private JServer server = null;
    List jrxmlListeners = null;

    public JrxmLookupListener(DataObject obj, List jrxmlListeners, RepositoryReportUnit parentReportUnit, JServer server) {
        this.server = server;
        this.parentReportUnit = parentReportUnit;
        this.result = obj.getLookup().lookup(new Lookup.Template(JasperDesign.class));
        this.result.addLookupListener((LookupListener)this);
        this.result.allItems();
        this.resultChanged(null);
        this.jrxmlListeners = jrxmlListeners;
    }

    public void resultChanged(LookupEvent ev) {
        Collection jds = this.result.allInstances();
        if (jds.size() > 0) {
            final JasperDesign jd = (JasperDesign)jds.iterator().next();
            Runnable run = new Runnable(){

                public void run() {
                    List elements = ModelUtils.getAllElements((JasperDesign)jd, (boolean)true);
                    for (JRDesignElement ele : elements) {
                        String s;
                        JRDesignImage img;
                        if (!(ele instanceof JRDesignImage) || (img = (JRDesignImage)ele).getExpression() == null || img.getExpression().getText() == null || !img.getExpression().getValueClassName().equals("java.lang.String") || !(s = JRExpressionUtil.getSimpleExpressionText((JRExpression)img.getExpression())).startsWith("repo:")) continue;
                        String uri = s.substring(5);
                        ResourceDescriptor rd = new ResourceDescriptor();
                        if (!uri.startsWith("/") && JrxmLookupListener.this.getParentReportUnit() != null) {
                            uri = JrxmLookupListener.this.getParentReportUnit().getDescriptor().getUriString() + "_files/" + uri;
                        }
                        rd.setUriString(uri);
                        try {
                            rd = JrxmLookupListener.this.getServer().getWSClient().get(rd, null);
                            String fname = JasperServerManager.createTmpFileName("img", "");
                            rd = JrxmLookupListener.this.getServer().getWSClient().get(rd, new File(fname));
                            RepoImageCache.getInstance().put(s, new File(fname));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            try {
                                ReportObjectScene scene = IReportManager.getInstance().getActiveVisualView().getReportDesignerPanel().getScene();
                                scene.refreshBands();
                                if (jd.getProperty("com.jaspersoft.ji.adhoc") != null && jd.getProperty("com.jaspersoft.ji.adhoc").equals("1")) {
                                    try {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            public void run() {
                                                if (JOptionPane.showConfirmDialog(Misc.getMainFrame(), JasperServerManager.getString("messages.adhoc", "You have selected to edit an Ad Hoc report.\nIf you continue, the report will lose its sorting and grouping.\nFurthermore, any changes you make in iReport will be lost\nnext Time you edit it via the Ad Hoc report editor.\nContinue anyway?"), JasperServerManager.getString("alert", "Alert!"), 0, 2) == 1) {
                                                    DataObject dobj = (DataObject)IReportManager.getInstance().getActiveVisualView().getLookup().lookup(DataObject.class);
                                                    EditorCookie cc = (EditorCookie)dobj.getCookie(EditorCookie.class);
                                                    if (cc != null) {
                                                        cc.close();
                                                    } else {
                                                        System.out.println("Unable to close the window!!!");
                                                        System.out.flush();
                                                    }
                                                }
                                            }
                                        });
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            };
            RequestProcessor.getDefault().post(run);
            this.result.removeLookupListener((LookupListener)this);
            if (this.jrxmlListeners != null) {
                this.jrxmlListeners.remove(this);
            }
        }
    }

    public RepositoryReportUnit getParentReportUnit() {
        return this.parentReportUnit;
    }

    public void setParentReportUnit(RepositoryReportUnit parentReportUnit) {
        this.parentReportUnit = parentReportUnit;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }
}

