/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServerDialog
extends JDialog {
    private JServer jServer = null;
    private int dialogResult = 2;
    private JButton jButtonCancel;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelOrganization;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelPro;
    private JPasswordField jPasswordField;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldOrganization;
    private JTextField jTextFieldServerName;
    private JTextField jTextFieldURL;
    private JTextField jTextFieldUsername;

    public ServerDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("JasperServer Plugin");
        this.setLocationRelativeTo(null);
        this.jTextFieldURL.setText(JasperServerManager.getMainInstance().getBrandingProperties().getProperty("irplugin.server.url"));
        if (IReportManager.getPreferences().getBoolean("proMode", false)) {
            this.jTextFieldURL.setText(JasperServerManager.getMainInstance().getBrandingProperties().getProperty("irplugin.server.url_pro"));
        }
        this.jTextFieldServerName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ServerDialog.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent e) {
                ServerDialog.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                ServerDialog.this.updateButtons();
            }
        });
        this.jTextFieldUsername.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ServerDialog.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent e) {
                ServerDialog.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                ServerDialog.this.updateButtons();
            }
        });
        this.jPanelPro.setVisible(IReportManager.getPreferences().getBoolean("proMode", false));
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonCancel.setText(JasperServerManager.getString("serverDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(JasperServerManager.getString("serverDialog.buttonSave", "Save"));
        this.jLabel1.setText(JasperServerManager.getString("serverDialog.title", "JasperServer Access Configuration"));
        this.jLabel3.setText(JasperServerManager.getString("serverDialog.labelName", "Name"));
        this.jLabel4.setText(JasperServerManager.getString("serverDialog.labelURL", "JasperServer URL"));
        this.jLabel5.setText(JasperServerManager.getString("serverDialog.labelUsername", "Username"));
        this.jLabel6.setText(JasperServerManager.getString("serverDialog.labelPassword", "Password"));
        this.jLabelOrganization.setText(JasperServerManager.getString("serverDialog.labelOrganization", "Organization"));
        ((TitledBorder)this.jPanel2.getBorder()).setTitle(JasperServerManager.getString("serverDialog.account", "Account"));
        ((TitledBorder)this.jPanel3.getBorder()).setTitle(JasperServerManager.getString("serverDialog.serverInformation", "Server information"));
    }

    private void updateButtons() {
        if (this.jTextFieldServerName.getText().trim().length() > 0 && this.jTextFieldUsername.getText().trim().length() > 0) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldServerName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jPanel2 = new JPanel();
        this.jPanelPro = new JPanel();
        this.jLabelOrganization = new JLabel();
        this.jTextFieldOrganization = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel6 = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jSeparator2 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setMinimumSize(new Dimension(10, 50));
        this.jPanel1.setPreferredSize(new Dimension(400, 50));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/settings.png")));
        this.jLabel1.setText("JasperServer Access Configuration");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Server information"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel3.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel3.add((Component)this.jTextFieldServerName, gridBagConstraints);
        this.jLabel4.setText("JasperServer URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jTextFieldURL.setText("http://localhost:8080/jasperserver/services/repository");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel3.add((Component)this.jTextFieldURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Account"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanelPro.setLayout(new GridBagLayout());
        this.jLabelOrganization.setText("Organization");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanelPro.add((Component)this.jLabelOrganization, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelPro.add((Component)this.jTextFieldOrganization, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanelPro, gridBagConstraints);
        this.jLabel5.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jLabel6.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jPasswordField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 23));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel4.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.jServer = new JServer();
        this.jServer.setName(this.jTextFieldServerName.getText());
        this.jServer.setUrl(this.jTextFieldURL.getText());
        String username = this.jTextFieldUsername.getText();
        if (this.jTextFieldOrganization.getText().length() > 0) {
            username = username + "|" + this.jTextFieldOrganization.getText();
        }
        this.jServer.setUsername(username);
        this.jServer.setPassword(new String(this.jPasswordField.getPassword()));
        this.jServer.setLocale(Locale.getDefault().toString());
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ServerDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getJServer() {
        return this.jServer;
    }

    public void setJServer(JServer jServer) {
        this.jTextFieldServerName.setText(jServer.getName());
        this.jTextFieldURL.setText(jServer.getUrl());
        String username = jServer.getUsername();
        String organization = "";
        if (username.indexOf("|") > 0) {
            organization = username.substring(username.indexOf("|") + 1);
            username = username.substring(0, username.indexOf("|"));
        }
        if (IReportManager.getPreferences().getBoolean("proMode", false)) {
            this.jTextFieldUsername.setText(username);
            this.jTextFieldOrganization.setText(organization);
        } else {
            this.jTextFieldUsername.setText(username + "|" + organization);
            this.jTextFieldOrganization.setText("");
        }
        this.jPasswordField.setText(jServer.getPassword());
    }
}

