/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractOutputWindow
extends TopComponent
implements ChangeListener,
PropertyChangeListener {
    protected JTabbedPane pane = TabbedPaneFactory.createCloseButtonTabbedPane();
    private static final String ICON_PROP = "tabIcon";
    private JToolBar toolbar = null;
    private Runnable pendingFocusRunnable = null;
    private AbstractOutputTab lastKnownSelection = null;
    private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID()) || UIManager.getLookAndFeel().getClass().getSuperclass().getName().indexOf("Synth") != -1;

    public AbstractOutputWindow() {
        this.pane.addChangeListener(this);
        this.pane.addPropertyChangeListener("close", this);
        this.setFocusable(true);
        this.setBackground(UIManager.getColor("text"));
        this.toolbar = new JToolBar();
        this.toolbar.setOrientation(1);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
        this.toolbar.setFloatable(false);
        Insets insets = this.toolbar.getMargin();
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        jButton.setText(null);
        jButton.setIcon(new Icon(){

            public int getIconHeight() {
                return 16;
            }

            public int getIconWidth() {
                return 16;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }
        });
        this.toolbar.add(jButton);
        Dimension dimension = jButton.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        this.toolbar.setMinimumSize(dimension2);
        this.toolbar.setPreferredSize(dimension2);
        this.toolbar.remove(jButton);
        this.setLayout(new BorderLayout());
        this.add(this.toolbar, "West");
        this.toolbar.setBorder(new VariableRightBorder(this.pane));
        this.toolbar.setBorderPainted(true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("close".equals(propertyChangeEvent.getPropertyName())) {
            AbstractOutputTab abstractOutputTab = (AbstractOutputTab)propertyChangeEvent.getNewValue();
            this.closeRequest(abstractOutputTab);
        }
    }

    protected abstract void closeRequest(AbstractOutputTab var1);

    protected abstract void removed(AbstractOutputTab var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object object, int n) {
        this.setFocusable(false);
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl = this.hasFocus() || this.isAncestorOf(component2);
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            if (component instanceof AbstractOutputTab) {
                AbstractOutputTab abstractOutputTab = this.getInternalTab();
                if (abstractOutputTab != null) {
                    if (abstractOutputTab == component) {
                        return;
                    }
                    super.remove((Component)abstractOutputTab);
                    assert (this.pane.getParent() != this);
                    this.pane.add(abstractOutputTab);
                    this.setTabIcon(abstractOutputTab, (Icon)abstractOutputTab.getClientProperty(ICON_PROP));
                    this.pane.add(component);
                    this.setTabIcon((AbstractOutputTab)component, (Icon)((AbstractOutputTab)component).getClientProperty(ICON_PROP));
                    super.addImpl((Component)this.pane, object, n);
                    this.updateSingletonName(null);
                    this.revalidate();
                } else if (this.pane.getParent() == this) {
                    this.pane.add(component);
                    this.setTabIcon((AbstractOutputTab)component, (Icon)((AbstractOutputTab)component).getClientProperty(ICON_PROP));
                    this.revalidate();
                } else {
                    super.addImpl(component, object, n);
                    this.setTabIcon((AbstractOutputTab)component, (Icon)((AbstractOutputTab)component).getClientProperty(ICON_PROP));
                    this.setToolbarButtons(((AbstractOutputTab)component).getToolbarButtons());
                    this.revalidate();
                }
                if (bl) {
                    this.requestFocus();
                }
                return;
            }
            super.addImpl(component, object, n);
        }
        if (this.getComponentCount() == 2 && this.getComponent(1) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(1).getName());
        }
        this.revalidate();
    }

    public final AbstractOutputTab[] getTabs() {
        ArrayList<AbstractOutputTab> arrayList = new ArrayList<AbstractOutputTab>(this.pane.getParent() == this ? this.pane.getTabCount() : this.getComponentCount());
        if (this.pane.getParent() == this) {
            int n = this.pane.getTabCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.pane.getComponentAt(i);
                if (!(component instanceof AbstractOutputTab)) continue;
                arrayList.add((AbstractOutputTab)component);
            }
        } else {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof AbstractOutputTab)) continue;
                arrayList.add((AbstractOutputTab)componentArray[i]);
            }
        }
        AbstractOutputTab[] abstractOutputTabArray = new AbstractOutputTab[arrayList.size()];
        return arrayList.toArray(abstractOutputTabArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component component) {
        AbstractOutputTab abstractOutputTab = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.getParent() == this.pane && component instanceof AbstractOutputTab) {
                if (component == this.pane.getSelectedComponent()) {
                    if (Controller.LOG) {
                        Controller.log("Selected view is being removed: " + component.getName());
                    }
                    abstractOutputTab = (AbstractOutputTab)component;
                }
                this.checkWinXPLFBug();
                this.pane.remove(component);
                if (this.pane.getTabCount() == 1) {
                    Component component2 = this.pane.getComponentAt(0);
                    this.pane.remove(component2);
                    super.remove((Component)this.pane);
                    this.add(component2);
                    this.updateSingletonName(component.getName());
                    this.setToolbarButtons(((AbstractOutputTab)component2).getToolbarButtons());
                    this.revalidate();
                }
            } else {
                if (component == this.getSelectedTab()) {
                    abstractOutputTab = (AbstractOutputTab)component;
                }
                super.remove(component);
                this.setToolbarButtons(new JButton[0]);
                this.updateSingletonName(null);
            }
            if (abstractOutputTab != null) {
                this.fire(abstractOutputTab);
            }
        }
        if (component instanceof AbstractOutputTab && component.getParent() == null) {
            this.removed((AbstractOutputTab)component);
        }
        if (this.getComponentCount() == 2 && this.getComponent(1) instanceof AbstractOutputTab) {
            this.updateSingletonName(this.getComponent(1).getName());
        }
        this.revalidate();
        this.setFocusable(this.getComponentCount() == 1);
    }

    private AbstractOutputTab getInternalTab() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractOutputTab)) continue;
            return (AbstractOutputTab)componentArray[i];
        }
        return null;
    }

    public final AbstractOutputTab getSelectedTab() {
        if (this.pane.getParent() == this) {
            return (AbstractOutputTab)this.pane.getSelectedComponent();
        }
        return this.getInternalTab();
    }

    public void setSelectedTab(AbstractOutputTab abstractOutputTab) {
        assert (abstractOutputTab.getParent() == this || abstractOutputTab.getParent() == this.pane);
        if (Controller.LOG) {
            Controller.log("SetSelectedTab: " + abstractOutputTab + " parent is " + abstractOutputTab.getParent());
        }
        if (this.pane.getParent() == this && abstractOutputTab != this.pane.getSelectedComponent()) {
            this.pane.setSelectedComponent(abstractOutputTab);
        }
        this.getActionMap().setParent(abstractOutputTab.getActionMap());
    }

    public void setTabTitle(AbstractOutputTab abstractOutputTab, String string) {
        if (abstractOutputTab.getParent() == this.pane) {
            int n = this.pane.indexOfComponent(abstractOutputTab);
            if (Controller.LOG) {
                Controller.log("setTabTitle: #" + n + " '" + this.pane.getTitleAt(n) + "' -> '" + string + "'");
            }
            this.pane.setTitleAt(n, string);
        } else if (abstractOutputTab.getParent() == this) {
            this.updateSingletonName(string);
        }
        abstractOutputTab.setName(string);
    }

    public void setTabIcon(AbstractOutputTab abstractOutputTab, Icon icon) {
        if (icon != null) {
            abstractOutputTab.putClientProperty(ICON_PROP, icon);
            if (this.pane.indexOfComponent(abstractOutputTab) != -1) {
                this.pane.setIconAt(this.pane.indexOfComponent(abstractOutputTab), icon);
                this.pane.setDisabledIconAt(this.pane.indexOfComponent(abstractOutputTab), icon);
            }
        }
    }

    public void requestFocus() {
        if (!this.isShowing()) {
            return;
        }
        AbstractOutputTab abstractOutputTab = this.getSelectedTab();
        if (abstractOutputTab != null && this.pendingFocusRunnable == null) {
            this.pendingFocusRunnable = new Runnable(){

                public void run() {
                    AbstractOutputTab abstractOutputTab = AbstractOutputWindow.this.getSelectedTab();
                    if (abstractOutputTab != null) {
                        abstractOutputTab.requestFocus();
                    }
                    AbstractOutputWindow.this.pendingFocusRunnable = null;
                }
            };
            SwingUtilities.invokeLater(this.pendingFocusRunnable);
        } else {
            super.requestFocus();
        }
    }

    protected abstract void updateSingletonName(String var1);

    protected void fire(AbstractOutputTab abstractOutputTab) {
        AbstractOutputTab abstractOutputTab2 = this.getSelectedTab();
        if (abstractOutputTab != abstractOutputTab2) {
            this.selectionChanged(abstractOutputTab, abstractOutputTab2);
            this.lastKnownSelection = abstractOutputTab2;
            if (abstractOutputTab2 != null) {
                this.setToolbarButtons(abstractOutputTab2.getToolbarButtons());
            } else {
                this.setToolbarButtons(new JButton[0]);
            }
        }
    }

    private void setToolbarButtons(JButton[] jButtonArray) {
        this.toolbar.removeAll();
        for (int i = 0; i < jButtonArray.length; ++i) {
            this.toolbar.add(jButtonArray[i]);
        }
        this.toolbar.revalidate();
        this.toolbar.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.pane.getSelectedComponent() instanceof AbstractOutputPane) {
            ((AbstractOutputPane)this.pane.getSelectedComponent()).ensureCaretPosition();
        }
        this.fire(this.lastKnownSelection);
    }

    protected abstract void selectionChanged(AbstractOutputTab var1, AbstractOutputTab var2);

    public void paint(Graphics graphics) {
        if (this.isGtk) {
            Color color = this.getBackground();
            if (color == null) {
                color = Color.WHITE;
            }
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(graphics);
    }

    public final void selectNextTab(AbstractOutputTab abstractOutputTab) {
        AbstractOutputTab[] abstractOutputTabArray = this.getTabs();
        if (abstractOutputTabArray.length > 1) {
            int n = this.getSelectedTabIndex(abstractOutputTabArray, abstractOutputTab) + 1;
            if (n > abstractOutputTabArray.length - 1) {
                n = 0;
            }
            this.setSelectedTab(abstractOutputTabArray[n]);
        }
    }

    public final void selectPreviousTab(AbstractOutputTab abstractOutputTab) {
        AbstractOutputTab[] abstractOutputTabArray = this.getTabs();
        if (abstractOutputTabArray.length > 1) {
            int n = this.getSelectedTabIndex(abstractOutputTabArray, abstractOutputTab) - 1;
            if (n < 0) {
                n = abstractOutputTabArray.length - 1;
            }
            this.setSelectedTab(abstractOutputTabArray[n]);
        }
    }

    private int getSelectedTabIndex(AbstractOutputTab[] abstractOutputTabArray, AbstractOutputTab abstractOutputTab) {
        for (int i = 0; i < abstractOutputTabArray.length; ++i) {
            if (abstractOutputTabArray[i] != abstractOutputTab) continue;
            return i;
        }
        return -1;
    }

    private void checkWinXPLFBug() {
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            TabbedPaneUI tabbedPaneUI = this.pane.getUI();
            try {
                Method method = tabbedPaneUI.getClass().getDeclaredMethod("setRolloverTab", Integer.TYPE);
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke((Object)tabbedPaneUI, new Integer(-1));
                    method.setAccessible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class VariableRightBorder
    implements Border {
        private JTabbedPane pane;

        public VariableRightBorder(JTabbedPane jTabbedPane) {
            this.pane = jTabbedPane;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.pane.getParent() != AbstractOutputWindow.this) {
                Color color = graphics.getColor();
                graphics.setColor(this.getColor());
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
                graphics.setColor(color);
            }
        }

        public Color getColor() {
            if (Utilities.isMac()) {
                Color color = UIManager.getColor("controlShadow");
                Color color2 = UIManager.getColor("control");
                return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
            }
            return UIManager.getColor("controlShadow");
        }

        public Insets getBorderInsets(Component component) {
            if (this.pane.getParent() == AbstractOutputWindow.this) {
                return new Insets(0, 0, 0, 0);
            }
            return new Insets(0, 0, 0, 2);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

