/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util {
    public static final Logger err = Logger.getLogger("org.netbeans.core.modules");
    private static String[] suffixes = null;
    private static Locale lastLocale = null;
    private static String lastBranding = null;
    private static final Map<String, Object[]> codeNameParseCache = new HashMap<String, Object[]>(200);

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File makeTempJar(File file) throws IOException {
        String string = file.getName();
        if (string.endsWith(".jar") || string.endsWith(".JAR")) {
            string = string.substring(0, string.length() - 4);
        }
        if (string.length() < 3) {
            string = string + '.';
        }
        if (string.length() < 3) {
            string = string + '.';
        }
        if (string.length() < 3) {
            string = string + '.';
        }
        String string2 = "-test.jar";
        File file2 = File.createTempFile(string, string2);
        file2.deleteOnExit();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        err.fine("Made " + file2);
        return file2;
    }

    static List<File> findLocaleVariantsOf(File file) {
        List<FileWithSuffix> list = Util.findLocaleVariantsWithSuffixesOf(file);
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (FileWithSuffix fileWithSuffix : list) {
            arrayList.add(fileWithSuffix.file);
        }
        return arrayList;
    }

    static List<FileWithSuffix> findLocaleVariantsWithSuffixesOf(File file) {
        Object object;
        block7: {
            String string;
            String string2;
            block6: {
                if (!file.isFile()) {
                    return Collections.emptyList();
                }
                String string3 = null;
                object = Util.findLogicalPath(file);
                if (object != null) {
                    int n = ((String)object).lastIndexOf(47);
                    string3 = n != -1 ? ((String)object).substring(0, n + 1) + "locale/" : "locale/";
                }
                object = new ArrayList(7);
                String string4 = file.getName();
                int n = string4.lastIndexOf(46);
                if (n != -1) {
                    string2 = string4.substring(0, n);
                    string = string4.substring(n);
                } else {
                    string2 = string4;
                    string = "";
                }
                if (string3 == null) break block6;
                for (String string5 : Util.getLocalizingSuffixesFast()) {
                    String string6 = string3 + string2 + string5 + string;
                    File file2 = InstalledFileLocator.getDefault().locate(string6, null, false);
                    if (file2 == null) continue;
                    object.add(new FileWithSuffix(file2, string5));
                }
                break block7;
            }
            File file3 = new File(file.getParentFile(), "locale");
            if (!file3.exists()) break block7;
            for (String string7 : Util.getLocalizingSuffixesFast()) {
                File file4 = new File(file3, string2 + string7 + string);
                if (!file4.isFile()) continue;
                object.add(new FileWithSuffix(file4, string7));
            }
        }
        return object;
    }

    public static synchronized String[] getLocalizingSuffixesFast() {
        if (suffixes == null || Locale.getDefault() != lastLocale || !Utilities.compareObjects((Object)NbBundle.getBranding(), (Object)lastBranding)) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = NbBundle.getLocalizingSuffixes();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            suffixes = arrayList.toArray(new String[arrayList.size()]);
            lastLocale = Locale.getDefault();
            lastBranding = NbBundle.getBranding();
        }
        return suffixes;
    }

    private static String findLogicalPath(File file) {
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        String string = file.getName();
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            File file3 = installedFileLocator.locate(string, null, false);
            if (file.equals(file3)) {
                return string;
            }
            string = file2.getName() + '/' + string;
        }
        return null;
    }

    static boolean checkJavaDependency(Dependency dependency) throws IllegalArgumentException {
        if (dependency.getType() == 3) {
            if (dependency.getName().equals("Java")) {
                if (dependency.getComparison() == 1) {
                    return new SpecificationVersion(dependency.getVersion()).compareTo((Object)Dependency.JAVA_SPEC) <= 0;
                }
                return dependency.getVersion().equals(Dependency.JAVA_IMPL);
            }
            if (dependency.getComparison() == 1) {
                return new SpecificationVersion(dependency.getVersion()).compareTo((Object)Dependency.VM_SPEC) <= 0;
            }
            return dependency.getVersion().equals(Dependency.VM_IMPL);
        }
        throw new IllegalArgumentException();
    }

    static boolean checkPackageDependency(Dependency dependency, ClassLoader classLoader) throws IllegalArgumentException {
        String string;
        String string2;
        if (dependency.getType() != 2) {
            throw new IllegalArgumentException("Not a package dependency");
        }
        if (!(classLoader instanceof PackageAccessibleClassLoader) && classLoader != Util.class.getClassLoader()) {
            throw new IllegalArgumentException("Not a package-accessible classloader: " + classLoader);
        }
        String string3 = dependency.getName();
        String string4 = dependency.getVersion();
        int n = dependency.getComparison();
        int n2 = string3.indexOf(91);
        if (n2 == -1) {
            string2 = string3;
            string = null;
        } else if (n2 == 0) {
            string2 = null;
            string = string3.substring(1, string3.length() - 1);
        } else {
            string2 = string3.substring(0, n2);
            string = string3.substring(n2 + 1, string3.length() - 1);
            if (string.indexOf(46) == -1) {
                string = string2 + '.' + string;
            }
        }
        if (string != null) {
            try {
                classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (string2 == null) {
                    err.log(Level.WARNING, null, classNotFoundException);
                    err.fine("Probed class could not be found");
                    return false;
                }
            }
            catch (RuntimeException runtimeException) {
                err.log(Level.WARNING, null, runtimeException);
                err.fine("Assuming package " + string2 + " is corrupt");
                return false;
            }
            catch (LinkageError linkageError) {
                err.log(Level.WARNING, null, linkageError);
                err.fine("Assuming package " + string2 + " is corrupt");
                return false;
            }
        }
        if (string2 != null) {
            Package package_ = classLoader instanceof PackageAccessibleClassLoader ? ((PackageAccessibleClassLoader)((Object)classLoader)).getPackageAccessibly(string2) : Package.getPackage(string2);
            if (package_ == null) {
                err.fine("No package with the name " + string2 + " found");
                return false;
            }
            if (n == 3) {
                return true;
            }
            if (n == 1) {
                if (package_.getSpecificationVersion() == null) {
                    err.fine("Package " + string2 + " did not give a specification version");
                    return false;
                }
                try {
                    SpecificationVersion specificationVersion = new SpecificationVersion(string4);
                    SpecificationVersion specificationVersion2 = new SpecificationVersion(package_.getSpecificationVersion().trim());
                    if (specificationVersion.compareTo((Object)specificationVersion2) <= 0) {
                        return true;
                    }
                    err.fine("Loaded package " + string2 + " was only of version " + specificationVersion2 + " but " + specificationVersion + " was requested");
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    err.log(Level.WARNING, null, numberFormatException);
                    err.fine("Will not honor a dependency on non-numeric package spec version");
                    return false;
                }
            }
            if (package_.getImplementationVersion() == null) {
                err.fine("Package " + string2 + " had no implementation version");
                return false;
            }
            if (!package_.getImplementationVersion().trim().equals(string4)) {
                err.fine("Package " + string2 + " had the wrong impl version: " + package_.getImplementationVersion());
                return false;
            }
            return true;
        }
        return true;
    }

    public static Map<Module, List<Module>> moduleDependencies(Collection<Module> collection, Map<String, Module> map, Map<String, Set<Module>> map2) {
        LinkedList<Module> linkedList;
        Set<Object> set = collection instanceof Set ? (Set<Object>)collection : new HashSet<Module>(collection);
        HashMap hashMap = new HashMap(map2.size() * 2 + 1);
        for (Map.Entry<String, Set<Module>> entry : map2.entrySet()) {
            Set<Module> object = entry.getValue();
            if (object == null) continue;
            linkedList = new LinkedList<Module>(object);
            linkedList.retainAll(set);
            if (linkedList.isEmpty()) continue;
            hashMap.put(entry.getKey(), linkedList);
        }
        HashMap hashMap2 = new HashMap();
        for (Module module : collection) {
            linkedList = null;
            for (Dependency dependency : module.getDependenciesArray()) {
                Module module2;
                Object object;
                if (dependency.getType() == 5) {
                    object = (List)hashMap.get(dependency.getName());
                    if (object == null) continue;
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    linkedList.addAll((Collection<Module>)object);
                    continue;
                }
                if (dependency.getType() != 1 || (module2 = map.get(object = (String)Util.parseCodeName(dependency.getName())[0])) == null || !set.contains((Object)module2)) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList();
                }
                linkedList.add(module2);
            }
            if (linkedList == null) continue;
            hashMap2.put(module, linkedList);
        }
        return hashMap2;
    }

    static Set<Module> moduleInterdependencies(Module module, boolean bl, boolean bl2, Set<Module> set, Map<String, Module> map, Map<String, Set<Module>> map2) {
        if (bl) {
            HashSet<Module> hashSet = new HashSet<Module>();
            for (Module module2 : set) {
                if (module2 == module || !Util.moduleInterdependencies(module2, false, bl2, set, map, map2).contains((Object)module)) continue;
                hashSet.add(module2);
            }
            return hashSet;
        }
        HashSet<Module> hashSet = new HashSet<Module>();
        for (Dependency object : module.getDependenciesArray()) {
            Module module2;
            Set<Module> set2;
            if (object.getType() == 5 || object.getType() == 6) {
                set2 = map2.get(object.getName());
                if (set2 == null) continue;
                hashSet.addAll(set2);
                continue;
            }
            if (object.getType() != 1 || (module2 = map.get(set2 = (String)Util.parseCodeName(object.getName())[0])) == null) continue;
            hashSet.add(module2);
        }
        hashSet.remove((Object)module);
        if (bl2) {
            HashSet hashSet2;
            do {
                hashSet2 = new HashSet();
                for (Module module4 : hashSet) {
                    Set<Module> set3 = Util.moduleInterdependencies(module4, false, false, set, map, map2);
                    set3.remove((Object)module);
                    set3.removeAll(hashSet);
                    hashSet2.addAll(set3);
                }
                hashSet.addAll(hashSet2);
            } while (!hashSet2.isEmpty());
        }
        return hashSet;
    }

    public static String findLocalizedMessage(Throwable throwable, boolean bl) {
        String string = throwable.getLocalizedMessage();
        if (Utilities.compareObjects((Object)string, (Object)throwable.getMessage())) {
            string = Exceptions.findLocalizedMessage((Throwable)throwable);
            if (!bl) {
                return null;
            }
        }
        return string;
    }

    static FilenameFilter jarFilter() {
        return new JarFilter();
    }

    public static String createPackageName(String string) throws IllegalArgumentException {
        String string2 = ".class";
        if (!string.endsWith(string2)) {
            string2 = ".ser";
        }
        if (string.endsWith(string2)) {
            String string3 = string.substring(0, string.length() - string2.length());
            if (string3.length() == 0) {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            if (string3.charAt(0) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            if (string3.charAt(string3.length() - 1) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            if (string3.indexOf(46) != -1) {
                throw new IllegalArgumentException("Bad class file name: " + string);
            }
            return string3.replace('/', '.');
        }
        throw new IllegalArgumentException("Bad class file name: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] parseCodeName(String string) throws NumberFormatException {
        Map<String, Object[]> map = codeNameParseCache;
        synchronized (map) {
            Object[] objectArray = codeNameParseCache.get(string);
            if (objectArray == null) {
                objectArray = new Object[3];
                int n = string.lastIndexOf(47);
                if (n == -1) {
                    objectArray[0] = string;
                } else {
                    objectArray[0] = string.substring(0, n).intern();
                    String string2 = string.substring(n + 1);
                    int n2 = string2.indexOf(45);
                    if (n2 == -1) {
                        objectArray[1] = new Integer(string2);
                    } else {
                        objectArray[1] = new Integer(string2.substring(0, n2));
                        objectArray[2] = new Integer(string2.substring(n2 + 1));
                    }
                }
                codeNameParseCache.put(string.intern(), objectArray);
            }
            return objectArray;
        }
    }

    public static SpecificationVersion getModuleDep(Set<Dependency> set, String string) {
        for (Dependency dependency : set) {
            if (dependency.getType() != 1 || dependency.getComparison() != 1) continue;
            try {
                Object[] objectArray = Util.parseCodeName(dependency.getName());
                if (!objectArray[0].equals(string)) continue;
                int n = (Integer)objectArray[1];
                if (n == -1) {
                    n = 0;
                }
                return new SpecificationVersion("" + n + "." + dependency.getVersion());
            }
            catch (NumberFormatException numberFormatException) {
                err.log(Level.WARNING, null, numberFormatException);
                return null;
            }
        }
        return null;
    }

    public static void transitiveClosureModuleDependencies(ModuleManager moduleManager, Set<Module> set) {
        HashSet<Module> hashSet = null;
        while (hashSet == null || !hashSet.isEmpty()) {
            hashSet = new HashSet<Module>();
            for (Module module : set) {
                for (Dependency dependency : module.getDependenciesArray()) {
                    Module module2;
                    if (dependency.getType() != 1 || (module2 = moduleManager.get((String)Util.parseCodeName(dependency.getName())[0])) == null || set.contains((Object)module2)) continue;
                    hashSet.add(module2);
                }
            }
            set.addAll(hashSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ModuleLookup
    extends Lookup {
        private final Set<Module> modules = new HashSet<Module>(100);
        private final Set<ModuleResult> results = new WeakSet(10);

        ModuleLookup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Module module) {
            Set<Module> set = this.modules;
            synchronized (set) {
                this.modules.add(module);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Module module) {
            Set<Module> set = this.modules;
            synchronized (set) {
                this.modules.remove((Object)module);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed() {
            Set<ModuleResult> set = this.results;
            synchronized (set) {
                Iterator<ModuleResult> iterator = this.results.iterator();
                while (iterator.hasNext()) {
                    iterator.next().changed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T lookup(Class<T> clazz) {
            if (!(clazz != Module.class && clazz != ModuleInfo.class && clazz != Object.class && clazz != null || this.modules.isEmpty())) {
                Set<Module> set = this.modules;
                synchronized (set) {
                    return clazz.cast((Object)this.modules.iterator().next());
                }
            }
            return null;
        }

        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            Class clazz = template.getType();
            if (clazz == Module.class || clazz == ModuleInfo.class || clazz == Object.class || clazz == null) {
                return new ModuleResult(template);
            }
            return Lookup.EMPTY.lookup(template);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Set<Module> set = this.modules;
            synchronized (set) {
                return "ModuleLookup" + this.modules;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ModuleItem
        extends Lookup.Item<Module> {
            public static final String PREFIX = "Module[";
            private final Module item;

            public ModuleItem(Module module) {
                this.item = module;
            }

            public Module getInstance() {
                return this.item;
            }

            public Class<? extends Module> getType() {
                return Module.class;
            }

            public String getId() {
                return PREFIX + this.item.getCodeNameBase();
            }

            public String getDisplayName() {
                return this.item.getDisplayName();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ModuleResult
        extends Lookup.Result<Module> {
            private final Lookup.Template<? super Module> t;
            private final Set<LookupListener> listeners = new HashSet<LookupListener>(10);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ModuleResult(Lookup.Template<? super Module> template) {
                this.t = template;
                Set set = ModuleLookup.this.results;
                synchronized (set) {
                    ModuleLookup.this.results.add(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLookupListener(LookupListener lookupListener) {
                Set<LookupListener> set = this.listeners;
                synchronized (set) {
                    this.listeners.add(lookupListener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeLookupListener(LookupListener lookupListener) {
                Set<LookupListener> set = this.listeners;
                synchronized (set) {
                    this.listeners.remove(lookupListener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed() {
                LookupListener[] lookupListenerArray;
                LookupEvent lookupEvent = this.listeners;
                synchronized (lookupEvent) {
                    if (this.listeners.isEmpty()) {
                        return;
                    }
                    lookupListenerArray = this.listeners.toArray(new LookupListener[this.listeners.size()]);
                }
                lookupEvent = new LookupEvent((Lookup.Result)this);
                for (int i = 0; i < lookupListenerArray.length; ++i) {
                    lookupListenerArray[i].resultChanged(lookupEvent);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Collection<Module> allInstances() {
                Set set = ModuleLookup.this.modules;
                synchronized (set) {
                    String string = this.t.getId();
                    Object object = this.t.getInstance();
                    if (string != null) {
                        for (Module module : ModuleLookup.this.modules) {
                            if (!string.equals("Module[" + module.getCodeNameBase()) || object != null && object != module) continue;
                            return Collections.singleton(module);
                        }
                        return Collections.emptySet();
                    }
                    if (object != null) {
                        return ModuleLookup.this.modules.contains(object) ? Collections.singleton(Module.class.cast(object)) : Collections.emptySet();
                    }
                    return new HashSet<Module>(ModuleLookup.this.modules);
                }
            }

            public Set<Class<? extends Module>> allClasses() {
                return Collections.singleton(Module.class);
            }

            public Collection<? extends Lookup.Item<Module>> allItems() {
                Collection<Module> collection = this.allInstances();
                ArrayList<ModuleItem> arrayList = new ArrayList<ModuleItem>(Math.max(1, collection.size()));
                for (Module module : collection) {
                    arrayList.add(new ModuleItem(module));
                }
                return arrayList;
            }

            public String toString() {
                return "ModuleResult:" + this.t;
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File file, String string) {
            String string2 = string.toLowerCase(Locale.US);
            return string2.endsWith(".jar");
        }
    }

    public static interface ModuleProvider {
        public Module getModule();
    }

    public static interface PackageAccessibleClassLoader {
        public Package getPackageAccessibly(String var1);

        public Package[] getPackagesAccessibly();
    }

    static final class FileWithSuffix {
        public final File file;
        public final String suffix;

        FileWithSuffix(File file, String string) {
            this.file = file;
            this.suffix = string;
        }
    }
}

