/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.db.util.DataComboBoxModel;

public final class DataComboBoxSupport {
    private final DataComboBoxModel dataModel;
    private final boolean allowAdding;
    private Object previousItem = null;
    private Object previousNonSpecialItem = null;
    private int previousIndex = -1;
    private boolean performingNewItemAction = false;
    static final Separator SEPARATOR_ITEM = new Separator();
    final Object NEW_ITEM = new Object(){

        public String toString() {
            return DataComboBoxSupport.this.dataModel.getNewItemDisplayName();
        }
    };

    DataComboBoxSupport(JComboBox jComboBox, DataComboBoxModel dataComboBoxModel, boolean bl) {
        this.dataModel = dataComboBoxModel;
        this.allowAdding = bl;
        jComboBox.setEditable(false);
        jComboBox.setModel(new ItemComboBoxModel());
        jComboBox.setRenderer(new ItemListCellRenderer());
        jComboBox.addKeyListener(new ItemKeyListener());
        jComboBox.addActionListener(new ItemActionListener());
        jComboBox.addPopupMenuListener(new ItemPopupMenuListener());
    }

    public static void connect(JComboBox jComboBox, DataComboBoxModel dataComboBoxModel) {
        DataComboBoxSupport.connect(jComboBox, dataComboBoxModel, true);
    }

    public static void connect(JComboBox jComboBox, DataComboBoxModel dataComboBoxModel, boolean bl) {
        new DataComboBoxSupport(jComboBox, dataComboBoxModel, bl);
    }

    private boolean isSpecialItem(Object object) {
        return object == SEPARATOR_ITEM || object == this.NEW_ITEM;
    }

    private void setPreviousNonSpecialItem(JComboBox jComboBox) {
        if (jComboBox.getSelectedItem() == this.NEW_ITEM) {
            jComboBox.setSelectedItem(this.previousNonSpecialItem);
        }
    }

    private final class ItemPopupMenuListener
    implements PopupMenuListener {
        private ItemPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)popupMenuEvent.getSource());
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)popupMenuEvent.getSource());
            }
        }
    }

    private final class ItemActionListener
    implements ActionListener {
        private ItemActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            final JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object == SEPARATOR_ITEM) {
                int n = -1;
                if (DataComboBoxSupport.this.previousIndex != -1) {
                    int n2 = jComboBox.getSelectedIndex();
                    n = n2 > DataComboBoxSupport.this.previousIndex ? n2 + 1 : n2 - 1;
                }
                jComboBox.setSelectedIndex(n);
            } else if ((actionEvent.getModifiers() & 0x10) != 0 && object == DataComboBoxSupport.this.NEW_ITEM) {
                DataComboBoxSupport.this.performingNewItemAction = true;
                try {
                    jComboBox.setPopupVisible(false);
                    DataComboBoxSupport.this.dataModel.newItemActionPerformed();
                }
                finally {
                    DataComboBoxSupport.this.performingNewItemAction = false;
                }
                DataComboBoxSupport.this.setPreviousNonSpecialItem(jComboBox);
                final Object object2 = jComboBox.getSelectedItem();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jComboBox.setSelectedItem(object2);
                    }
                });
            }
        }
    }

    private final class ItemKeyListener
    extends KeyAdapter {
        private ItemKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            Object object;
            JComboBox jComboBox = (JComboBox)keyEvent.getSource();
            int n = keyEvent.getKeyCode();
            if (10 == n && (object = jComboBox.getSelectedItem()) == DataComboBoxSupport.this.NEW_ITEM) {
                DataComboBoxSupport.this.performingNewItemAction = true;
                try {
                    jComboBox.setPopupVisible(false);
                    keyEvent.consume();
                    DataComboBoxSupport.this.dataModel.newItemActionPerformed();
                }
                finally {
                    DataComboBoxSupport.this.performingNewItemAction = false;
                }
                DataComboBoxSupport.this.setPreviousNonSpecialItem(jComboBox);
            }
        }
    }

    private class ItemListCellRenderer
    extends DefaultListCellRenderer {
        private ItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            JLabel jLabel = (JLabel)component;
            if (object != null && !DataComboBoxSupport.this.isSpecialItem(object)) {
                String string = DataComboBoxSupport.this.dataModel.getItemDisplayName(object);
                jLabel.setText(DataComboBoxSupport.this.dataModel.getItemDisplayName(object));
                jLabel.setToolTipText(DataComboBoxSupport.this.dataModel.getItemTooltipText(object));
            } else {
                if (object == SEPARATOR_ITEM) {
                    return SEPARATOR_ITEM;
                }
                if (object != null) {
                    jLabel.setText(object.toString());
                    jLabel.setToolTipText(null);
                }
            }
            return jLabel;
        }
    }

    private class ItemComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        public ItemComboBoxModel() {
            this.getDelegate().addListDataListener(this);
        }

        public Object getElementAt(int n) {
            if (DataComboBoxSupport.this.allowAdding) {
                if (this.getSize() == 1) {
                    if (n == 0) {
                        return DataComboBoxSupport.this.NEW_ITEM;
                    }
                    throw new IllegalStateException("Index out of bounds: " + n);
                }
                if (n >= 0 && n < this.getDelegate().getSize()) {
                    return this.getDelegate().getElementAt(n);
                }
                if (n == this.getSize() - 2) {
                    return SEPARATOR_ITEM;
                }
                if (n == this.getSize() - 1) {
                    return DataComboBoxSupport.this.NEW_ITEM;
                }
                throw new IllegalStateException("Index out of bounds: " + n);
            }
            return this.getDelegate().getElementAt(n);
        }

        public int getSize() {
            if (DataComboBoxSupport.this.allowAdding) {
                return this.getDelegate().getSize() == 0 ? 1 : this.getDelegate().getSize() + 2;
            }
            return this.getDelegate().getSize();
        }

        public void setSelectedItem(Object object) {
            DataComboBoxSupport.this.previousItem = this.getDelegate().getSelectedItem();
            DataComboBoxSupport.this.previousIndex = this.getItemIndex(DataComboBoxSupport.this.previousItem);
            if (!DataComboBoxSupport.this.isSpecialItem(DataComboBoxSupport.this.previousItem)) {
                DataComboBoxSupport.this.previousNonSpecialItem = DataComboBoxSupport.this.previousItem;
            }
            this.getDelegate().setSelectedItem(object);
        }

        public Object getSelectedItem() {
            return this.getDelegate().getSelectedItem();
        }

        public Object getPreviousItem() {
            return DataComboBoxSupport.this.previousItem;
        }

        private ComboBoxModel getDelegate() {
            return DataComboBoxSupport.this.dataModel.getListModel();
        }

        private int getItemIndex(Object object) {
            if (object == null) {
                return -1;
            }
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setForeground(Color.BLACK);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width, 1);
        }
    }
}

