/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bracesmatching;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class ControlPanel
extends JPanel {
    private static String[][] SEARCH_DIRECTIONS = new String[][]{{"backward-preferred", "Backward Preferred"}, {"forward-preferred", "Forward Preferred"}};
    private static String[][] CARET_BIAS = new String[][]{{"backward", "Backward (before caret)"}, {"forward", "Forward (after caret)"}};
    private JTextComponent component;
    private JTextField backwardLookahead;
    private JComboBox caretBias;
    private JTextField forwardLookahead;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JComboBox searchDirection;
    private JCheckBox showParameters;

    public ControlPanel(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.initComponents();
        this.backwardLookahead.setText(ControlPanel.getBwdLookahead(jTextComponent));
        this.forwardLookahead.setText(ControlPanel.getFwdLookahead(jTextComponent));
        this.searchDirection.setSelectedItem(ControlPanel.getSearchDirection(jTextComponent));
        this.caretBias.setSelectedItem(ControlPanel.getCaretBias(jTextComponent));
        this.showParameters.setSelected(ControlPanel.getShowParameters(jTextComponent));
    }

    public void applyChanges() {
        ControlPanel.setBwdLookahead(this.component, this.backwardLookahead.getText());
        ControlPanel.setFwdLookahead(this.component, this.forwardLookahead.getText());
        ControlPanel.setSearchDirection(this.component, (String)this.searchDirection.getSelectedItem());
        ControlPanel.setCaretBias(this.component, (String)this.caretBias.getSelectedItem());
        ControlPanel.setShowParameters(this.component, this.showParameters.isSelected());
    }

    private static String getBwdLookahead(JTextComponent jTextComponent) {
        Object object = jTextComponent.getClientProperty("nbeditor-bracesMatching-maxBackwardLookahead");
        return object == null ? "" : object.toString();
    }

    private static void setBwdLookahead(JTextComponent jTextComponent, String string) {
        if (string == null || string.trim().length() == 0) {
            jTextComponent.putClientProperty("nbeditor-bracesMatching-maxBackwardLookahead", null);
        } else {
            jTextComponent.putClientProperty("nbeditor-bracesMatching-maxBackwardLookahead", string);
        }
    }

    private static String getFwdLookahead(JTextComponent jTextComponent) {
        Object object = jTextComponent.getClientProperty("nbeditor-bracesMatching-maxForwardLookahead");
        return object == null ? "" : object.toString();
    }

    private static void setFwdLookahead(JTextComponent jTextComponent, String string) {
        if (string == null || string.trim().length() == 0) {
            jTextComponent.putClientProperty("nbeditor-bracesMatching-maxForwardLookahead", null);
        } else {
            jTextComponent.putClientProperty("nbeditor-bracesMatching-maxForwardLookahead", string);
        }
    }

    private static String getSearchDirection(JTextComponent jTextComponent) {
        Object object = jTextComponent.getClientProperty("nbeditor-bracesMatching-searchDirection");
        if (object != null) {
            String string = object.toString();
            for (String[] stringArray : SEARCH_DIRECTIONS) {
                if (!stringArray[0].equals(string)) continue;
                return stringArray[1];
            }
        }
        return "";
    }

    private static void setSearchDirection(JTextComponent jTextComponent, String string) {
        String string2 = null;
        if (string != null) {
            for (String[] stringArray : SEARCH_DIRECTIONS) {
                if (!stringArray[1].equals(string)) continue;
                string2 = stringArray[0];
                break;
            }
        }
        jTextComponent.putClientProperty("nbeditor-bracesMatching-searchDirection", string2);
    }

    private static String getCaretBias(JTextComponent jTextComponent) {
        Object object = jTextComponent.getClientProperty("nbeditor-bracesMatching-caretBias");
        if (object != null) {
            String string = object.toString();
            for (String[] stringArray : CARET_BIAS) {
                if (!stringArray[0].equals(string)) continue;
                return stringArray[1];
            }
        }
        return "";
    }

    private static void setCaretBias(JTextComponent jTextComponent, String string) {
        String string2 = null;
        if (string != null) {
            for (String[] stringArray : CARET_BIAS) {
                if (!stringArray[1].equals(string)) continue;
                string2 = stringArray[0];
                break;
            }
        }
        jTextComponent.putClientProperty("nbeditor-bracesMatching-caretBias", string2);
    }

    private static boolean getShowParameters(JTextComponent jTextComponent) {
        return Boolean.valueOf((String)jTextComponent.getClientProperty("debug-showSearchParameters-dont-ever-use-it-or-you-will-die"));
    }

    private static void setShowParameters(JTextComponent jTextComponent, boolean bl) {
        jTextComponent.putClientProperty("debug-showSearchParameters-dont-ever-use-it-or-you-will-die", Boolean.toString(bl));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.backwardLookahead = new JTextField();
        this.forwardLookahead = new JTextField();
        this.searchDirection = new JComboBox();
        this.jLabel4 = new JLabel();
        this.caretBias = new JComboBox();
        this.showParameters = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(ControlPanel.class, (String)"jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(ControlPanel.class, (String)"jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(ControlPanel.class, (String)"jLabel3.text"));
        this.backwardLookahead.setText(NbBundle.getMessage(ControlPanel.class, (String)"backwardLookahead.text"));
        this.forwardLookahead.setText(NbBundle.getMessage(ControlPanel.class, (String)"forwardLookahead.text"));
        this.searchDirection.setModel(new DefaultComboBoxModel<String>(new String[]{"", "Backward Preferred", "Forward Preferred"}));
        this.jLabel4.setText(NbBundle.getMessage(ControlPanel.class, (String)"jLabel4.text"));
        this.caretBias.setModel(new DefaultComboBoxModel<String>(new String[]{"", "Backward (before caret)", "Forward (after caret)"}));
        this.showParameters.setText(NbBundle.getMessage(ControlPanel.class, (String)"jCheckBox1.text_1"));
        this.showParameters.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showParameters.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel5.setText(NbBundle.getMessage(ControlPanel.class, (String)"jLabel5.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1, -2, 183, -2).addPreferredGap(0).add((Component)this.backwardLookahead, -1, 181, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2, -2, 183, -2).addPreferredGap(0).add((Component)this.forwardLookahead, -1, 181, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel3, -2, 183, -2).addPreferredGap(0).add((Component)this.searchDirection, 0, 181, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel4, -2, 183, -2).add((Component)this.jLabel5, -2, 183, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.showParameters).add((Component)this.caretBias, 0, 181, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.backwardLookahead, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.forwardLookahead, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.searchDirection, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.caretBias, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.showParameters).add((Component)this.jLabel5)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

