/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.CustomChooserVisualPanel;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

public class CustomChooserWizardPanel
implements WizardDescriptor.Panel {
    private WizardDescriptor wizard;
    private CustomChooserVisualPanel component;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public CustomChooserWizardPanel(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new CustomChooserVisualPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (this.component == null) {
            return false;
        }
        try {
            this.component.validateForm();
            this.getWizard().putProperty("WizardPanel_errorMessage", null);
            return true;
        }
        catch (Exception ex) {
            this.getWizard().putProperty("WizardPanel_errorMessage", (Object)ex.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        block11: {
            if (settings instanceof TemplateWizard) {
                try {
                    DataObject dObj;
                    if (((TemplateWizard)settings).getTargetFolder() == null) break block11;
                    ((CustomChooserVisualPanel)this.getComponent()).setTargetDirectory(Misc.getDataFolderPath(((TemplateWizard)settings).getTargetFolder()));
                    String name = ((TemplateWizard)settings).getTemplate().getPrimaryFile().getNameExt();
                    if (name == null) {
                        name = "file";
                    }
                    String ext = "";
                    if (name.lastIndexOf(".") > 0) {
                        ext = name.substring(name.lastIndexOf("."), name.length());
                        name = name.substring(0, name.lastIndexOf("."));
                    }
                    if ((dObj = ((TemplateWizard)settings).getTemplate()) != null && dObj.getPrimaryFile().getAttribute("extension") != null && !(ext = "" + dObj.getPrimaryFile().getAttribute("extension")).startsWith(".")) {
                        ext = "." + ext;
                    }
                    if (ext.toLowerCase().equals(".properties")) {
                        for (int i = 0; i < 1000; ++i) {
                            String tmpName = "Bundle" + (i > 0 ? i + "" : "");
                            File f = new File(Misc.getDataFolderPath(((TemplateWizard)settings).getTargetFolder()), tmpName + ".properties");
                            if (f.exists()) continue;
                            this.component.setReportName(tmpName);
                            this.component.setExtension(".properties");
                            break block11;
                        }
                        break block11;
                    }
                    if (ext.toLowerCase().equals(".jrxml")) {
                        for (int i = 1; i < 1000; ++i) {
                            File f = new File(Misc.getDataFolderPath(((TemplateWizard)settings).getTargetFolder()), "report" + i + ".jrxml");
                            if (f.exists()) continue;
                            this.component.setReportName("report" + i);
                            this.component.setExtension(".jrxml");
                            break block11;
                        }
                        break block11;
                    }
                    for (int i = 1; i < 1000; ++i) {
                        File f = new File(Misc.getDataFolderPath(((TemplateWizard)settings).getTargetFolder()), name + i + ext);
                        if (f.exists()) continue;
                        this.component.setReportName(name + i);
                        this.component.setExtension(ext);
                        break;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void storeSettings(Object settings) {
        ((WizardDescriptor)settings).putProperty("filename", (Object)this.component.getFileName());
        ((WizardDescriptor)settings).putProperty("reportname", (Object)this.component.getReportName());
        if (settings instanceof TemplateWizard) {
            File f = new File(this.component.getFileName());
            if (f.getParentFile() != null && f.getParentFile().exists()) {
                IReportManager.getPreferences().put("CURRENT_DIRECTORY", f.getParent());
            }
            try {
                ((TemplateWizard)settings).setTargetFolder(DataFolder.findFolder((FileObject)FileUtil.toFileObject((File)f.getParentFile())));
                ((TemplateWizard)settings).setTargetName(this.component.getReportName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public WizardDescriptor getWizard() {
        return this.wizard;
    }

    public void setWizard(WizardDescriptor wizard) {
        this.wizard = wizard;
    }
}

