/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;

public class DeleteElementGroupUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignElementGroup group = null;
    private Object container = null;
    private int index = -1;

    public DeleteElementGroupUndoableEdit(JRDesignElementGroup group, Object container, int index) {
        this.group = group;
        this.container = container;
        this.index = index;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        if (this.container instanceof JRDesignElementGroup) {
            JRDesignElementGroup cg = (JRDesignElementGroup)this.container;
            this.group.setElementGroup((JRElementGroup)cg);
            cg.getChildren().add(this.index, this.group);
            cg.getEventSupport().fireCollectionElementAddedEvent("children", (Object)this.group, cg.getChildren().size() - 1);
        } else if (this.container instanceof JRDesignFrame) {
            JRDesignFrame cg = (JRDesignFrame)this.container;
            this.group.setElementGroup((JRElementGroup)cg);
            cg.getChildren().add(this.index, this.group);
            cg.getEventSupport().fireCollectionElementAddedEvent("children", (Object)this.group, cg.getChildren().size() - 1);
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        if (this.container instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)this.container).removeElementGroup(this.group);
        } else if (this.container instanceof JRDesignFrame) {
            ((JRDesignFrame)this.container).removeElementGroup((JRElementGroup)this.group);
        }
    }

    public String getPresentationName() {
        return "Delete element group";
    }

    public JRDesignElementGroup getGroup() {
        return this.group;
    }

    public void setGroup(JRDesignElementGroup group) {
        this.group = group;
    }
}

