/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import org.openide.nodes.PropertySupport;

public final class LineSpacingProperty
extends PropertySupport {
    private final JRBaseStyle style;
    private ComboBoxPropertyEditor editor;

    public LineSpacingProperty(JRBaseStyle style) {
        super("lineSpacing", Byte.class, I18n.getString("AbstractStyleNode.Property.Line_Spacing"), I18n.getString("AbstractStyleNode.Property.LSDetail"), true, true);
        this.style = style;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(null, "<Default>"));
            l.add(new Tag(new Byte(0), I18n.getString("AbstractStyleNode.Property.Single")));
            l.add(new Tag(new Byte(1), I18n.getString("AbstractStyleNode.Property.1-5")));
            l.add(new Tag(new Byte(2), I18n.getString("AbstractStyleNode.Property.Double")));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.style.getLineSpacing();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val == null || val instanceof Byte) {
            Byte oldValue = this.style.getOwnLineSpacing();
            Byte newValue = (Byte)val;
            this.style.setLineSpacing(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "LineSpacing", Byte.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.style.getOwnLineSpacing() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

