/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties.charts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.StringListProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;

public final class ThemeProperty
extends StringListProperty
implements PreferenceChangeListener {
    private List<Tag> tags = null;
    private final JRDesignChart chart;

    public ThemeProperty(JRDesignChart chart) {
        super(chart);
        this.chart = chart;
        IReportManager.getPreferences().addPreferenceChangeListener(this);
    }

    public String getName() {
        return "net.sf.jasperreports.chart.theme";
    }

    public String getDisplayName() {
        return "Theme";
    }

    public String getShortDescription() {
        return "The theme to use to render the chart.";
    }

    public List getTagList() {
        if (this.tags == null) {
            this.updateTags();
        }
        return this.tags;
    }

    private void updateTags() {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
        HashSet<String> themeNamesSet = new HashSet<String>();
        List themeBundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(ChartThemeBundle.class);
        for (ChartThemeBundle bundle : themeBundles) {
            String[] themeNames = bundle.getChartThemeNames();
            themeNamesSet.addAll(Arrays.asList(themeNames));
        }
        Object[] allThemeNames = themeNamesSet.toArray(new String[themeNamesSet.size()]);
        Arrays.sort(allThemeNames);
        Thread.currentThread().setContextClassLoader(oldCL);
        this.tags = new ArrayList<Tag>(allThemeNames.length);
        for (int i = 0; i < allThemeNames.length; ++i) {
            this.tags.add(new Tag((String)allThemeNames[i]));
        }
    }

    public String getString() {
        return this.chart.getTheme();
    }

    public String getOwnString() {
        return this.chart.getTheme();
    }

    public String getDefaultString() {
        return null;
    }

    public void setString(String renderType) {
        this.chart.setTheme(renderType);
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt == null || evt.getKey() == null || evt.getKey().equals("IREPORT_CLASSPATH")) {
            this.updateTags();
            ((ComboBoxPropertyEditor)this.getPropertyEditor()).setTagValues(this.getTagList());
        }
    }
}

