/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.jrctx.JRCTXEditorSupport;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.XmlChartThemeExtensionsRegistryFactory;
import org.jdesktop.layout.GroupLayout;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class ExportToJarDialog
extends JDialog {
    private JRCTXEditorSupport editorSupport = null;
    private JButton jButtonBrowse;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelError;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDestination;
    private JTextField jTextFieldName;

    public ExportToJarDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jTextFieldDestination.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ExportToJarDialog.this.checkFile();
            }

            public void removeUpdate(DocumentEvent e) {
                ExportToJarDialog.this.checkFile();
            }

            public void changedUpdate(DocumentEvent e) {
                ExportToJarDialog.this.checkFile();
            }
        });
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ExportToJarDialog.this.checkFile();
            }

            public void removeUpdate(DocumentEvent e) {
                ExportToJarDialog.this.checkFile();
            }

            public void changedUpdate(DocumentEvent e) {
                ExportToJarDialog.this.checkFile();
            }
        });
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldDestination = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jLabelError = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jCheckBox1 = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.title"));
        this.jLabel1.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel2.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jLabel2.text"));
        this.jTextFieldDestination.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jTextFieldDestination.text"));
        this.jButtonBrowse.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jButtonBrowse.text"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToJarDialog.this.jButtonBrowseActionPerformed(evt);
            }
        });
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/export_jrctx.png")));
        this.jLabel3.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jLabel3.text"));
        this.jButtonCancel.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToJarDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jButtonOk.text"));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportToJarDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jLabelError.setForeground(new Color(204, 0, 0));
        this.jLabelError.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jLabelError.text"));
        this.jLabelError.setVerticalAlignment(3);
        this.jLabel4.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jLabel4.text"));
        this.jTextFieldName.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jTextFieldName.text"));
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.jCheckBox1.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 412, Short.MAX_VALUE).add((Component)this.jLabelError, -1, 412, Short.MAX_VALUE).add((Component)this.jLabel4).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jLabel2).add((Component)this.jTextFieldDestination, -1, 327, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonBrowse)).add((Component)this.jTextFieldName, -1, 412, Short.MAX_VALUE).add((Component)this.jCheckBox1)).addContainerGap()).add((Component)this.jSeparator1, -1, 632, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(486, Short.MAX_VALUE).add((Component)this.jButtonOk).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 46, -2).add(3, 3, 3).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldName, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonBrowse).add((Component)this.jTextFieldDestination, -2, -1, -2)).add(18, 18, 18).add((Component)this.jCheckBox1).addPreferredGap(0).add((Component)this.jLabelError, -2, 39, -2)).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOk)).addContainerGap()));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportToJarDialog.class, (String)"ExportToJarDialog.AccessibleContext.accessibleName"));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        try {
            List<String> cp;
            File newFile = new File(this.jTextFieldDestination.getText());
            if (newFile.exists() && JOptionPane.showConfirmDialog(Misc.getMainFrame(), I18n.getString("LBL_File_Exists", (Object)newFile.getName()), NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsAction"), 0, 2) != 0) {
                return;
            }
            XmlChartThemeExtensionsRegistryFactory.saveToJar((ChartThemeSettings)this.editorSupport.getCurrentModel(), (String)this.jTextFieldName.getText(), (File)newFile);
            if (this.jCheckBox1.isSelected() && !(cp = IReportManager.getInstance().getRelodableClasspath()).contains("" + newFile)) {
                cp.add("" + newFile);
                IReportManager.getInstance().setRelodableClasspath(cp);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), I18n.getString("ExportToJarDialog.fileExported"), "", 1);
                }
            });
        }
        catch (Throwable t) {
            this.jLabelError.setText("<html>" + I18n.getString("ExportToJarDialog.errorOnExport", (Object)t.getMessage()));
            t.printStackTrace();
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".jar") || file.isDirectory();
            }

            public String getDescription() {
                return "JAR *.jar";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            try {
                this.jTextFieldDestination.setText(file.getAbsolutePath());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void checkFile() {
        this.jLabelError.setText("");
        this.jButtonOk.setEnabled(true);
        if (this.jTextFieldName.getText().length() == 0) {
            this.jLabelError.setText("Invalid theme name");
            this.jButtonOk.setEnabled(false);
            return;
        }
        if (this.jTextFieldDestination.getText().length() == 0) {
            this.jLabelError.setText("Invalid file name");
            this.jButtonOk.setEnabled(false);
            return;
        }
    }

    public void setJRCTXEditorSupport(JRCTXEditorSupport editorSupport) {
        this.editorSupport = editorSupport;
        File f = FileUtil.toFile((FileObject)editorSupport.getDataObject().getPrimaryFile());
        String s = Misc.changeFileExtension(f.getName(), "");
        if (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        this.jTextFieldName.setText(s);
        this.jTextFieldDestination.setText(Misc.changeFileExtension(f.getName(), "jar"));
        this.checkFile();
    }
}

