/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.IRFont;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.fonts.TTFFontsLoaderMonitor;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTFFontsLoader {
    public static Font loadFont(String file) {
        Font f = null;
        try {
            f = Font.createFont(0, new FileInputStream(file));
        }
        catch (IllegalArgumentException ett) {
            System.out.println(ett.getMessage() + " No TrueType font");
        }
        catch (FontFormatException ef) {
            System.out.println(ef.getMessage() + " FontFormatException");
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage() + " IOException");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage() + " General Exception");
        }
        return f;
    }

    public static List<IRFont> loadTTFFonts() {
        return TTFFontsLoader.loadTTFFonts(null);
    }

    public static List<IRFont> loadTTFFonts(TTFFontsLoaderMonitor monitor) {
        if (monitor != null) {
            monitor.fontsLoadingStarted();
        }
        if (monitor != null) {
            monitor.fontsLoadingStatusUpdated("Initializing font loader");
        }
        ArrayList<IRFont> fonts = new ArrayList<IRFont>();
        List<String> fontsPaths = IReportManager.getInstance().getFontpath();
        if (fontsPaths == null || fontsPaths.size() == 0) {
            fontsPaths = IReportManager.getInstance().getClasspath();
        }
        for (String path_str : fontsPaths) {
            TTFFontsLoader.addFontNames(fonts, path_str, monitor);
        }
        if (monitor != null) {
            monitor.fontsLoadingFinished();
        }
        return fonts;
    }

    public static void addFontNames(List<IRFont> fonts, String path_str, TTFFontsLoaderMonitor monitor) {
        MessageFormat formatter = new MessageFormat("Loaded font {0}");
        File file = new File(path_str);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] files = file.list(new FilenameFilter(){

                public boolean accept(File dir, String filename) {
                    return filename.toUpperCase().endsWith(".TTF") || filename.toUpperCase().endsWith(".TTC");
                }
            });
            DefaultFontMapper fontMapper = new DefaultFontMapper();
            if (files == null) {
                System.out.println(Misc.formatString("Unable to list files in: {0}", new Object[]{"" + file}));
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (files[i].toUpperCase().endsWith(".TTC")) {
                        try {
                            String[] names = BaseFont.enumerateTTCNames((String)(file.getPath() + File.separator + files[i]));
                            for (int a = 0; a < names.length; ++a) {
                                Font f = fontMapper.pdfToAwt(FontFactory.getFont((String)(file.getPath() + File.separator + files[i])).getBaseFont(), 10);
                                if (f != null) {
                                    fonts.add(new IRFont(f, files[i]));
                                } else {
                                    System.out.println(Misc.formatString("Failed to load font {0}", new Object[]{"" + file.getPath() + File.separator + files[i]}));
                                }
                                if (monitor == null) continue;
                                monitor.fontsLoadingStatusUpdated(formatter.format(new Object[]{file.getPath() + File.separator + files[i]}));
                            }
                            continue;
                        }
                        catch (DocumentException de) {
                            System.out.println((Object)de);
                            continue;
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe);
                            continue;
                        }
                    }
                    Font f = TTFFontsLoader.loadFont(file.getPath() + File.separator + files[i]);
                    if (f != null) {
                        fonts.add(new IRFont(f, files[i]));
                    } else {
                        System.out.println(Misc.formatString("Failed to load font {0}", new Object[]{"" + file.getPath() + File.separator + files[i]}));
                    }
                    if (monitor == null) continue;
                    monitor.fontsLoadingStatusUpdated(formatter.format(new Object[]{file.getPath() + File.separator + files[i]}));
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(Misc.formatString("Invalid font found: {0}. Font skipped.", new Object[]{files[i]}));
                }
            }
        } else if (path_str.toUpperCase().endsWith(".TTF") || path_str.toUpperCase().endsWith(".TTC")) {
            // empty if block
        }
    }
}

