/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.locale.I18n;
import java.util.HashMap;
import java.util.Map;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class PasteFormatAction
extends NodeAction {
    public static final String[] propertyNames = new String[]{"backcolor", "blankWhenNull", "bold", "fill", "fontName", "fontSize", "forecolor", "horizontalAlignment", "italic", "lineSpacing", "markup", "mode", "pattern", "pdfEmbedded", "pdfEncoding", "pdfFontName", "radius", "rotation", "scaleImage", "strikeThrough", "underline", "verticalAlignment", "parentStyle"};
    public static final Map formattingValues = new HashMap();

    public String getName() {
        return I18n.getString("CopyFormatAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        Node node = activatedNodes[0];
        formattingValues.clear();
        for (int i = 0; i < propertyNames.length; ++i) {
            Object val = this.getPropertyValue(node, propertyNames[i]);
            if (val == null) continue;
            formattingValues.put(propertyNames[i], val);
        }
    }

    protected Object getPropertyValue(Node node, String prop) {
        Node.PropertySet[] sets = node.getPropertySets();
        Node.Property p = ModelUtils.findProperty(sets, prop);
        try {
            return p.getValue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (!(activatedNodes[0] instanceof ElementNode)) {
            return false;
        }
        return false;
    }
}

