/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.JrxmlDataNode;
import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlEditorSupport;
import com.jaspersoft.ireport.designer.JrxmlLoader;
import com.jaspersoft.ireport.designer.ModelChangeListener;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.ReportDesignerPanel;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.errorhandler.DesignVerifyerThread;
import com.jaspersoft.ireport.designer.errorhandler.ProblemItem;
import com.jaspersoft.ireport.designer.outline.OutlineTopComponent;
import com.jaspersoft.ireport.designer.outline.nodes.CellNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.outline.nodes.ReportNode;
import com.jaspersoft.ireport.designer.tools.JrxmlEditorToolbar;
import com.jaspersoft.ireport.designer.undo.UndoRedoManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.palette.PaletteController;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JrxmlVisualView
extends TopComponent
implements ObjectSceneListener,
MultiViewDescription,
MultiViewElement,
DocumentListener,
JrxmlDataNode.ChangeCallback,
Runnable,
ExplorerManager.Provider {
    private transient ExplorerManager explorerManager;
    public static final String PREFERRED_ID = "ireport_visual_view";
    private JrxmlEditorSupport support;
    private ReportDesignerPanel reportDesignerPanel = null;
    private boolean elementInitialized = false;
    private List<ProblemItem> reportProblems = new ArrayList<ProblemItem>();
    private DesignVerifyerThread verifyerThread = null;
    private JrxmlEditorToolbar toolbar = null;
    private JasperDesign jasperDesign = null;
    private boolean settingSelection = false;
    private ReportNode model = null;
    private boolean needModelRefresh = true;
    MultiViewElementCallback callback = null;
    InstanceContent ic;
    AbstractLookup abstractLookup;
    final JasperDesignerTypeLookupHint hint = new JasperDesignerTypeLookupHint();
    private ProxyLookup lookup = null;
    public static int num = 0;
    private static PaletteController pc;
    private static Boolean groupVisible;
    boolean loading = false;
    private UndoRedoManager undoRedoManager = null;
    private Set<ModelChangeListener> listeners = new HashSet<ModelChangeListener>(1);

    private synchronized boolean isSettingSelection() {
        return this.settingSelection;
    }

    private synchronized void setSettingSelection(boolean b) {
        this.settingSelection = b;
    }

    public JrxmlEditorSupport getEditorSupport() {
        return this.support;
    }

    public ReportNode getModel() {
        return this.model;
    }

    public ReportDesignerPanel getReportDesignerPanel() {
        return this.reportDesignerPanel;
    }

    public static PaletteController getPaletteFromMimeType(String mimeType) {
        MimePath path = MimePath.get((String)mimeType);
        Lookup lkp = MimeLookup.getLookup((MimePath)path);
        return (PaletteController)lkp.lookup(PaletteController.class);
    }

    public JrxmlVisualView(JrxmlEditorSupport ed) {
        this.support = ed;
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getDisplayName() {
        return I18n.getString("view.designer");
    }

    public Image getIcon() {
        Node nd = ((JrxmlDataObject)this.support.getDataObject()).getNodeDelegate();
        return nd.getIcon(1);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public MultiViewElement createElement() {
        if (!this.elementInitialized) {
            try {
                assert (EventQueue.isDispatchThread());
                this.elementInitialized = true;
                this.ic = new InstanceContent();
                this.explorerManager = new ExplorerManager();
                ActionMap map = this.getActionMap();
                this.verifyerThread = new DesignVerifyerThread(this);
                map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
                map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
                map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
                map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)true));
                this.abstractLookup = new AbstractLookup((AbstractLookup.Content)this.ic);
                if (pc == null) {
                    pc = JrxmlVisualView.getPaletteFromMimeType("text/x-jrxml+xml");
                }
                this.lookup = new ProxyLookup(new Lookup[]{this.abstractLookup, ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map), this.support.getDataObject().getLookup(), Lookups.fixed((Object[])new Object[]{pc})});
                this.associateLookup((Lookup)this.lookup);
                this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("selectedNodes".equals(evt.getPropertyName()) && OutlineTopComponent.getDefault() != null) {
                            try {
                                OutlineTopComponent.getDefault().getExplorerManager().setSelectedNodes(JrxmlVisualView.this.explorerManager.getSelectedNodes());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                this.removeAll();
                this.support.openDocument().addDocumentListener(this);
                this.reportDesignerPanel = new ReportDesignerPanel();
                this.setLayout(new BorderLayout());
                this.add(this.reportDesignerPanel, "Center");
                this.reportDesignerPanel.addObjectSelectionListener(this);
                this.verifyerThread.start();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JrxmlEditorToolbar();
        }
        return this.toolbar;
    }

    public void componentOpened() {
        this.setNeedModelRefresh(false);
        this.refreshModel();
    }

    public void componentClosed() {
        OutlineTopComponent.getDefault().closingJrxmlVisualView(this);
    }

    public void componentShowing() {
        if (this.isNeedModelRefresh()) {
            this.refreshModel();
        } else {
            this.support.setCurrentModel(this.jasperDesign);
        }
        if (OutlineTopComponent.getDefault() != null) {
            OutlineTopComponent.getDefault().setCurrentJrxmlVisualView(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNodes(Node[] selectedNodes) {
        if (this.isSettingSelection()) {
            return;
        }
        try {
            this.setSettingSelection(true);
            this.explorerManager.setSelectedNodes(selectedNodes);
            HashSet<Object> selectedObjects = new HashSet<Object>();
            for (int i = 0; i < selectedNodes.length; ++i) {
                if (selectedNodes[i] instanceof ElementNode) {
                    selectedObjects.add(((ElementNode)selectedNodes[i]).getElement());
                    continue;
                }
                if (!(selectedNodes[i] instanceof CellNode)) continue;
                selectedObjects.add(((CellNode)selectedNodes[i]).getCellContents());
            }
            this.getReportDesignerPanel().setSelectedObjects(selectedObjects);
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.setSettingSelection(false);
        }
    }

    private void updateGroupVisibility() {
        WindowManager wm = WindowManager.getDefault();
        TopComponentGroup group = wm.findTopComponentGroup("ireport");
        if (group == null) {
            return;
        }
        boolean isVisualViewSelected = false;
        for (Mode mode : wm.getModes()) {
            String id;
            MultiViewPerspective mvp;
            MultiViewHandler mvh;
            TopComponent selected = mode.getSelectedTopComponent();
            if (selected == null || (mvh = MultiViews.findMultiViewHandler((TopComponent)selected)) == null || (mvp = mvh.getSelectedPerspective()) == null || !PREFERRED_ID.equals(id = mvp.preferredID())) continue;
            isVisualViewSelected = true;
            break;
        }
        if (isVisualViewSelected && !Boolean.TRUE.equals(groupVisible)) {
            group.open();
            TopComponent props = wm.findTopComponent("properties");
            if (props != null && props.isVisible()) {
                try {
                    props.getClass().getMethod("setNodes", new Node[0].getClass()).invoke((Object)props, new Object[]{this.getExplorerManager().getSelectedNodes()});
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (!isVisualViewSelected && !Boolean.FALSE.equals(groupVisible)) {
            group.close();
        }
        groupVisible = isVisualViewSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        try {
            this.model = null;
            RequestProcessor.getDefault().post((Runnable)this);
        }
        finally {
            this.setNeedModelRefresh(false);
        }
    }

    public void componentHidden() {
        if (OutlineTopComponent.getDefault() != null) {
            OutlineTopComponent.getDefault().closingJrxmlVisualView(this);
        }
    }

    public void componentActivated() {
        this.ic.add((Object)this.getReportDesignerPanel());
        this.updateGroupVisibility();
        if (this.getReportDesignerPanel() != null && this.getReportDesignerPanel().getActiveScene() != null && this.getReportDesignerPanel().getActiveScene().getView() != null) {
            this.getReportDesignerPanel().getActiveScene().getView().requestFocusInWindow();
        }
    }

    public void componentDeactivated() {
        this.ic.remove((Object)this.getReportDesignerPanel());
        this.updateGroupVisibility();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
        this.updateName();
    }

    public CloseOperationState canCloseElement() {
        if (this.getEditorSupport().isModified()) {
            return MultiViewFactory.createUnsafeCloseState((String)PREFERRED_ID, null, null);
        }
        return CloseOperationState.STATE_OK;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    public synchronized void setNeedModelRefresh(boolean b) {
        this.needModelRefresh = b;
    }

    public boolean isNeedModelRefresh() {
        return this.needModelRefresh;
    }

    public boolean isLoading() {
        return this.loading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.loading = true;
        try {
            this.support.setCurrentModel(null);
            System.gc();
            Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
            JrxmlLoader jrxmlLoader = new JrxmlLoader();
            this.jasperDesign = jrxmlLoader.reloadJasperDesign(this.support.getInputStream());
            if (this.jasperDesign == null) {
                if (this.reportDesignerPanel.getJasperDesign() == null) {
                    // empty if block
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (JrxmlVisualView.this.reportDesignerPanel == null) {
                            return;
                        }
                        JrxmlVisualView.this.reportDesignerPanel.setJasperDesign(JrxmlVisualView.this.jasperDesign);
                        JrxmlVisualView.this.model = new ReportNode(JrxmlVisualView.this.jasperDesign, JrxmlVisualView.this.support.getSpecialNodeLookup());
                        JrxmlVisualView.this.getUndoRedoManager().discardAllEdits();
                        JrxmlVisualView.this.explorerManager.setRootContext((Node)JrxmlVisualView.this.model);
                        JrxmlVisualView.this.support.setCurrentModel(JrxmlVisualView.this.jasperDesign);
                        if (OutlineTopComponent.getDefault() != null && OutlineTopComponent.getDefault().getCurrentJrxmlVisualView() == JrxmlVisualView.this) {
                            OutlineTopComponent.getDefault().getExplorerManager().setRootContext((Node)JrxmlVisualView.this.model);
                        }
                        try {
                            JrxmlVisualView.this.explorerManager.setSelectedNodes(new Node[]{JrxmlVisualView.this.model});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        JrxmlVisualView.this.fireModelChange();
                    }
                });
            }
        }
        catch (JRException ex) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JrxmlVisualView.this.reportDesignerPanel.setJasperDesign(null);
                        AbstractNode mNode = new AbstractNode(Children.LEAF);
                        mNode.setDisplayName(I18n.getString("view.designer.invalidreport"));
                        JrxmlVisualView.this.getUndoRedoManager().discardAllEdits();
                        JrxmlVisualView.this.explorerManager.setRootContext((Node)mNode);
                        if (OutlineTopComponent.getDefault() != null) {
                            if (OutlineTopComponent.getDefault().getCurrentJrxmlVisualView() != JrxmlVisualView.this) {
                                OutlineTopComponent.getDefault().setCurrentJrxmlVisualView(JrxmlVisualView.this);
                            }
                            OutlineTopComponent.getDefault().getExplorerManager().setRootContext((Node)mNode);
                        }
                        try {
                            JrxmlVisualView.this.explorerManager.setSelectedNodes(new Node[]{mNode});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (InterruptedException ex1) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            Misc.showErrorMessage(I18n.getString("view.designer.errorloading", (Object)ex.getMessage()), I18n.getString("view.designer.errorloading.title"), ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            Misc.showErrorMessage(I18n.getString("view.designer.errorloading", (Object)ex.getMessage()), I18n.getString("view.designer.errorloading.title"), ex);
        }
        finally {
            this.loading = false;
        }
    }

    public void updateName() {
        Runnable run = new Runnable(){

            public void run() {
                MultiViewElementCallback c = JrxmlVisualView.this.callback;
                if (c == null) {
                    return;
                }
                TopComponent tc = c.getTopComponent();
                if (tc == null) {
                    return;
                }
                Node nd = ((JrxmlDataObject)JrxmlVisualView.this.support.getDataObject()).getNodeDelegate();
                tc.setName(nd.getName());
                tc.setDisplayName(nd.getDisplayName());
                tc.setHtmlDisplayName(nd.getHtmlDisplayName());
                tc.setToolTipText(nd.getShortDescription());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public List<ProblemItem> getReportProblems() {
        return this.reportProblems;
    }

    public void setReportProblems(List<ProblemItem> reportProblems) {
        this.reportProblems = reportProblems;
    }

    public void objectAdded(ObjectSceneEvent event, Object addedObject) {
    }

    public void objectRemoved(ObjectSceneEvent event, Object removedObject) {
    }

    public void objectStateChanged(ObjectSceneEvent event, Object changedObject, ObjectState previousState, ObjectState newState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
        if (this.isSettingSelection()) {
            return;
        }
        try {
            this.setSettingSelection(true);
            if (newSelection.size() == 0 && this.getExplorerManager().getRootContext() != null) {
                Node[] selectedNodes = this.explorerManager.getSelectedNodes();
                for (int i = 0; i < selectedNodes.length; ++i) {
                    if (!(selectedNodes[i] instanceof ElementNode) || selectedNodes[i].getLookup().lookup(JRCellContents.class) != null || event.getObjectScene() instanceof CrosstabObjectScene) continue;
                    this.explorerManager.setSelectedNodes(new Node[]{this.getExplorerManager().getRootContext()});
                    break;
                }
                return;
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Object element : newSelection) {
                Node node;
                if (!(element instanceof JRElement) || (node = ModelUtils.findElementNode((Node)this.model, (JRElement)element)) == null) continue;
                nodes.add(node);
            }
            Node[] nodesArray = new Node[nodes.size()];
            this.explorerManager.setSelectedNodes(nodes.toArray(nodesArray));
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.setSettingSelection(false);
        }
    }

    public void highlightingChanged(ObjectSceneEvent event, Set<Object> previousHighlighting, Set<Object> newHighlighting) {
    }

    public void hoverChanged(ObjectSceneEvent event, Object previousHoveredObject, Object newHoveredObject) {
    }

    public void focusChanged(ObjectSceneEvent event, Object previousFocusedObject, Object newFocusedObject) {
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public UndoRedo getUndoRedo() {
        return this.getUndoRedoManager();
    }

    public Lookup getLookup() {
        return super.getLookup();
    }

    public UndoRedo.Manager getUndoRedoManager() {
        if (this.undoRedoManager == null) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(300);
        }
        return this.undoRedoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addModelChangeListener(ModelChangeListener l) {
        Set<ModelChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeModelChangeListener(ModelChangeListener l) {
        Set<ModelChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireModelChange() {
        Iterator<ModelChangeListener> it;
        Set<ModelChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ModelChangeListener>(this.listeners).iterator();
        }
        while (it.hasNext()) {
            it.next().modelChanged(this);
        }
    }

    public void requestActive() {
        if (this.callback != null) {
            this.callback.requestActive();
        } else {
            super.requestActive();
        }
    }

    @Override
    public void modelChanged(JasperDesign model) throws IllegalArgumentException {
    }

    static {
        groupVisible = null;
    }

    class JasperDesignerTypeLookupHint
    implements NavigatorLookupHint {
        JasperDesignerTypeLookupHint() {
        }

        public String getContentType() {
            return "my-jasper-designer-mimetype";
        }
    }
}

