/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchBar
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SearchBar.class.getName());
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Color NOT_FOUND = Color.RED.darker();
    private static final Color INVALID_REGEXP = Color.red;
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Object object = mouseEvent.getSource();
            if (object instanceof JButton && (abstractButton = (AbstractButton)mouseEvent.getSource()).isEnabled()) {
                abstractButton.setContentAreaFilled(true);
                abstractButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JButton) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.setContentAreaFilled(false);
                abstractButton.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
        }
    };
    private JTextComponent component;
    private JButton closeButton;
    private JButton expandButton;
    private JLabel findLabel;
    private JComboBox incrementalSearchComboBox;
    private JTextField incrementalSearchTextField;
    private DocumentListener incrementalSearchTextFieldListener;
    private JButton findNextButton;
    private JButton findPreviousButton;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox wholeWordsCheckBox;
    private JCheckBox regexpCheckBox;
    private JCheckBox highlightCheckBox;
    private Map<Object, Object> findProps;
    private JPopupMenu expandPopup;
    private JPanel padding;
    private final List<Component> inBar = new ArrayList<Component>();
    private final LinkedList<Component> inPopup = new LinkedList();
    private final List<Component> barOrder = new ArrayList<Component>();
    private boolean isPopupGoingToShow = false;
    private boolean isPopupShown = false;

    public SearchBar(JTextComponent jTextComponent) {
        Object object;
        this.component = jTextComponent;
        this.setLayout(new BoxLayout(this, 2));
        Color color = this.getBackground();
        color = new Color(Math.max(0, color.getRed() - 20), Math.max(0, color.getGreen() - 20), Math.max(0, color.getBlue() - 20));
        this.setBackground(color);
        this.addMouseListener(sharedMouseListener);
        Keymap keymap = jTextComponent.getKeymap();
        if (keymap instanceof MultiKeymap) {
            Action[] actionArray;
            object = (MultiKeymap)keymap;
            for (Action action : actionArray = jTextComponent.getActions()) {
                InputMap inputMap;
                KeyStroke[] keyStrokeArray;
                Action action2;
                if (action.getValue("Name").equals("incremental-search-forward")) {
                    action2 = action;
                    keyStrokeArray = object.getKeyStrokesForAction(action2);
                    if (keyStrokeArray == null) continue;
                    inputMap = this.getInputMap(1);
                    for (KeyStroke keyStroke : keyStrokeArray) {
                        LOG.fine("found IncrementalSearchForwardAction, " + keyStroke);
                        inputMap.put(keyStroke, "incremental-search-forward");
                    }
                    this.getActionMap().put("incremental-search-forward", new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SearchBar.this.findNext();
                        }
                    });
                    continue;
                }
                if (!action.getValue("Name").equals("incremental-search-backward") || (keyStrokeArray = object.getKeyStrokesForAction(action2 = action)) == null) continue;
                inputMap = this.getInputMap(1);
                for (KeyStroke keyStroke : keyStrokeArray) {
                    LOG.fine("found IncrementalSearchBackwardAction, " + keyStroke);
                    inputMap.put(keyStroke, "incremental-search-backward");
                }
                this.getActionMap().put("incremental-search-backward", new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchBar.this.findPrevious();
                    }
                });
            }
        }
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        this.getActionMap().put("loose-focus", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton = new JButton(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/find_close.png")));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_CloseIncrementalSearchSidebar"));
        this.processButton(this.closeButton);
        this.expandButton = new JButton(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/find_expand.png")));
        this.expandButton.setMnemonic(NbBundle.getMessage(SearchBar.class, (String)"CTL_ExpandButton_Mnemonic").charAt(0));
        this.processButton(this.expandButton);
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !SearchBar.this.isPopupShown;
                SearchBar.this.isPopupShown = bl;
                if (bl) {
                    SearchBar.this.showExpandedMenu();
                } else {
                    SearchBar.this.hideExpandedMenu();
                }
            }
        });
        this.findLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.findLabel, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        this.incrementalSearchComboBox = new JComboBox(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.incrementalSearchComboBox.setEditable(true);
        this.incrementalSearchTextField = (JTextField)this.incrementalSearchComboBox.getEditor().getEditorComponent();
        this.incrementalSearchTextField.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        this.incrementalSearchTextFieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SearchBar.this.incrementalSearch();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SearchBar.this.incrementalSearch();
            }
        };
        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
        this.incrementalSearchTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SearchBar.this.looseFocus();
            }
        });
        this.incrementalSearchTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findNext();
            }
        });
        this.incrementalSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "incremental-find-previous");
        this.incrementalSearchTextField.getActionMap().put("incremental-find-previous", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findPrevious();
            }
        });
        this.findNextButton = new JButton(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/find_next.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.findNextButton, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_FindNext"));
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findNext();
            }
        });
        this.processButton(this.findNextButton);
        this.findPreviousButton = new JButton(new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/find_previous.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.findPreviousButton, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_FindPrevious"));
        this.findPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findPrevious();
            }
        });
        this.processButton(this.findPreviousButton);
        this.matchCaseCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.matchCaseCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_MatchCase"));
        this.matchCaseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.processButton(this.matchCaseCheckBox);
        this.wholeWordsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.wholeWordsCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_WholeWords"));
        this.wholeWordsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.processButton(this.wholeWordsCheckBox);
        this.regexpCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.regexpCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Regexp"));
        this.regexpCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.wholeWordsCheckBox.setEnabled(!SearchBar.this.regexpCheckBox.isSelected());
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.processButton(this.regexpCheckBox);
        this.highlightCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.highlightCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Highlight"));
        this.highlightCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.highlightCheckBox.setSelected(true);
        this.processButton(this.highlightCheckBox);
        this.expandPopup = new JPopupMenu();
        this.expandPopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (SearchBar.this.expandButton.getMousePosition() == null) {
                    SearchBar.this.expandButton.setContentAreaFilled(false);
                    SearchBar.this.expandButton.setBorderPainted(false);
                    SearchBar.this.isPopupShown = false;
                }
            }
        });
        this.findProps = new HashMap<Object, Object>();
        this.findProps.put("find-highlight-search", true);
        this.findProps.put("find-whole-words", false);
        this.findProps.put("find-wrap-search", true);
        this.findProps.put("find-block-search", false);
        this.findProps.put("find-block-search-start", null);
        this.findProps.put("find-block-search-end", null);
        this.findProps.put("find-match-case", false);
        this.findProps.put("find-reg-exp", false);
        this.findProps.put("find-highlight-search", true);
        object = new JPanel();
        ((Component)object).setSize(4, 4);
        ((JComponent)object).setMaximumSize(new Dimension(4, 4));
        ((JComponent)object).setOpaque(false);
        this.add((Component)object);
        this.add(this.findLabel);
        this.add(this.incrementalSearchComboBox);
        this.add(new JToolBar.Separator());
        this.add(this.findPreviousButton);
        this.add(this.findNextButton);
        this.add(new JToolBar.Separator());
        this.add(this.matchCaseCheckBox);
        this.add(this.wholeWordsCheckBox);
        this.add(this.regexpCheckBox);
        this.add(this.highlightCheckBox);
        this.add(this.expandButton);
        this.padding = new JPanel();
        this.padding.setOpaque(false);
        this.add(this.padding);
        this.add(this.closeButton);
        this.makeBarExpandable();
        this.setVisible(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SearchBar.this.computeLayout();
            }
        });
    }

    private void makeBarExpandable() {
        this.inBar.add(this.matchCaseCheckBox);
        this.inBar.add(this.wholeWordsCheckBox);
        this.inBar.add(this.regexpCheckBox);
        this.inBar.add(this.highlightCheckBox);
        for (Component component : this.getComponents()) {
            this.barOrder.add(component);
        }
        this.remove(this.expandButton);
    }

    private void computeLayout() {
        Container container = this.getParent();
        int n = container.getWidth();
        int n2 = 0;
        boolean bl = false;
        Object object = this.getComponents();
        int n3 = ((Component[])object).length;
        for (int i = 0; i < n3; ++i) {
            Component component = object[i];
            if (component == this.padding) continue;
            n2 += component.getWidth();
        }
        if (n2 <= n) {
            while (!this.inPopup.isEmpty() && (n2 += ((Component)(object = this.inPopup.getFirst())).getWidth()) <= n) {
                this.inPopup.removeFirst();
                this.inBar.add((Component)object);
                this.expandPopup.remove((Component)object);
                this.add((Component)object, this.barOrder.indexOf(object));
                bl = true;
            }
        } else {
            while (n2 > n && !this.inBar.isEmpty()) {
                object = this.inBar.remove(this.inBar.size() - 1);
                this.inPopup.addFirst((Component)object);
                this.remove((Component)object);
                this.expandPopup.add((Component)object, 0);
                n2 -= ((Component)object).getWidth();
                bl = true;
            }
        }
        if (bl) {
            if (this.inPopup.isEmpty()) {
                this.remove(this.expandButton);
            } else if (this.getComponentIndex(this.expandButton) < 0) {
                this.add((Component)this.expandButton, this.getComponentIndex(this.padding));
            }
            this.revalidate();
            this.expandPopup.invalidate();
            this.expandPopup.validate();
        }
    }

    private int getComponentIndex(Component component) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (component != componentArray[i]) continue;
            return i;
        }
        return -1;
    }

    private void showExpandedMenu() {
        if (!this.inPopup.isEmpty() && !this.expandPopup.isVisible()) {
            this.isPopupGoingToShow = true;
            Insets insets = this.expandPopup.getInsets();
            this.expandPopup.show(this.expandButton, 0, -(this.matchCaseCheckBox.getHeight() * this.inPopup.size() + insets.top + insets.bottom));
        }
    }

    private void hideExpandedMenu() {
        if (this.expandPopup.isVisible()) {
            this.expandPopup.setVisible(false);
            this.incrementalSearch();
            this.incrementalSearchTextField.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return "editorSearchBar";
    }

    private void gainFocus() {
        if (this.isVisible()) {
            this.incrementalSearchTextField.requestFocusInWindow();
            return;
        }
        this.computeLayout();
        this.isPopupShown = false;
        this.setVisible(true);
        this.initBlockSearch();
        this.incrementalSearchTextField.requestFocusInWindow();
        if (this.incrementalSearchTextField.getText().length() > 0) {
            this.incrementalSearchTextField.selectAll();
            this.findPreviousButton.setEnabled(true);
            this.findNextButton.setEnabled(true);
        } else {
            this.findPreviousButton.setEnabled(false);
            this.findNextButton.setEnabled(false);
        }
    }

    private void looseFocus() {
        if (this.isPopupGoingToShow) {
            this.isPopupGoingToShow = false;
            return;
        }
        FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
        FindSupport.getFindSupport().incSearchReset();
        this.setVisible(false);
        if (this.component.isEnabled()) {
            this.component.requestFocusInWindow();
        }
    }

    private void incrementalSearch() {
        String string = this.incrementalSearchTextField.getText();
        boolean bl = string.length() <= 0;
        this.findPreviousButton.setEnabled(!bl);
        this.findNextButton.setEnabled(!bl);
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", string);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-highlight-search", !bl && this.highlightCheckBox.isSelected());
        this.findProps.put("find-backward-search", false);
        this.findProps.put("find-inc-search", true);
        findSupport.putFindProperties(this.findProps);
        int n = this.component.getCaretPosition();
        if (this.regexpCheckBox.isSelected()) {
            Pattern pattern;
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = null;
            }
            if (pattern != null) {
                this.incrementalSearchTextField.setBackground(null);
                this.incrementalSearchTextField.setForeground(Color.BLACK);
            } else {
                this.incrementalSearchTextField.setBackground(null);
                this.incrementalSearchTextField.setForeground(INVALID_REGEXP);
            }
        } else if (findSupport.incSearch(this.findProps, n) || bl) {
            this.incrementalSearchTextField.setBackground(null);
            this.incrementalSearchTextField.setForeground(Color.BLACK);
        } else {
            this.incrementalSearchTextField.setBackground(null);
            this.incrementalSearchTextField.setForeground(NOT_FOUND);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void findNext() {
        this.find(true);
    }

    private void findPrevious() {
        this.find(false);
    }

    private void find(boolean bl) {
        String string = this.incrementalSearchTextField.getText();
        boolean bl2 = string.length() <= 0;
        this.incrementalSearchTextField.getDocument().removeDocumentListener(this.incrementalSearchTextFieldListener);
        for (int i = this.incrementalSearchComboBox.getItemCount() - 1; i >= 0; --i) {
            String string2 = (String)this.incrementalSearchComboBox.getItemAt(i);
            if (!string2.equals(string)) continue;
            this.incrementalSearchComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.incrementalSearchComboBox.getModel()).insertElementAt(string, 0);
        this.incrementalSearchComboBox.setSelectedIndex(0);
        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", string);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-backward-search", Boolean.FALSE);
        this.findProps.put("find-inc-search", Boolean.TRUE);
        this.findProps.put("find-highlight-search", !bl2 && this.highlightCheckBox.isSelected());
        findSupport.putFindProperties(this.findProps);
        if (findSupport.find(this.findProps, !bl) || bl2) {
            this.incrementalSearchTextField.setBackground(null);
            this.incrementalSearchTextField.setForeground(Color.BLACK);
        } else {
            this.incrementalSearchTextField.setBackground(null);
            this.incrementalSearchTextField.setForeground(NOT_FOUND);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void processButton(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setMargin(BUTTON_INSETS);
        if (abstractButton instanceof JButton) {
            abstractButton.addMouseListener(sharedMouseListener);
        }
        abstractButton.setFocusable(false);
    }

    private void initBlockSearch() {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        String string = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (jTextComponent != null) {
            int n3;
            int n4;
            Object object;
            n = jTextComponent.getSelectionStart();
            n2 = jTextComponent.getSelectionEnd();
            Document document = jTextComponent.getDocument();
            if (document instanceof BaseDocument) {
                object = (BaseDocument)document;
                try {
                    n4 = Utilities.getLineOffset((BaseDocument)object, (int)n);
                    n3 = Utilities.getLineOffset((BaseDocument)object, (int)n2);
                    if (n3 > n4) {
                        bl = true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (!bl) {
                string = jTextComponent.getSelectedText();
                if (string != null && string.length() > 0) {
                    int n5 = string.indexOf(10);
                    if (n5 >= 0) {
                        string = string.substring(0, n5);
                    }
                    this.incrementalSearchTextField.setText(string);
                } else {
                    object = (String)FindSupport.getFindSupport().getFindProperty("find-what");
                    if (object != null && ((String)object).length() > 0) {
                        this.incrementalSearchTextField.setText((String)object);
                    }
                }
            }
            int n6 = bl ? n : 0;
            n4 = bl ? n2 : 0;
            try {
                this.findProps.put("find-block-search", bl);
                this.findProps.put("find-block-search-start", n6);
                n3 = this.getBlockEndOffset();
                if (n3 < 0) {
                    this.findProps.put("find-block-search-end", document.createPosition(n4));
                } else {
                    n4 = n3;
                }
                FindSupport.getFindSupport().setBlockSearchHighlight(n6, n4);
            }
            catch (BadLocationException badLocationException) {
                this.findProps.put("find-block-search", Boolean.FALSE);
                this.findProps.put("find-block-search-start", null);
            }
            FindSupport.getFindSupport().putFindProperties(this.findProps);
        }
    }

    private int getBlockEndOffset() {
        Position position = (Position)FindSupport.getFindSupport().getFindProperties().get("find-block-search-end");
        return position != null ? position.getOffset() : -1;
    }

    private static <T> T findComponent(Container container, Class<T> clazz, int n) {
        if (n > 0) {
            for (Component component : container.getComponents()) {
                Component component2;
                if (clazz.isAssignableFrom(component.getClass())) {
                    component2 = component;
                    return (T)component2;
                }
                if (!(component instanceof Container) || (component2 = SearchBar.findComponent((Container)component, clazz, n - 1)) == null) continue;
                return (T)component2;
            }
        }
        return null;
    }

    public static class IncrementalSearchBackwardAction
    extends BaseAction {
        public static final String ACTION_NAME = "incremental-search-backward";
        static final long serialVersionUID = -1L;

        public IncrementalSearchBackwardAction() {
            super(ACTION_NAME, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchBackwardAction.class, (String)ACTION_NAME));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            SearchBar searchBar;
            JComponent jComponent;
            EditorUI editorUI;
            if (jTextComponent != null && (editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent)) != null && (jComponent = editorUI.getExtComponent()) != null && (searchBar = (SearchBar)SearchBar.findComponent(jComponent, SearchBar.class, 5)) != null) {
                searchBar.gainFocus();
            }
        }
    }

    public static class IncrementalSearchForwardAction
    extends BaseAction {
        public static final String ACTION_NAME = "incremental-search-forward";
        static final long serialVersionUID = -1L;

        public IncrementalSearchForwardAction() {
            super(ACTION_NAME, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchForwardAction.class, (String)ACTION_NAME));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            SearchBar searchBar;
            JComponent jComponent;
            EditorUI editorUI;
            if (jTextComponent != null && (editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent)) != null && (jComponent = editorUI.getExtComponent()) != null && (searchBar = (SearchBar)SearchBar.findComponent(jComponent, SearchBar.class, 5)) != null) {
                searchBar.gainFocus();
            }
        }
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent jTextComponent) {
            return new SearchBar(jTextComponent);
        }
    }
}

