/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.event.MouseEvent;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtUtilities;

public class ExtCaret
extends BaseCaret {
    public static final String HIGHLIGHT_ROW_LAYER_NAME = "highlight-row-layer";
    public static final int HIGHLIGHT_ROW_LAYER_VISIBILITY = 2050;
    public static final String HIGHLIGHT_BRACE_LAYER_NAME = "highlight-brace-layer";
    public static final int HIGHLIGHT_BRACE_LAYER_VISIBILITY = 11000;
    private boolean popupMenuEnabled;
    static final long serialVersionUID = -4292670043122577690L;

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null) {
            Class clazz = Utilities.getKitClass(jTextComponent);
            this.popupMenuEnabled = SettingsUtil.getBoolean(clazz, "popup-menu-enabled", true);
        }
    }

    protected void updateMatchBrace() {
    }

    public void requestMatchBraceUpdateSync() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Completion completion = ExtUtilities.getCompletion(this.component);
        if (completion != null && completion.isPaneVisible()) {
            completion.setPaneVisible(false);
        }
        super.mousePressed(mouseEvent);
        this.showPopup(mouseEvent);
    }

    private boolean showPopup(MouseEvent mouseEvent) {
        if (this.component != null && mouseEvent.isPopupTrigger() && this.popupMenuEnabled) {
            ExtUtilities.getExtEditorUI(this.component).showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.showPopup(mouseEvent)) {
            super.mouseReleased(mouseEvent);
        }
    }
}

