/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallUnitWizardModel
extends OperationWizardModel {
    private InstallSupport.Installer installer = null;
    private OperationWizardModel.OperationType doOperation;
    private static Set<String> approvedLicences = new HashSet<String>();
    private InstallSupport support;
    private InstallSupport additionallySupport = null;
    private OperationContainer<InstallSupport> updateContainer = null;

    public InstallUnitWizardModel(OperationWizardModel.OperationType operationType, OperationContainer<InstallSupport> operationContainer) {
        this.doOperation = operationType;
        this.updateContainer = operationContainer;
    }

    public InstallUnitWizardModel(OperationWizardModel.OperationType operationType) {
        this.doOperation = operationType;
        assert (this.getBaseContainer() != null) : "The base container for operation " + (Object)((Object)operationType) + " must exist!";
    }

    @Override
    public OperationWizardModel.OperationType getOperation() {
        return this.doOperation;
    }

    @Override
    public OperationContainer getBaseContainer() {
        if (this.updateContainer != null) {
            this.support = (InstallSupport)this.updateContainer.getSupport();
            return this.updateContainer;
        }
        OperationContainer<InstallSupport> operationContainer = null;
        switch (this.getOperation()) {
            case INSTALL: {
                operationContainer = Containers.forAvailable();
                this.support = (InstallSupport)Containers.forAvailable().getSupport();
                break;
            }
            case UPDATE: {
                operationContainer = Containers.forUpdate();
                this.support = (InstallSupport)Containers.forUpdate().getSupport();
                break;
            }
            case LOCAL_DOWNLOAD: {
                OperationContainer<InstallSupport> operationContainer2;
                if (Containers.forUpdateNbms().listAll().isEmpty()) {
                    operationContainer = Containers.forAvailableNbms();
                    operationContainer2 = Containers.forUpdateNbms();
                } else {
                    operationContainer = Containers.forUpdateNbms();
                    operationContainer2 = Containers.forAvailableNbms();
                }
                this.additionallySupport = (InstallSupport)operationContainer2.getSupport();
                this.support = (InstallSupport)operationContainer.getSupport();
            }
        }
        return operationContainer;
    }

    @Override
    public OperationContainer<OperationSupport> getCustomHandledContainer() {
        return Containers.forCustomInstall();
    }

    public boolean allLicensesApproved() {
        boolean bl = true;
        for (UpdateElement updateElement : this.getAllUpdateElements()) {
            if (updateElement.getLicence() == null || approvedLicences.contains(updateElement.getLicence())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void addApprovedLicenses(Collection<String> collection) {
        approvedLicences.addAll(collection);
    }

    public InstallSupport getInstallSupport() {
        return this.support;
    }

    public InstallSupport getAdditionallyInstallSupport() {
        return this.additionallySupport;
    }

    public void setInstaller(InstallSupport.Installer installer) {
        this.installer = installer;
    }

    public InstallSupport.Installer getInstaller() {
        return this.installer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCleanup(boolean bl) throws OperationException {
        try {
            if (bl) {
                OperationSupport operationSupport;
                if (this.getBaseContainer().getSupport() instanceof InstallSupport) {
                    if (OperationWizardModel.OperationType.LOCAL_DOWNLOAD == this.getOperation()) {
                        InstallSupport installSupport;
                        operationSupport = (InstallSupport)Containers.forAvailableNbms().getSupport();
                        if (operationSupport != null) {
                            operationSupport.doCancel();
                        }
                        if ((installSupport = (InstallSupport)Containers.forUpdateNbms().getSupport()) != null) {
                            installSupport.doCancel();
                        }
                        Containers.forAvailableNbms().removeAll();
                        Containers.forUpdateNbms().removeAll();
                    } else {
                        operationSupport = (InstallSupport)this.getBaseContainer().getSupport();
                        if (operationSupport != null) {
                            operationSupport.doCancel();
                        }
                    }
                } else {
                    operationSupport = (OperationSupport)this.getBaseContainer().getSupport();
                    if (operationSupport != null) {
                        operationSupport.doCancel();
                    }
                }
                operationSupport = (OperationSupport)this.getCustomHandledContainer().getSupport();
                if (operationSupport != null) {
                    operationSupport.doCancel();
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        finally {
            super.doCleanup(false);
        }
    }
}

