/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Evaluator;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTupleReader
implements TupleReader {
    TupleConstraint constraint;
    List<Target> targets = new ArrayList<Target>();
    int maxRows = 0;

    public SqlTupleReader(TupleConstraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, RolapMember[] srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers));
    }

    @Override
    public Object getCacheKey() {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.constraint.getCacheKey());
        key.add(SqlTupleReader.class);
        for (Target target : this.targets) {
            if (target.srcMembers == null) continue;
            key.add(target.getLevel());
        }
        return key;
    }

    public int getEnumTargetCount() {
        int enumTargetCount = 0;
        for (Target target : this.targets) {
            if (target.srcMembers == null) continue;
            ++enumTargetCount;
        }
        return enumTargetCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTuples(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        String message = "Populating member cache with members for " + this.targets;
        SqlStatement stmt = null;
        boolean execQuery = partialResult == null;
        try {
            boolean moreRows;
            ResultSet resultSet;
            if (execQuery) {
                ArrayList<Target> partialTargets = new ArrayList<Target>();
                for (Target target : this.targets) {
                    if (target.srcMembers != null) continue;
                    partialTargets.add(target);
                }
                String sql = this.makeLevelMembersSql(dataSource);
                stmt = RolapUtil.executeQuery(dataSource, sql, this.maxRows, "SqlTupleReader.readTuples " + partialTargets, message, -1, -1);
                resultSet = stmt.getResultSet();
            } else {
                resultSet = null;
            }
            for (Target target : this.targets) {
                target.open();
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            int fetchCount = 0;
            int enumTargetCount = this.getEnumTargetCount();
            int[] srcMemberIdxes = null;
            if (enumTargetCount > 0) {
                srcMemberIdxes = new int[enumTargetCount];
            }
            int currPartialResultIdx = 0;
            if (execQuery) {
                moreRows = resultSet.next();
                ++stmt.rowCount;
            } else {
                boolean bl = moreRows = currPartialResultIdx < partialResult.size();
            }
            while (moreRows) {
                if (limit > 0 && limit < ++fetchCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                if (enumTargetCount == 0) {
                    int column = 0;
                    for (Target target : this.targets) {
                        target.currMember = null;
                        column = target.addRow(resultSet, column);
                    }
                } else {
                    int firstEnumTarget;
                    for (firstEnumTarget = 0; firstEnumTarget < this.targets.size() && this.targets.get(firstEnumTarget).srcMembers == null; ++firstEnumTarget) {
                    }
                    List<RolapMember> partialRow = execQuery ? null : partialResult.get(currPartialResultIdx);
                    this.resetCurrMembers(partialRow);
                    this.addTargets(0, firstEnumTarget, enumTargetCount, srcMemberIdxes, resultSet, message);
                    if (newPartialResult != null) {
                        this.savePartialResult(newPartialResult);
                    }
                }
                if (execQuery) {
                    moreRows = resultSet.next();
                    continue;
                }
                moreRows = ++currPartialResultIdx < partialResult.size();
            }
        }
        catch (Exception e) {
            if (stmt == null) {
                throw Util.newError(e, message);
            }
            stmt.handle(e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<RolapMember> readMembers(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(dataSource, partialResult, newPartialResult);
        assert (this.targets.size() == 1);
        return this.targets.get(0).close();
    }

    @Override
    public List<RolapMember[]> readTuples(DataSource jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        int n = this.targets.size();
        ArrayList<RolapMember[]> tupleList = new ArrayList<RolapMember[]>();
        Iterator[] iter = new Iterator[n];
        for (int i = 0; i < n; ++i) {
            Target t = this.targets.get(i);
            iter[i] = t.close().iterator();
        }
        while (iter[0].hasNext()) {
            RolapMember[] tuples = new RolapMember[n];
            for (int i = 0; i < n; ++i) {
                tuples[i] = (RolapMember)iter[i].next();
            }
            tupleList.add(tuples);
        }
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            FunUtil.hierarchize(tupleList, false);
        }
        return tupleList;
    }

    private void resetCurrMembers(List<RolapMember> partialRow) {
        int nativeTarget = 0;
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            if (partialRow != null) {
                target.currMember = partialRow.get(nativeTarget++);
                continue;
            }
            target.currMember = null;
        }
    }

    private void addTargets(int currEnumTargetIdx, int currTargetIdx, int nEnumTargets, int[] srcMemberIdxes, ResultSet resultSet, String message) {
        Target currTarget = this.targets.get(currTargetIdx);
        for (int i = 0; i < currTarget.srcMembers.length; ++i) {
            srcMemberIdxes[currEnumTargetIdx] = i;
            if (currEnumTargetIdx < nEnumTargets - 1) {
                int nextTargetIdx;
                for (nextTargetIdx = currTargetIdx + 1; nextTargetIdx < this.targets.size() && this.targets.get(nextTargetIdx).srcMembers == null; ++nextTargetIdx) {
                }
                this.addTargets(currEnumTargetIdx + 1, nextTargetIdx, nEnumTargets, srcMemberIdxes, resultSet, message);
                continue;
            }
            int column = 0;
            int enumTargetIdx = 0;
            for (Target target : this.targets) {
                if (target.srcMembers == null) {
                    try {
                        column = target.addRow(resultSet, column);
                        continue;
                    }
                    catch (Throwable e) {
                        throw Util.newError(e, message);
                    }
                }
                RolapMember member = target.srcMembers[srcMemberIdxes[enumTargetIdx++]];
                target.list.add(member);
            }
        }
    }

    private void savePartialResult(List<List<RolapMember>> partialResult) {
        ArrayList<RolapMember> row = new ArrayList<RolapMember>();
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            row.add(target.currMember);
        }
        partialResult.add(row);
    }

    String makeLevelMembersSql(DataSource dataSource) {
        Query query;
        SqlContextConstraint sqlConstraint;
        RolapCube cube = null;
        boolean virtualCube = false;
        if (this.constraint instanceof SqlContextConstraint && (sqlConstraint = (SqlContextConstraint)this.constraint).isJoinRequired()) {
            query = this.constraint.getEvaluator().getQuery();
            cube = (RolapCube)query.getCube();
            virtualCube = cube.isVirtual();
        }
        if (virtualCube) {
            String selectString = "";
            query = this.constraint.getEvaluator().getQuery();
            Set<Map<RolapLevel, RolapStar.Column>> baseCubesLevelToColumnMaps = query.getVirtualCubeBaseCubeMaps();
            Map<Map<RolapLevel, RolapStar.Column>, RolapMember> measureMap = query.getLevelMapToMeasureMap();
            int k = -1;
            for (Map<RolapLevel, RolapStar.Column> map : baseCubesLevelToColumnMaps) {
                boolean finalSelect = ++k == baseCubesLevelToColumnMaps.size() - 1;
                RolapMember measure = measureMap.get(map);
                assert (measure instanceof RolapStoredMeasure);
                Evaluator evaluator = this.constraint.getEvaluator();
                evaluator.push();
                evaluator.setContext(measure);
                WhichSelect whichSelect = finalSelect ? WhichSelect.LAST : WhichSelect.NOT_LAST;
                selectString = selectString + this.generateSelectForLevels(dataSource, map, whichSelect);
                if (finalSelect) continue;
                selectString = selectString + " union ";
            }
            return selectString;
        }
        Map<RolapLevel, RolapStar.Column> map = cube == null ? null : cube.getStar().getLevelToColumnMap(cube);
        return this.generateSelectForLevels(dataSource, map, WhichSelect.ONLY);
    }

    private String generateSelectForLevels(DataSource dataSource, Map<RolapLevel, RolapStar.Column> levelToColumnMap, WhichSelect whichSelect) {
        String s = "while generating query to retrieve members of level(s) " + this.targets;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, s);
        for (Target target : this.targets) {
            if (target.srcMembers != null) continue;
            this.addLevelMemberSql(sqlQuery, target.getLevel(), levelToColumnMap, whichSelect);
        }
        this.constraint.addConstraint(sqlQuery, levelToColumnMap);
        return sqlQuery.toString();
    }

    private void addLevelMemberSql(SqlQuery sqlQuery, RolapLevel level, Map<RolapLevel, RolapStar.Column> levelToColumnMap, WhichSelect whichSelect) {
        RolapHierarchy hierarchy = level.getHierarchy();
        RolapLevel[] levels = (RolapLevel[])hierarchy.getLevels();
        int levelDepth = level.getDepth();
        for (int i = 0; i <= levelDepth; ++i) {
            RolapProperty[] properties;
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
            String keySql = level2.getKeyExp().getExpression(sqlQuery);
            sqlQuery.addSelect(keySql);
            sqlQuery.addGroupBy(keySql);
            hierarchy.addToFrom(sqlQuery, level2.getOrdinalExp());
            this.constraint.addLevelConstraint(sqlQuery, null, level2, levelToColumnMap);
            if (level2.hasCaptionColumn()) {
                MondrianDef.Expression captionExp = level2.getCaptionExp();
                hierarchy.addToFrom(sqlQuery, captionExp);
                String captionSql = captionExp.getExpression(sqlQuery);
                sqlQuery.addSelect(captionSql);
                sqlQuery.addGroupBy(captionSql);
            }
            String ordinalSql = level2.getOrdinalExp().getExpression(sqlQuery);
            sqlQuery.addGroupBy(ordinalSql);
            if (!ordinalSql.equals(keySql)) {
                sqlQuery.addSelect(ordinalSql);
            }
            switch (whichSelect) {
                case LAST: {
                    sqlQuery.addOrderBy(Integer.toString(sqlQuery.getCurrentSelectListSize()), true, false, true);
                    break;
                }
                case ONLY: {
                    sqlQuery.addOrderBy(ordinalSql, true, false, true);
                }
            }
            for (RolapProperty property : properties = level2.getProperties()) {
                String propSql = property.getExp().getExpression(sqlQuery);
                sqlQuery.addSelect(propSql);
                sqlQuery.addGroupBy(propSql);
            }
        }
    }

    int getMaxRows() {
        return this.maxRows;
    }

    void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WhichSelect {
        ONLY,
        NOT_LAST,
        LAST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Target {
        final RolapLevel level;
        final MemberCache cache;
        RolapLevel[] levels;
        List<RolapMember> list;
        int levelDepth;
        boolean parentChild;
        RolapMember[] members;
        List<RolapMember>[] siblings;
        final TupleReader.MemberBuilder memberBuilder;
        private final RolapMember[] srcMembers;
        private RolapMember currMember;

        public Target(RolapLevel level, TupleReader.MemberBuilder memberBuilder, RolapMember[] srcMembers) {
            this.level = level;
            this.cache = memberBuilder.getMemberCache();
            this.memberBuilder = memberBuilder;
            this.srcMembers = srcMembers;
        }

        public void open() {
            this.levels = (RolapLevel[])this.level.getHierarchy().getLevels();
            this.list = new ArrayList<RolapMember>();
            this.levelDepth = this.level.getDepth();
            this.parentChild = this.level.isParentChild();
            this.members = new RolapMember[this.levels.length];
            this.siblings = new List[this.levels.length + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int addRow(ResultSet resultSet, int column) throws SQLException {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalAddRow(resultSet, column);
            }
        }

        private int internalAddRow(ResultSet resultSet, int column) throws SQLException {
            RolapMember member = null;
            if (this.currMember != null) {
                member = this.currMember;
            } else {
                boolean checkCacheStatus = true;
                for (int i = 0; i <= this.levelDepth; ++i) {
                    MemberChildrenConstraint mcc;
                    Object value;
                    RolapLevel childLevel = this.levels[i];
                    if (childLevel.isAll()) {
                        member = this.level.getHierarchy().getAllMember();
                        continue;
                    }
                    if ((value = resultSet.getObject(++column)) == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    Object captionValue = childLevel.hasCaptionColumn() ? resultSet.getObject(++column) : null;
                    RolapMember parentMember = member;
                    Object key = this.cache.makeKey(parentMember, value);
                    member = this.cache.getMember(key, checkCacheStatus);
                    checkCacheStatus = false;
                    if (member == null) {
                        member = this.memberBuilder.makeMember(parentMember, childLevel, value, captionValue, this.parentChild, resultSet, key, column);
                    }
                    if (!childLevel.getOrdinalExp().equals((Object)childLevel.getKeyExp())) {
                        ++column;
                    }
                    column += childLevel.getProperties().length;
                    if (member == this.members[i]) continue;
                    List<RolapMember> children = this.siblings[i + 1];
                    if (children != null && (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(this.members[i])) != null) {
                        this.cache.putChildren(this.members[i], mcc, children);
                    }
                    mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member);
                    List<RolapMember> cachedChildren = this.cache.getChildrenFromCache(member, mcc);
                    this.siblings[i + 1] = i < this.levelDepth && cachedChildren == null ? new ArrayList<RolapMember>() : null;
                    this.members[i] = member;
                    if (this.siblings[i] == null) continue;
                    if (value == RolapUtil.sqlNullValue) {
                        this.addAsOldestSibling(this.siblings[i], member);
                        continue;
                    }
                    this.siblings[i].add(member);
                }
                this.currMember = member;
            }
            this.list.add(member);
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<RolapMember> close() {
            MemberCache memberCache = this.cache;
            synchronized (memberCache) {
                return this.internalClose();
            }
        }

        public List<RolapMember> internalClose() {
            for (int i = 0; i < this.members.length; ++i) {
                MemberChildrenConstraint mcc;
                RolapMember member = this.members[i];
                List<RolapMember> children = this.siblings[i + 1];
                if (member == null || children == null || (mcc = SqlTupleReader.this.constraint.getMemberChildrenConstraint(member)) == null) continue;
                this.cache.putChildren(member, mcc, children);
            }
            return this.list;
        }

        private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
            RolapMember sibling;
            int i = list.size();
            while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
            }
            list.add(i + 1, member);
        }

        public RolapLevel getLevel() {
            return this.level;
        }

        public String toString() {
            return this.level.getUniqueName();
        }
    }
}

