/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.router;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.router.CollisionsCollector;
import org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.modules.visual.router.OrthogonalSearchRouterCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrthogonalSearchRouter
implements Router {
    static final int SPACING_EDGE = 8;
    static final int SPACING_NODE = 16;
    private CollisionsCollector collector;
    private ConnectionWidgetCollisionsCollector connectionWidgetCollector;

    public OrthogonalSearchRouter(CollisionsCollector collisionsCollector) {
        this.collector = collisionsCollector;
    }

    public OrthogonalSearchRouter(ConnectionWidgetCollisionsCollector connectionWidgetCollisionsCollector) {
        this.connectionWidgetCollector = connectionWidgetCollisionsCollector;
    }

    @Override
    public List<Point> routeConnection(ConnectionWidget connectionWidget) {
        Anchor anchor = connectionWidget.getSourceAnchor();
        Anchor anchor2 = connectionWidget.getTargetAnchor();
        if (anchor == null || anchor2 == null) {
            return Collections.emptyList();
        }
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        ArrayList<Rectangle> arrayList2 = new ArrayList<Rectangle>();
        if (this.collector != null) {
            this.collector.collectCollisions(arrayList, arrayList2);
        } else {
            this.connectionWidgetCollector.collectCollisions(connectionWidget, arrayList, arrayList2);
        }
        Anchor.Result result = anchor.compute(connectionWidget.getSourceAnchorEntry());
        Anchor.Result result2 = anchor2.compute(connectionWidget.getTargetAnchorEntry());
        Point point = result.getAnchorSceneLocation();
        Point point2 = result2.getAnchorSceneLocation();
        Solution solution = new Solution(0x1FFFFFFF, Arrays.asList(point, point2));
        for (Anchor.Direction direction : result.getDirections()) {
            for (Anchor.Direction direction2 : result2.getDirections()) {
                Solution solution2 = new OrthogonalSearchRouterCore(connectionWidget.getScene(), arrayList, arrayList2, point, direction, point2, direction2).route();
                if (solution2 == null || solution2.compareTo(solution) <= 0) continue;
                solution = solution2;
            }
        }
        return solution.getPoints();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Solution
    implements Comparable<Solution> {
        private int price;
        private List<Point> points;

        public Solution(int n, List<Point> list) {
            this.price = n;
            this.points = list;
        }

        public int getPrice() {
            return this.price;
        }

        public List<Point> getPoints() {
            return this.points;
        }

        @Override
        public int compareTo(Solution solution) {
            return solution.price - this.price;
        }
    }
}

