/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallManager;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.updater.UpdaterFrame;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallSupportImpl {
    private InstallSupport support;
    private boolean progressRunning = false;
    private static Logger err = Logger.getLogger(InstallSupportImpl.class.getName());
    public static final String UPDATE_DIR = "update";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    public static final String NBM_EXTENTSION = ".nbm";
    private Map<UpdateElementImpl, File> element2Clusters = null;
    private Set<File> downloadedFiles = null;
    private boolean isGlobal;
    private int wasDownloaded = 0;
    private STEP currentStep = STEP.NOTSTARTED;
    private Collection<UpdateElementImpl> trusted = new ArrayList<UpdateElementImpl>();
    private Collection<UpdateElementImpl> signed = new ArrayList<UpdateElementImpl>();
    private Map<UpdateElement, Collection<Certificate>> certs = new HashMap<UpdateElement, Collection<Certificate>>();
    private ExecutorService es = null;
    private Set<ModuleUpdateElementImpl> affectedModuleImpls = null;
    private Set<FeatureUpdateElementImpl> affectedFeatureImpls = null;

    public InstallSupportImpl(InstallSupport installSupport) {
        this.support = installSupport;
    }

    public boolean doDownload(final ProgressHandle progressHandle, boolean bl) throws OperationException {
        this.isGlobal = bl;
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean call() throws Exception {
                Object object;
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : "Container contains no invalid OperationInfo, but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                Object object2 = this;
                synchronized (object2) {
                    InstallSupportImpl.this.currentStep = STEP.DOWNLOAD;
                }
                object2 = InstallSupportImpl.this.support.getContainer().listAll();
                int n = 0;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (OperationContainer.OperationInfo)iterator.next();
                    n += ((OperationContainer.OperationInfo)object).getUpdateElement().getDownloadSize();
                }
                if (progressHandle != null) {
                    progressHandle.start();
                    progressHandle.progress(NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Download_Estabilish"));
                    InstallSupportImpl.this.progressRunning = false;
                }
                int n2 = 0;
                try {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        OperationContainer.OperationInfo operationInfo = (OperationContainer.OperationInfo)object.next();
                        1 var6_8 = this;
                        synchronized (var6_8) {
                            if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                                Boolean bl = false;
                                return bl;
                            }
                        }
                        int n3 = InstallSupportImpl.this.doDownload(operationInfo, progressHandle, n2, n);
                        if (n3 == -1) {
                            Boolean bl = false;
                            return bl;
                        }
                        n2 += n3;
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
                assert (n == n2) : "Was downloaded " + n2 + ", planned was " + n;
                InstallSupportImpl.this.wasDownloaded = n2;
                return true;
            }
        };
        boolean bl2 = false;
        try {
            bl2 = this.getExecutionService().submit(callable).get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof OperationException)) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
            throw (OperationException)executionException.getCause();
        }
        return bl2;
    }

    public boolean doValidate(InstallSupport.Validator validator, final ProgressHandle progressHandle) throws OperationException {
        assert (validator != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                Object object = this;
                // MONITORENTER : object
                assert (InstallSupportImpl.this.currentStep != STEP.FINISHED);
                if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                    // MONITOREXIT : object
                    return false;
                }
                InstallSupportImpl.this.currentStep = STEP.VALIDATION;
                // MONITOREXIT : object
                assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty());
                object = InstallSupportImpl.this.support.getContainer().listAll();
                if (progressHandle != null) {
                    progressHandle.start(InstallSupportImpl.this.wasDownloaded);
                }
                int n = 0;
                try {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        boolean bl;
                        OperationContainer.OperationInfo operationInfo = (OperationContainer.OperationInfo)iterator.next();
                        Object object2 = this;
                        // MONITORENTER : object2
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            Boolean bl2 = false;
                            // MONITOREXIT : object2
                            return bl2;
                        }
                        // MONITOREXIT : object2
                        object2 = Trampoline.API.impl(operationInfo.getUpdateElement());
                        boolean bl3 = bl = ((UpdateElementImpl)object2).getInstallInfo().getCustomInstaller() != null;
                        if (bl) {
                            assert (false) : "InstallSupportImpl cannot support CustomInstaller!";
                            continue;
                        }
                        n += InstallSupportImpl.this.doValidate(operationInfo, progressHandle, n);
                    }
                    return true;
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.progress("");
                        progressHandle.finish();
                    }
                }
            }
        };
        boolean bl = false;
        try {
            bl = this.getExecutionService().submit(callable).get();
        }
        catch (InterruptedException interruptedException) {
            if (interruptedException.getCause() instanceof OperationException) {
                throw (OperationException)interruptedException.getCause();
            }
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof OperationException) {
                throw (OperationException)executionException.getCause();
            }
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean doInstall(InstallSupport.Installer installer, final ProgressHandle progressHandle) throws OperationException {
        assert (installer != null);
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                Boolean bl;
                boolean bl2;
                block34: {
                    URL uRL;
                    Iterator iterator3;
                    Object object;
                    Object object2 = this;
                    // MONITORENTER : object2
                    assert (InstallSupportImpl.this.currentStep != STEP.FINISHED) : (Object)((Object)InstallSupportImpl.access$100(InstallSupportImpl.this)) + " != STEP.FINISHED";
                    if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                        // MONITOREXIT : object2
                        return false;
                    }
                    InstallSupportImpl.this.currentStep = STEP.INSTALLATION;
                    // MONITOREXIT : object2
                    assert (InstallSupportImpl.this.support.getContainer().listInvalid().isEmpty()) : "listInvalid() isEmpty() but " + InstallSupportImpl.access$000(InstallSupportImpl.this).getContainer().listInvalid();
                    object2 = InstallSupportImpl.this.support.getContainer().listAll();
                    InstallSupportImpl.this.affectedModuleImpls = new HashSet();
                    InstallSupportImpl.this.affectedFeatureImpls = new HashSet();
                    if (progressHandle != null) {
                        progressHandle.start();
                    }
                    Iterator iterator2 = object2.iterator();
                    block17: while (iterator2.hasNext()) {
                        object = (OperationContainer.OperationInfo)iterator2.next();
                        iterator3 = Trampoline.API.impl(((OperationContainer.OperationInfo)object).getUpdateElement());
                        switch (((UpdateElementImpl)((Object)iterator3)).getType()) {
                            case KIT_MODULE: 
                            case MODULE: {
                                InstallSupportImpl.this.affectedModuleImpls.add((ModuleUpdateElementImpl)((Object)iterator3));
                                continue block17;
                            }
                            case STANDALONE_MODULE: 
                            case FEATURE: {
                                InstallSupportImpl.this.affectedFeatureImpls.add((FeatureUpdateElementImpl)((Object)iterator3));
                                InstallSupportImpl.this.affectedModuleImpls.addAll(((FeatureUpdateElementImpl)((Object)iterator3)).getContainedModuleElements());
                                continue block17;
                            }
                        }
                        assert (false) : "Unsupported type " + iterator3;
                    }
                    bl2 = false;
                    for (Iterator iterator3 : InstallSupportImpl.this.affectedModuleImpls) {
                        Object object3 = this;
                        // MONITORENTER : object3
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            // MONITOREXIT : object3
                            return false;
                        }
                        // MONITOREXIT : object3
                        if (Utilities.isElementInstalled(((UpdateElementImpl)((Object)iterator3)).getUpdateElement())) continue;
                        object3 = ((UpdateElementImpl)((Object)iterator3)).getUpdateUnit().getInstalled();
                        File file = InstallSupportImpl.this.getTargetCluster((UpdateElement)object3, (UpdateElementImpl)((Object)iterator3), InstallSupportImpl.this.isGlobal);
                        uRL = ((ModuleUpdateElementImpl)((Object)iterator3)).getInstallInfo().getDistribution();
                        err.log(Level.FINE, "Source URL for " + ((ModuleUpdateElementImpl)((Object)iterator3)).getCodeName() + " is " + uRL);
                        boolean bl3 = uRL.getFile().toLowerCase(Locale.US).endsWith(InstallSupportImpl.NBM_EXTENTSION.toLowerCase(Locale.US));
                        File file2 = InstallSupportImpl.getDestination(file, ((ModuleUpdateElementImpl)((Object)iterator3)).getCodeName(), bl3);
                        bl2 |= InstallSupportImpl.this.needsRestart(object3 != null, iterator3, file2);
                    }
                    try {
                        Utilities.writeAdditionalInformation(InstallSupportImpl.this.getElement2Clusters());
                        if (bl2) break block34;
                        object = this;
                        // MONITORENTER : object
                        if (InstallSupportImpl.this.currentStep == STEP.CANCEL) {
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            iterator3 = false;
                            // MONITOREXIT : object
                            return iterator3;
                        }
                        // MONITOREXIT : object
                        if (progressHandle != null) {
                            progressHandle.switchToDeterminate(InstallSupportImpl.this.affectedModuleImpls.size());
                        }
                        if (!InstallSupportImpl.this.getDownloadedFiles().isEmpty()) {
                            object = UpdaterFrame.runFromIDE(InstallSupportImpl.this.getDownloadedFiles(), new RefreshModulesListener(progressHandle), NbBundle.getBranding(), false);
                            try {
                                ((Thread)object).join();
                                for (Object object3 : InstallSupportImpl.this.affectedModuleImpls) {
                                    int n;
                                    uRL = Utilities.toModule(((ModuleUpdateElementImpl)object3).getCodeName(), ((ModuleUpdateElementImpl)object3).getSpecificationVersion().toString());
                                    for (n = 0; !(n >= 100 || uRL != null && uRL.isEnabled()); ++n) {
                                        Thread.sleep(100L);
                                        uRL = Utilities.toModule(((ModuleUpdateElementImpl)object3).getCodeName(), ((ModuleUpdateElementImpl)object3).getSpecificationVersion().toString());
                                    }
                                    if (n != 100) continue;
                                    err.log(Level.INFO, "Overflow checks of installed module " + uRL);
                                    ((Thread)object).interrupt();
                                    break;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                err.log(Level.INFO, interruptedException.getMessage(), interruptedException);
                                ((Thread)object).interrupt();
                            }
                        }
                        InstallSupportImpl.this.afterInstall();
                        InstallSupportImpl.this.downloadedFiles = null;
                    }
                    finally {
                        if (progressHandle != null) {
                            progressHandle.progress("");
                            progressHandle.finish();
                        }
                    }
                }
                if (bl2) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        };
        boolean bl = false;
        try {
            bl = this.getExecutionService().submit(callable).get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        finally {
            if (!bl) {
                this.getElement2Clusters().clear();
            }
        }
        return bl;
    }

    private void afterInstall() {
        UpdateElement updateElement;
        UpdateUnit updateUnit;
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl updateElementImpl : this.affectedModuleImpls) {
                updateUnit = updateElementImpl.getUpdateUnit();
                updateElement = updateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedModuleImpls = null;
        }
        if (this.affectedFeatureImpls != null) {
            for (FeatureUpdateElementImpl featureUpdateElementImpl : this.affectedFeatureImpls) {
                updateUnit = featureUpdateElementImpl.getUpdateUnit();
                updateElement = featureUpdateElementImpl.getUpdateElement();
                Trampoline.API.impl(updateUnit).updateInstalled(updateElement);
            }
            this.affectedFeatureImpls = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progressHandle) throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            assert (this.currentStep != STEP.FINISHED);
            if (this.currentStep == STEP.CANCEL) {
                return;
            }
            this.currentStep = STEP.RESTART;
        }
        Utilities.deleteAllDoLater();
        this.getElement2Clusters().clear();
        LifecycleManager.getDefault().exit();
        this.doRestartLater(restarter);
    }

    public void doRestartLater(OperationSupport.Restarter restarter) {
        if (this.affectedModuleImpls != null) {
            for (ModuleUpdateElementImpl moduleUpdateElementImpl : this.affectedModuleImpls) {
                UpdateUnitFactory.getDefault().scheduleForRestart(moduleUpdateElementImpl.getUpdateElement());
            }
        }
        Utilities.writeInstallLater(new HashMap<UpdateElementImpl, File>(this.getElement2Clusters()));
        this.getElement2Clusters().clear();
        this.downloadedFiles = null;
    }

    public String getCertificate(InstallSupport.Installer installer, UpdateElement updateElement) {
        Collection<Certificate> collection = this.certs.get(updateElement);
        if (collection != null) {
            String string = "";
            for (Certificate certificate : collection) {
                string = string + certificate;
            }
            return string;
        }
        return null;
    }

    public boolean isTrusted(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        boolean bl = false;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                bl = this.trusted.contains(updateElementImpl);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                bl = !set.isEmpty();
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    bl &= this.trusted.contains(moduleUpdateElementImpl);
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return bl;
    }

    public boolean isSigned(InstallSupport.Installer installer, UpdateElement updateElement) {
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        boolean bl = false;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                bl = this.signed.contains(updateElementImpl);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                bl = !set.isEmpty();
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    bl &= this.signed.contains(moduleUpdateElementImpl);
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() throws OperationException {
        InstallSupportImpl installSupportImpl = this;
        synchronized (installSupportImpl) {
            this.currentStep = STEP.CANCEL;
        }
        if (this.es != null) {
            try {
                this.es.shutdownNow();
            }
            catch (AccessControlException accessControlException) {
                err.log(Level.INFO, accessControlException.getMessage(), accessControlException);
            }
        }
        for (File file : this.getDownloadedFiles()) {
            if (file == null || !file.exists()) continue;
            file.delete();
        }
        this.getDownloadedFiles().clear();
        if (this.affectedFeatureImpls != null) {
            this.affectedFeatureImpls = null;
        }
        if (this.affectedModuleImpls != null) {
            this.affectedModuleImpls = null;
        }
        this.getElement2Clusters().clear();
    }

    private int doDownload(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n, int n2) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n3 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n3 += this.doDownload(updateElementImpl, progressHandle, n, n2);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n4 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n5 = this.doDownload(moduleUpdateElementImpl, progressHandle, n4, n2);
                    if (n5 == -1) {
                        return -1;
                    }
                    n4 += n5;
                    n3 += n5;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n, int n2) throws OperationException {
        Object object = this;
        synchronized (object) {
            if (this.currentStep == STEP.CANCEL) {
                return -1;
            }
        }
        object = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster((UpdateElement)object, updateElementImpl, this.isGlobal);
        assert (file != null) : "Target cluster for " + updateElementImpl + " must exist.";
        if (file == null) {
            file = InstallManager.getUserDir();
        }
        URL uRL = updateElementImpl.getInstallInfo().getDistribution();
        err.log(Level.FINE, "Source URL for " + updateElementImpl.getCodeName() + " is " + uRL);
        boolean bl = uRL.getFile().toLowerCase(Locale.US).endsWith(NBM_EXTENTSION.toLowerCase(Locale.US));
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName(), bl);
        if (file2.exists()) {
            err.log(Level.FINE, "Target NBM file " + file2 + " of " + updateElementImpl.getUpdateElement() + " already downloaded.");
            return updateElementImpl.getDownloadSize();
        }
        int n3 = 0;
        try {
            String string = updateElementImpl.getDisplayName();
            this.getDownloadedFiles().add(FileUtil.normalizeFile((File)file2));
            n3 = this.copy(uRL, file2, progressHandle, updateElementImpl.getDownloadSize(), n, n2, string);
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            throw new OperationException(OperationException.ERROR_TYPE.PROXY, uRL.toString());
        }
        return n3;
    }

    private int doValidate(OperationContainer.OperationInfo operationInfo, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = operationInfo.getUpdateElement();
        UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
        int n2 = 0;
        switch (updateElementImpl.getType()) {
            case KIT_MODULE: 
            case MODULE: {
                n2 = this.doValidate(updateElementImpl, progressHandle, n);
                break;
            }
            case STANDALONE_MODULE: 
            case FEATURE: {
                FeatureUpdateElementImpl featureUpdateElementImpl = (FeatureUpdateElementImpl)updateElementImpl;
                Set<ModuleUpdateElementImpl> set = featureUpdateElementImpl.getContainedModuleElements();
                int n3 = n;
                for (ModuleUpdateElementImpl moduleUpdateElementImpl : set) {
                    if (Utilities.isElementInstalled(moduleUpdateElementImpl.getUpdateElement())) continue;
                    int n4 = this.doValidate(moduleUpdateElementImpl, progressHandle, n3);
                    n3 += n4;
                    n2 += n4;
                }
                break;
            }
            default: {
                assert (false) : "Unsupported type " + updateElementImpl;
                break;
            }
        }
        return n2;
    }

    private int doValidate(UpdateElementImpl updateElementImpl, ProgressHandle progressHandle, int n) throws OperationException {
        UpdateElement updateElement = updateElementImpl.getUpdateUnit().getInstalled();
        File file = this.getTargetCluster(updateElement, updateElementImpl, this.isGlobal);
        File file2 = InstallSupportImpl.getDestination(file, updateElementImpl.getCodeName());
        assert (file2.exists()) : file2.getAbsolutePath();
        int n2 = 0;
        n2 = this.verifyNbm(updateElementImpl.getUpdateElement(), file2, progressHandle, n);
        return n2;
    }

    static File getDestination(File file, String string, boolean bl) {
        err.log(Level.FINE, "Target cluster for " + string + " is " + file);
        File file2 = new File(file, DOWNLOAD_DIR);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string2 = string.replace('.', '-');
        File file3 = new File(file2, string2 + (bl ? NBM_EXTENTSION : ""));
        err.log(Level.FINE, "Destination file for " + string + " is " + file3);
        return file3;
    }

    private static File getDestination(File file, String string) {
        return InstallSupportImpl.getDestination(file, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copy(URL uRL, File file, ProgressHandle progressHandle, int n, int n2, int n3, String string) throws MalformedURLException, IOException {
        int n4 = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        err.log(Level.FINEST, "Copy " + uRL + " to " + file + "[" + n + "]");
        try {
            int n5;
            byte[] byArray = new byte[1024];
            int n6 = 0;
            while ((n5 = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n5);
                n4 += n5;
                n6 += n5;
                if (!this.progressRunning && progressHandle != null) {
                    progressHandle.switchToDeterminate(n3);
                    this.progressRunning = true;
                }
                if (n6 <= 1024) continue;
                if (progressHandle != null) {
                    assert (this.progressRunning);
                    progressHandle.switchToDeterminate(n3);
                    int n7 = n2 + (n4 < n ? n4 : n);
                    progressHandle.progress(string, n7 < n3 ? n7 : n3);
                }
                n6 = 0;
            }
            if (n != n4) {
                err.log(Level.FINEST, "Increment (" + n4 + ") of is not equal to estimatedSize (" + n + ").");
            }
        }
        catch (IOException iOException) {
            err.log(Level.INFO, "Writing content of URL " + uRL + " failed.", iOException);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.flush();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
            catch (IOException iOException) {
                err.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        err.log(Level.FINE, "Destination " + file + " is successfully wrote. Size " + file.length());
        return n;
    }

    private int verifyNbm(UpdateElement updateElement, File file, ProgressHandle progressHandle, int n) throws OperationException {
        String string = null;
        try {
            n += updateElement.getDownloadSize();
            if (progressHandle != null) {
                progressHandle.progress(updateElement.getDisplayName(), n < this.wasDownloaded ? n : this.wasDownloaded);
            }
            Collection<Certificate> collection = InstallSupportImpl.getNbmCertificates(file);
            assert (collection != null);
            if (collection.size() > 0) {
                this.certs.put(updateElement, collection);
            }
            if (collection.isEmpty()) {
                string = "UNSIGNED";
            } else {
                ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                for (KeyStore keyStore : Utilities.getKeyStore()) {
                    arrayList.addAll(InstallSupportImpl.getCertificates(keyStore));
                }
                if (arrayList.containsAll(collection)) {
                    string = "TRUSTED";
                    this.trusted.add(updateElementImpl);
                    this.signed.add(updateElementImpl);
                } else {
                    string = "UNTRUSTED";
                    this.signed.add(updateElementImpl);
                }
            }
        }
        catch (IOException iOException) {
            err.log(Level.INFO, iOException.getMessage(), iOException);
            string = "BAD_DOWNLOAD";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        catch (KeyStoreException keyStoreException) {
            err.log(Level.INFO, keyStoreException.getMessage(), keyStoreException);
            string = "CORRUPTED";
            throw new OperationException(OperationException.ERROR_TYPE.INSTALL, NbBundle.getMessage(InstallSupportImpl.class, (String)"InstallSupportImpl_Validate_CorruptedNBM", (Object)file));
        }
        err.log(Level.FINE, "NBM " + file + " was verified as " + string);
        return updateElement.getDownloadSize();
    }

    private static Collection<Certificate> getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (String string : Collections.list(keyStore.aliases())) {
            arrayList.add(keyStore.getCertificate(string));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Certificate> getNbmCertificates(File file) throws IOException {
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        JarFile jarFile = new JarFile(file);
        try {
            for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                InstallSupportImpl.verifyEntry(jarFile, jarEntry);
                if (jarEntry.getCertificates() == null) continue;
                hashSet.addAll(Arrays.asList(jarEntry.getCertificates()));
            }
        }
        finally {
            jarFile.close();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = jarFile.getInputStream(jarEntry);
            byte[] byArray = new byte[8192];
            boolean bl = false;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private boolean needsRestart(boolean bl, UpdateElementImpl updateElementImpl, File file) {
        return InstallManager.needsRestart(bl, updateElementImpl, file);
    }

    private File getTargetCluster(UpdateElement updateElement, UpdateElementImpl updateElementImpl, boolean bl) {
        File file = this.getElement2Clusters().get(updateElementImpl);
        if (file == null && (file = InstallManager.findTargetDirectory(updateElement, updateElementImpl, bl)) != null) {
            this.getElement2Clusters().put(updateElementImpl, file);
        }
        return file;
    }

    private Map<UpdateElementImpl, File> getElement2Clusters() {
        if (this.element2Clusters == null) {
            this.element2Clusters = new HashMap<UpdateElementImpl, File>();
        }
        return this.element2Clusters;
    }

    private ExecutorService getExecutionService() {
        if (this.es == null || this.es.isShutdown()) {
            this.es = Executors.newSingleThreadExecutor();
        }
        return this.es;
    }

    private Set<File> getDownloadedFiles() {
        if (this.downloadedFiles == null) {
            this.downloadedFiles = new HashSet<File>();
        }
        return this.downloadedFiles;
    }

    private static final class RefreshModulesListener
    implements PropertyChangeListener {
        private ProgressHandle handle;
        private int i;

        public RefreshModulesListener(ProgressHandle progressHandle) {
            this.handle = progressHandle;
            this.i = 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("RUNNING".equals(propertyChangeEvent.getPropertyName())) {
                if (this.handle != null) {
                    this.handle.progress(this.i++);
                }
            } else if ("FINISHED".equals(propertyChangeEvent.getPropertyName())) {
                final FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
                err.log(Level.FINE, "It's a hack: Call refresh on " + fileObject + " file object.");
                if (fileObject != null) {
                    try {
                        Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                            public void run() throws IOException {
                                fileObject.getParent().refresh();
                                fileObject.refresh();
                            }
                        });
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            } else assert (false) : "Unknown property " + propertyChangeEvent.getPropertyName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STEP {
        NOTSTARTED,
        DOWNLOAD,
        VALIDATION,
        INSTALLATION,
        RESTART,
        FINISHED,
        CANCEL;

    }
}

