/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LocaleSelectorDialog
extends JDialog {
    private int dialogResult = 2;
    private Locale selectedLocale = null;
    private boolean updating = false;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonDefault;
    private JLabel jLabelCountry;
    private JLabel jLabelCountryTip;
    private JLabel jLabelLanguage;
    private JLabel jLabelLanguageTip;
    private JLabel jLabelVariant;
    private JLabel jLabelVariantTip;
    private JList jListLocales;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelCustom;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldCountry;
    private JTextField jTextFieldLanguage;
    private JTextField jTextFieldVariant;

    public LocaleSelectorDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public LocaleSelectorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        Locale[] locales = Locale.getAvailableLocales();
        Vector<Object> v = new Vector<Object>();
        v.add(I18n.getString("LocaleSelectorDialog.Timezone.Default"));
        for (int i = 0; i < locales.length; ++i) {
            v.add(new Tag(locales[i], locales[i].getDisplayName()));
        }
        this.jListLocales.setListData(v);
        this.jListLocales.setSelectedIndex(0);
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LocaleSelectorDialog.this.jButton2ActionPerformed(e);
            }
        };
        DocumentListener dl = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                LocaleSelectorDialog.this.updateCustomLocale();
            }

            public void insertUpdate(DocumentEvent e) {
                LocaleSelectorDialog.this.updateCustomLocale();
            }

            public void removeUpdate(DocumentEvent e) {
                LocaleSelectorDialog.this.updateCustomLocale();
            }
        };
        this.jTextFieldCountry.getDocument().addDocumentListener(dl);
        this.jTextFieldLanguage.getDocument().addDocumentListener(dl);
        this.jTextFieldVariant.getDocument().addDocumentListener(dl);
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListLocales = new JList();
        this.jPanelCustom = new JPanel();
        this.jLabelLanguage = new JLabel();
        this.jTextFieldLanguage = new JTextField();
        this.jLabelLanguageTip = new JLabel();
        this.jLabelCountry = new JLabel();
        this.jTextFieldCountry = new JTextField();
        this.jLabelCountryTip = new JLabel();
        this.jLabelVariant = new JLabel();
        this.jTextFieldVariant = new JTextField();
        this.jLabelVariantTip = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButtonDefault = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(350, 80));
        this.jPanel2.setPreferredSize(new Dimension(400, 300));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jListLocales.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                LocaleSelectorDialog.this.jListLocalesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListLocales);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jTabbedPane1.addTab(I18n.getString("LocaleSelectorDialog.Pane.PredefLocales"), this.jPanel2);
        this.jPanel2.getAccessibleContext().setAccessibleName(I18n.getString("LocaleSelectorDialog.Panel.Locale"));
        this.jPanelCustom.setLayout(new GridBagLayout());
        this.jLabelLanguage.setText(I18n.getString("LocaleSelectorDialog.Label.Language"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(16, 8, 0, 4);
        this.jPanelCustom.add((Component)this.jLabelLanguage, gridBagConstraints);
        this.jTextFieldLanguage.setMinimumSize(new Dimension(90, 19));
        this.jTextFieldLanguage.setPreferredSize(new Dimension(90, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(14, 0, 0, 4);
        this.jPanelCustom.add((Component)this.jTextFieldLanguage, gridBagConstraints);
        this.jLabelLanguageTip.setText(I18n.getString("LocaleSelectorDialog.Label.Tip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(16, 0, 0, 8);
        this.jPanelCustom.add((Component)this.jLabelLanguageTip, gridBagConstraints);
        this.jLabelCountry.setText(I18n.getString("LocaleSelectorDialog.Label.Country"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 8, 0, 4);
        this.jPanelCustom.add((Component)this.jLabelCountry, gridBagConstraints);
        this.jTextFieldCountry.setMinimumSize(new Dimension(90, 19));
        this.jTextFieldCountry.setPreferredSize(new Dimension(90, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanelCustom.add((Component)this.jTextFieldCountry, gridBagConstraints);
        this.jLabelCountryTip.setText(I18n.getString("LocaleSelectorDialog.Label.Tip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 8);
        this.jPanelCustom.add((Component)this.jLabelCountryTip, gridBagConstraints);
        this.jLabelVariant.setText(I18n.getString("LocaleSelectorDialog.Label.Variant"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 8, 0, 4);
        this.jPanelCustom.add((Component)this.jLabelVariant, gridBagConstraints);
        this.jTextFieldVariant.setMinimumSize(new Dimension(90, 19));
        this.jTextFieldVariant.setPreferredSize(new Dimension(90, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanelCustom.add((Component)this.jTextFieldVariant, gridBagConstraints);
        this.jLabelVariantTip.setText(I18n.getString("LocaleSelectorDialog.Label.Tip0"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 8);
        this.jPanelCustom.add((Component)this.jLabelVariantTip, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelCustom.add((Component)this.jPanel3, gridBagConstraints);
        this.jTabbedPane1.addTab("Custom locale", this.jPanelCustom);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonDefault.setText(I18n.getString("LocaleSelectorDialog.ButtonSystemDefault"));
        this.jButtonDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleSelectorDialog.this.jButton1ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButtonDefault, gridBagConstraints);
        this.jButton1.setText(I18n.getString("Global.Button.Ok"));
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleSelectorDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText(I18n.getString("Global.Button.Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleSelectorDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed1(ActionEvent evt) {
        this.setSelectedLocale(Locale.getDefault());
        this.jButton1ActionPerformed(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jListLocalesValueChanged(ListSelectionEvent evt) {
        this.updating = true;
        try {
            if (this.jListLocales.getSelectedIndex() >= 0) {
                this.jButton1.setEnabled(true);
                if (this.jListLocales.getSelectedIndex() > 0) {
                    Locale locale = (Locale)((Tag)this.jListLocales.getSelectedValue()).getValue();
                    this.jTextFieldLanguage.setText(locale.getLanguage());
                    this.jTextFieldCountry.setText(locale.getCountry());
                    this.jTextFieldVariant.setText(locale.getVariant());
                } else {
                    this.jTextFieldLanguage.setText("");
                    this.jTextFieldCountry.setText("");
                    this.jTextFieldVariant.setText("");
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    private void updateCustomLocale() {
        if (this.updating) {
            return;
        }
        this.jListLocales.clearSelection();
        if (this.jTextFieldLanguage.getText().trim().length() == 0) {
            this.jButton1.setEnabled(false);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jListLocales.getSelectedIndex() < 0) {
            this.selectedLocale = null;
            String language = this.jTextFieldLanguage.getText().trim();
            String country = this.jTextFieldCountry.getText().trim();
            String variant = this.jTextFieldVariant.getText().trim();
            if (language != null && language.trim().length() > 0) {
                this.selectedLocale = country != null && country.trim().length() > 0 ? (variant != null && variant.trim().length() > 0 ? new Locale(language, country, variant) : new Locale(language, country)) : new Locale(language);
            }
        } else {
            this.selectedLocale = this.jListLocales.getSelectedIndex() == 0 ? null : (Locale)((Tag)this.jListLocales.getSelectedValue()).getValue();
        }
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public Locale getSelectedLocale() {
        return this.selectedLocale;
    }

    public void setSelectedLocale(Locale selectedLocale) {
        this.selectedLocale = selectedLocale;
        for (int i = 1; i < this.jListLocales.getModel().getSize(); ++i) {
            Locale loc = (Locale)((Tag)this.jListLocales.getModel().getElementAt(i)).getValue();
            if (!loc.equals(selectedLocale)) continue;
            this.jListLocales.setSelectedIndex(i);
            this.jListLocales.ensureIndexIsVisible(i);
            return;
        }
        this.jListLocales.clearSelection();
        this.jTextFieldLanguage.setText(selectedLocale.getLanguage());
        this.jTextFieldCountry.setText(selectedLocale.getCountry());
        this.jTextFieldVariant.setText(selectedLocale.getVariant());
        this.jTabbedPane1.setSelectedIndex(1);
    }

    public String getSelectedLocaleId() {
        Locale loc = this.getSelectedLocale();
        if (loc == null) {
            return null;
        }
        String s = loc.getLanguage();
        if (loc.getCountry().length() > 0) {
            s = s + "_" + loc.getCountry();
            if (loc.getVariant().length() > 0) {
                s = s + "_" + loc.getVariant();
            }
        }
        return s;
    }

    public void setSelectedLocaleId(String s) {
        if (s == null) {
            return;
        }
        Locale newLocale = Misc.getLocaleFromString(s, null);
        if (newLocale != null) {
            this.setSelectedLocale(newLocale);
        }
    }
}

