/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab.wizard;

import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.jdesktop.layout.GroupLayout;

public class GroupPanel
extends JPanel {
    public static final int GROUP = 1;
    public static final int MEASURE = 2;
    int type = 1;
    private JComboBox jComboBoxGroup;
    private JComboBox jComboBoxGroupBy;
    private JLabel jLabelGroupByFunction;
    private JLabel jLabelGroupMeasure;

    public GroupPanel(int type) {
        this.initComponents();
        this.jComboBoxGroup.setRenderer(new ExpObjectCellRenderer());
        this.type = type;
        if (type == 1) {
            this.jLabelGroupMeasure.setText(I18n.getString("GroupPanel.Label.Group"));
            this.jLabelGroupByFunction.setText(I18n.getString("GroupPanel.Label.GroupBy"));
            this.jLabelGroupByFunction.setEnabled(false);
            this.jComboBoxGroupBy.setEnabled(false);
        } else {
            this.jLabelGroupMeasure.setText(I18n.getString("GroupPanel.Label.Measure"));
            this.jLabelGroupByFunction.setText(I18n.getString("GroupPanel.Label.Function"));
            this.jLabelGroupByFunction.setEnabled(true);
            this.jComboBoxGroupBy.setEnabled(true);
        }
    }

    public void setTitle(String title) {
        ((TitledBorder)this.getBorder()).setTitle(title);
    }

    public void setDataset(JRDesignDataset dataset, boolean addNullValue) {
        if (addNullValue) {
            this.jComboBoxGroup.addItem("");
        }
        List fields = dataset.getFieldsList();
        for (int i = 0; i < fields.size(); ++i) {
            this.jComboBoxGroup.addItem(fields.get(i));
        }
        List parameters = dataset.getParametersList();
        for (int i = 0; i < parameters.size(); ++i) {
            this.jComboBoxGroup.addItem(parameters.get(i));
        }
        List variables = dataset.getVariablesList();
        for (int i = 0; i < variables.size(); ++i) {
            this.jComboBoxGroup.addItem(variables.get(i));
        }
    }

    boolean isUsed() {
        return this.jComboBoxGroup.getSelectedIndex() != 0 || !this.jComboBoxGroup.getSelectedItem().equals("");
    }

    private void initComponents() {
        this.jLabelGroupMeasure = new JLabel();
        this.jComboBoxGroup = new JComboBox();
        this.jLabelGroupByFunction = new JLabel();
        this.jComboBoxGroupBy = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), I18n.getString("GroupPanel.border.title")));
        this.jLabelGroupMeasure.setHorizontalAlignment(4);
        this.jLabelGroupMeasure.setText(I18n.getString("GroupPanel.jLabelGroupMeasure.text"));
        this.jComboBoxGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupPanel.this.jComboBoxGroupActionPerformed(evt);
            }
        });
        this.jLabelGroupByFunction.setHorizontalAlignment(4);
        this.jLabelGroupByFunction.setText(I18n.getString("GroupPanel.jLabelGroupByFunction.text"));
        this.jLabelGroupByFunction.setEnabled(false);
        this.jComboBoxGroupBy.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabelGroupByFunction, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelGroupMeasure, -1, 75, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jComboBoxGroupBy, 0, 196, Short.MAX_VALUE).add((Component)this.jComboBoxGroup, 0, 196, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelGroupMeasure).add((Component)this.jComboBoxGroup, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelGroupByFunction).add((Component)this.jComboBoxGroupBy, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
    }

    private void jComboBoxGroupActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            this.jComboBoxGroupBy.removeAllItems();
            List list = this.getGroupByValues();
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    this.jComboBoxGroupBy.addItem(list.get(i));
                }
                this.jComboBoxGroupBy.setSelectedItem(0);
            }
            this.jComboBoxGroupBy.setEnabled(list.size() > 0);
            this.jLabelGroupByFunction.setEnabled(list.size() > 0);
        } else {
            this.jComboBoxGroupBy.removeAllItems();
            List list = this.getFunctions();
            Misc.updateComboBox(this.jComboBoxGroupBy, list, false);
            if (list.size() > 0) {
                this.jComboBoxGroupBy.setSelectedIndex(0);
            }
        }
        this.updateUI();
    }

    public List getGroupByValues() {
        String classtype = "java.lang.String";
        ArrayList<Tag> groupByValues = new ArrayList<Tag>();
        groupByValues.add(new Tag(I18n.getString("GroupPanel.Label.Unique"), I18n.getString("GroupPanel.Label.Unique")));
        Object obj = this.jComboBoxGroup.getSelectedItem();
        if (obj instanceof JRField) {
            classtype = ((JRField)obj).getValueClassName();
        } else if (obj instanceof JRParameter) {
            classtype = ((JRParameter)obj).getValueClassName();
        } else if (obj instanceof JRVariable) {
            classtype = ((JRVariable)obj).getValueClassName();
        }
        try {
            this.getClass();
            Class<?> clazz = Class.forName(classtype);
            if (Date.class.isAssignableFrom(clazz)) {
                groupByValues.add(new Tag(I18n.getString("Global.ComboBox.Year"), I18n.getString("Global.ComboBox.Year")));
                groupByValues.add(new Tag(I18n.getString("Global.ComboBox.Month"), I18n.getString("Global.ComboBox.Month")));
                groupByValues.add(new Tag(I18n.getString("Global.ComboBox.Week"), I18n.getString("Global.ComboBox.Week")));
                groupByValues.add(new Tag(I18n.getString("Global.ComboBox.Day"), I18n.getString("Global.ComboBox.Day")));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return groupByValues;
    }

    public List getFunctions() {
        String classtype = "java.lang.String";
        ArrayList<Tag> functions = new ArrayList<Tag>();
        functions.add(new Tag(1, I18n.getString("GroupPanel.Label.Count")));
        Object obj = this.jComboBoxGroup.getSelectedItem();
        if (obj instanceof JRField) {
            classtype = ((JRField)obj).getValueClassName();
        } else if (obj instanceof JRParameter) {
            classtype = ((JRParameter)obj).getValueClassName();
        } else if (obj instanceof JRVariable) {
            classtype = ((JRVariable)obj).getValueClassName();
        }
        try {
            this.getClass();
            Class<?> clazz = Class.forName(classtype);
            if (Number.class.isAssignableFrom(clazz)) {
                functions.add(new Tag(2, I18n.getString("GroupPanel.Function.Sum")));
                functions.add(new Tag(1, I18n.getString("GroupPanel.Function.Count")));
                functions.add(new Tag(10, I18n.getString("GroupPanel.Function.DistinctCount")));
                functions.add(new Tag(3, I18n.getString("GroupPanel.Function.Average")));
                functions.add(new Tag(6, I18n.getString("GroupPanel.Function.StandardDeviation")));
                functions.add(new Tag(7, I18n.getString("GroupPanel.Function.Variance")));
            }
            if (Date.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz)) {
                functions.add(new Tag(4, I18n.getString("GroupPanel.Function.Lowest")));
                functions.add(new Tag(5, I18n.getString("GroupPanel.Function.Highest")));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        functions.add(new Tag(9, I18n.getString("GroupPanel.Function.First")));
        functions.add(new Tag(0, I18n.getString("GroupPanel.Function.Nothing")));
        return functions;
    }

    public String getGroupMeasureName() {
        Object obj = this.jComboBoxGroup.getSelectedItem();
        if (obj instanceof JRField) {
            return ((JRField)obj).getName();
        }
        if (obj instanceof JRParameter) {
            return ((JRParameter)obj).getName();
        }
        if (obj instanceof JRVariable) {
            return ((JRVariable)obj).getName();
        }
        return "" + obj;
    }

    public String getExpression(String groupByType) {
        String expression = "";
        Object obj = this.jComboBoxGroup.getSelectedItem();
        if (obj instanceof JRField) {
            expression = "$F{" + ((JRField)obj).getName() + "}";
        } else if (obj instanceof JRParameter) {
            expression = "$P{" + ((JRParameter)obj).getName() + "}";
        } else if (obj instanceof JRVariable) {
            expression = "$V{" + ((JRVariable)obj).getName() + "}";
        }
        if (groupByType != null) {
            if (groupByType.equals(I18n.getString("Global.ComboBox.Year"))) {
                return "(new SimpleDateFormat(\"yyyy\")).format(" + expression + ")";
            }
            if (groupByType.equals(I18n.getString("Global.ComboBox.Month"))) {
                return "(new SimpleDateFormat(\"yyyy-MM\")).format(" + expression + ")";
            }
            if (groupByType.equals(I18n.getString("Global.ComboBox.Week"))) {
                return "(new SimpleDateFormat(\"yyyy-ww\")).format(" + expression + ")";
            }
            if (groupByType.equals(I18n.getString("Global.ComboBox.Day"))) {
                return "(new SimpleDateFormat(\"yyyy-MM-dd\")).format(" + expression + ")";
            }
        }
        return expression;
    }

    public String getExpressionClass(String groupByType) {
        Object obj = this.jComboBoxGroup.getSelectedItem();
        if (groupByType != null && !groupByType.equals(I18n.getString("GroupPanel.Function.Unique"))) {
            return "java.lang.String";
        }
        if (obj instanceof JRField) {
            return ((JRField)obj).getValueClassName();
        }
        if (obj instanceof JRParameter) {
            return ((JRParameter)obj).getValueClassName();
        }
        if (obj instanceof JRVariable) {
            return ((JRVariable)obj).getValueClassName();
        }
        return "java.lang.String";
    }

    public JRDesignExpression getDesignExpression() {
        Object obj = this.jComboBoxGroup.getSelectedItem();
        String groupByType = null;
        if (this.type == 1) {
            Object gb = this.jComboBoxGroupBy.getSelectedItem();
            if (gb != null && gb instanceof Tag) {
                groupByType = ((Tag)gb).getValue() + "";
            }
            Object var3_3 = null;
        }
        return Misc.createExpression(this.getExpressionClass(groupByType), this.getExpression(groupByType));
    }

    public byte getCalculationType() {
        byte b = 1;
        Object gb = this.jComboBoxGroupBy.getSelectedItem();
        if (gb != null && gb instanceof Tag && ((Tag)gb).getValue() instanceof Byte) {
            b = (Byte)((Tag)gb).getValue();
        }
        return b;
    }
}

