/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverListNodeInfo;
import org.netbeans.modules.db.explorer.nodes.LeafNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DriverNode
extends LeafNode
implements PropertyChangeListener {
    public void setInfo(DatabaseNodeInfo databaseNodeInfo) {
        super.setInfo(databaseNodeInfo);
        DatabaseDriver databaseDriver = (DatabaseDriver)databaseNodeInfo.get("dbdriver");
        if (databaseDriver != null) {
            databaseNodeInfo.put("name", databaseDriver.getName());
            databaseNodeInfo.put("url", databaseDriver.getURL());
            databaseNodeInfo.put("adaptorClass", databaseDriver.getDatabaseAdaptor());
            databaseNodeInfo.addDriverListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DatabaseNodeInfo databaseNodeInfo = this.getInfo();
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        DatabaseDriver databaseDriver = (DatabaseDriver)databaseNodeInfo.get("dbdriver");
        if (string.equals("name")) {
            databaseDriver.setName((String)object);
        }
        if (string.equals("url")) {
            databaseDriver.setURL((String)object);
        }
        if (string.equals("prefix")) {
            databaseDriver.setDatabasePrefix((String)object);
        }
    }

    public String getShortDescription() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("ND_Driver");
    }

    public void destroy() throws IOException {
        DriverListNodeInfo driverListNodeInfo = (DriverListNodeInfo)this.getInfo().getParent();
        this.getInfo().delete();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DriverNode.class);
    }
}

