/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm;

import org.springframework.dao.OptimisticLockingFailureException;

public class ObjectOptimisticLockingFailureException
extends OptimisticLockingFailureException {
    private Object persistentClass;
    private Object identifier;

    public ObjectOptimisticLockingFailureException(String msg, Throwable ex) {
        super(msg, ex);
    }

    public ObjectOptimisticLockingFailureException(Class persistentClass, Object identifier) {
        this(persistentClass, identifier, "Object of class [" + persistentClass.getName() + "] with identifier [" + identifier + "]: optimistic locking failed", null);
    }

    public ObjectOptimisticLockingFailureException(Class persistentClass, Object identifier, String msg, Throwable ex) {
        super(msg, ex);
        this.persistentClass = persistentClass;
        this.identifier = identifier;
    }

    public ObjectOptimisticLockingFailureException(String persistentClassName, Object identifier) {
        this(persistentClassName, identifier, "Object of class [" + persistentClassName + "] with identifier [" + identifier + "]: optimistic locking failed", null);
    }

    public ObjectOptimisticLockingFailureException(String persistentClassName, Object identifier, String msg, Throwable ex) {
        super(msg, ex);
        this.persistentClass = persistentClassName;
        this.identifier = identifier;
    }

    public Class getPersistentClass() {
        return this.persistentClass instanceof Class ? (Class)this.persistentClass : null;
    }

    public String getPersistentClassName() {
        if (this.persistentClass instanceof Class) {
            return ((Class)this.persistentClass).getName();
        }
        return this.persistentClass != null ? this.persistentClass.toString() : null;
    }

    public Object getIdentifier() {
        return this.identifier;
    }
}

