/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.util.Vector;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseNodeChildren;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.ConnectionOwnerOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;

public class RootNodeInfo
extends DatabaseNodeInfo
implements ConnectionOwnerOperations {
    static final long serialVersionUID = -8079386805046070315L;
    static RootNodeInfo rootInfo = null;

    public static RootNodeInfo getInstance() throws DatabaseException {
        if (rootInfo == null) {
            rootInfo = (RootNodeInfo)DatabaseNodeInfo.createNodeInfo(null, "root");
        }
        return rootInfo;
    }

    public void initChildren(Vector vector) throws DatabaseException {
        try {
            FileObject fileObject;
            DataFolder dataFolder;
            ConnectionNodeInfo connectionNodeInfo;
            DatabaseConnection databaseConnection;
            DatabaseConnection[] databaseConnectionArray = ConnectionList.getDefault().getConnections();
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                databaseConnection = databaseConnectionArray[i];
                connectionNodeInfo = this.createConnectionNodeInfo(databaseConnection);
                vector.add(connectionNodeInfo);
            }
            Repository repository = Repository.getDefault();
            databaseConnection = repository.getDefaultFileSystem();
            connectionNodeInfo = databaseConnection.getRoot();
            FileObject fileObject2 = connectionNodeInfo.getFileObject("Database");
            if (fileObject2 != null && (dataFolder = DataFolder.findFolder((FileObject)(fileObject = fileObject2.getFileObject("Adaptors")))) != null) {
                vector.add(dataFolder.getNodeDelegate());
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception);
        }
    }

    private ConnectionNodeInfo createConnectionNodeInfo(DatabaseConnection databaseConnection) throws DatabaseException {
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)RootNodeInfo.createNodeInfo(this, "connection");
        connectionNodeInfo.setUser(databaseConnection.getUser());
        connectionNodeInfo.setDatabase(databaseConnection.getDatabase());
        connectionNodeInfo.setSchema(databaseConnection.getSchema());
        connectionNodeInfo.setName(databaseConnection.getName());
        connectionNodeInfo.setDatabaseConnection(databaseConnection);
        return connectionNodeInfo;
    }

    public void refreshChildren() throws DatabaseException {
    }

    public void addConnectionNoConnect(DatabaseConnection databaseConnection) throws DatabaseException {
        this.getChildren();
        if (ConnectionList.getDefault().contains(databaseConnection)) {
            return;
        }
        DatabaseNode databaseNode = this.getNode();
        DatabaseNodeChildren databaseNodeChildren = (DatabaseNodeChildren)databaseNode.getChildren();
        ConnectionNodeInfo connectionNodeInfo = this.createConnectionNodeInfo(databaseConnection);
        ConnectionList.getDefault().add(databaseConnection);
        databaseNodeChildren.createSubnode(connectionNodeInfo, true);
    }

    public void addConnection(DBConnection dBConnection) throws DatabaseException {
        DatabaseConnection databaseConnection = (DatabaseConnection)dBConnection;
        this.getChildren();
        if (ConnectionList.getDefault().contains(databaseConnection)) {
            throw new DatabaseException(RootNodeInfo.bundle().getString("EXC_ConnectionAlreadyExists"));
        }
        DatabaseNode databaseNode = this.getNode();
        DatabaseNodeChildren databaseNodeChildren = (DatabaseNodeChildren)databaseNode.getChildren();
        databaseNodeChildren.getNodes(true);
        ConnectionNodeInfo connectionNodeInfo = this.createConnectionNodeInfo(databaseConnection);
        ConnectionList.getDefault().add(databaseConnection);
        DatabaseNode databaseNode2 = databaseNodeChildren.createSubnode(connectionNodeInfo, true);
        if (databaseConnection.getConnection() == null) {
            ((ConnectionNodeInfo)databaseNode2.getInfo()).connect();
        } else {
            ((ConnectionNodeInfo)databaseNode2.getInfo()).connect(databaseConnection);
        }
    }
}

