/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import nickyb.sqleonardo.common.util.Appearance;
import nickyb.sqleonardo.environment.ctrl.content.ContentModel;

public class LineNumberView
extends JTable {
    private int block = 1;
    private int rows = 0;

    public LineNumberView() {
        super(0, 1);
        this.setAutoscrolls(false);
        this.setAutoCreateColumnsFromModel(false);
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(0).setCellRenderer(new InternalCellRenderer());
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int idx) {
        return Object.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int idx) {
        return "#";
    }

    public int getRowCount() {
        return this.rows;
    }

    public void setRowCount(int rows) {
        this.rows = rows;
    }

    void setBlock(int idx) {
        this.block = idx;
    }

    public Object getValueAt(int row, int column) {
        return new Integer(ContentModel.MAX_BLOCK_RECORDS * (this.block - 1) + (row + 1));
    }

    private class InternalCellRenderer
    extends DefaultTableCellRenderer {
        private InternalCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
            }
            this.setHorizontalAlignment(0);
            this.setText(value == null ? "" : value.toString());
            this.setFont(isSelected ? Appearance.fontBOLD : Appearance.fontPLAIN);
            return this;
        }
    }
}

