/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import nickyb.sqleonardo.common.gui.CustomLineBorder;
import nickyb.sqleonardo.common.util.Appearance;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.ContentChanges;
import nickyb.sqleonardo.environment.ctrl.content.ContentModel;
import nickyb.sqleonardo.environment.ctrl.content.ContentPopup;
import nickyb.sqleonardo.environment.ctrl.content.LineNumberView;
import nickyb.sqleonardo.environment.ctrl.content.TaskRetrieve;

public class ContentView
extends JPanel
implements ListSelectionListener {
    private JTable data;
    private LineNumberView lines;
    private ContentModel model;
    private ContentPopup popup;
    private ContentPane control;

    public ContentView(ContentPane control) {
        super(new GridLayout(1, 1));
        this.control = control;
        this.data = new JTable();
        this.model = new ContentModel();
        this.data.setModel(this.model);
        this.popup = new ContentPopup(this);
        this.data.addMouseListener(this.popup);
        this.data.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 40) {
                    if (ContentView.this.data.getSelectedRow() == ContentView.this.data.getRowCount() - 1 && ContentView.this.getBlock() < ContentView.this.getBlockCount()) {
                        int col = ContentView.this.data.getSelectedColumn();
                        ContentView.this.control.getSlider().setValue(ContentView.this.getBlock());
                        ContentView.this.data.setRowSelectionInterval(0, 0);
                        ContentView.this.data.scrollRectToVisible(ContentView.this.data.getCellRect(0, col, true));
                        key.consume();
                    }
                } else if (key.getKeyCode() == 38 && ContentView.this.data.getSelectedRow() == 0 && ContentView.this.getBlock() > 1) {
                    int col = ContentView.this.data.getSelectedColumn();
                    ContentView.this.control.getSlider().setValue(ContentView.this.getBlock() - 2);
                    int row = ContentView.this.data.getRowCount() - 1;
                    ContentView.this.data.setRowSelectionInterval(row, row);
                    ContentView.this.data.scrollRectToVisible(ContentView.this.data.getCellRect(row, col, true));
                    key.consume();
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.data);
        scroll.getViewport().setBackground(Color.white);
        this.add(scroll);
        this.data.setRowSelectionAllowed(false);
        this.data.setAutoResizeMode(0);
        this.data.setSelectionMode(0);
        this.data.setDefaultRenderer(Object.class, new InternalCellRenderer());
        this.data.getTableHeader().addMouseListener(this.popup);
        this.data.getTableHeader().setReorderingAllowed(false);
        this.lines = new LineNumberView();
        this.lines.addMouseListener(this.popup);
        this.lines.setSelectionModel(this.data.getSelectionModel());
        scroll.setRowHeaderView(this.lines);
        JLabel cUL = new JLabel("#", 0);
        cUL.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        cUL.setFont(UIManager.getFont("TableHeader.font"));
        scroll.setCorner("UPPER_LEFT_CORNER", cUL);
        JLabel cLL = new JLabel();
        cLL.setBorder(new CustomLineBorder(true, false, false, false));
        scroll.setCorner("LOWER_LEFT_CORNER", cLL);
        this.data.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.data.getActionMap().put("copy", ((JMenuItem)this.popup.getSubElementsAt(1)).getAction());
        this.data.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
        this.data.getActionMap().put("paste", ((JMenuItem)this.popup.getSubElementsAt(2)).getAction());
        this.data.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "paste");
        this.data.getActionMap().put("set-null", ((JMenuItem)this.popup.getSubElementsAt(3)).getAction());
        this.data.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "set-null");
    }

    ContentPane getControl() {
        return this.control;
    }

    public void addRow(Object[] rowdata, boolean newrow) {
        this.model.addRow(rowdata, newrow);
        this.lines.setRowCount(this.getRowCount());
    }

    public void addColumn(String text) {
        this.addColumn(text, 1);
    }

    public void addColumn(String text, int type) {
        this.model.addColumn(text, type);
    }

    public void deleteRow(int row) {
        this.model.deleteRow(row);
        this.lines.setRowCount(this.getRowCount());
        this.onTableChanged(true);
    }

    public void insertRow(int row) {
        this.model.insertRow(row);
        this.lines.setRowCount(this.getRowCount());
        this.onTableChanged(true);
    }

    public int getCurrentRow() {
        return this.data.getSelectedRow();
    }

    public int getCurrentColumn() {
        return this.data.getSelectedColumn();
    }

    private InternalHeaderCellRenderer getHeaderRenderer(int idx) {
        TableColumn tc = this.data.getColumnModel().getColumn(idx);
        if (tc.getHeaderRenderer() != null) {
            return (InternalHeaderCellRenderer)tc.getHeaderRenderer();
        }
        InternalHeaderCellRenderer ihcr = new InternalHeaderCellRenderer();
        tc.setHeaderRenderer(ihcr);
        return ihcr;
    }

    public void setToolTipText(int i, String text) {
        this.getHeaderRenderer(i).setToolTipText(text);
    }

    public int getBlockCount() {
        return this.model.getBlockCount();
    }

    public int getBlock() {
        return this.model.getBlock();
    }

    public void setBlock(int idx) {
        this.model.setBlock(idx);
        this.lines.setBlock(idx);
        this.lines.setRowCount(this.getRowCount());
        this.onTableChanged(true);
    }

    public ContentChanges getChanges() {
        return this.model.getChanges();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public int getColumnIndex(String name) {
        return this.model.getColumnIndex(name);
    }

    public String getColumnName(int idx) {
        return this.model.getColumnName(idx);
    }

    public int getColumnType(int idx) {
        return this.model.getColumnType(idx);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public Object getLineAt(int row) {
        return this.lines.getValueAt(row, 0);
    }

    Object[] getValues(int row) {
        return this.model.getValues(row);
    }

    Object[] getValues(Long rid) {
        return this.model.getValues(rid);
    }

    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(row, col);
    }

    public void setValueAt(Object aValue, int row, int col) {
        this.model.setValueAt(aValue, row, col);
    }

    public int getFlatRowCount() {
        return this.model.getFlatRowCount();
    }

    public Object getFlatValueAt(int row, int col) {
        return this.model.getFlatValueAt(row, col);
    }

    public void resetFlatValueAt(int row, int col) {
        this.model.resetFlatValueAt(row, col);
    }

    public void setFlatValueAt(Object aValue, int row, int col) {
        this.model.setFlatValueAt(aValue, row, col);
    }

    public void reset() {
        this.model = new ContentModel();
        this.data.setModel(this.model);
        this.lines.setRowCount(0);
        this.lines.setBlock(1);
    }

    public Object getCellValue() {
        return this.data.getValueAt(this.data.getSelectedRow(), this.data.getSelectedColumn());
    }

    public void resetCellValue() {
        this.model.resetValueAt(this.data.getSelectedRow(), this.data.getSelectedColumn());
        this.data.tableChanged(new TableModelEvent(this.data.getModel(), this.data.getSelectedRow()));
    }

    public void setCellValue(Object value) {
        this.data.setValueAt(value, this.data.getSelectedRow(), this.data.getSelectedColumn());
        this.data.tableChanged(new TableModelEvent(this.data.getModel(), this.data.getSelectedRow()));
    }

    public void setSelectedCell(int row, int col) {
        this.data.setRowSelectionInterval(row, row);
        this.data.setColumnSelectionInterval(col, col);
        this.data.scrollRectToVisible(this.data.getCellRect(row, col, true));
    }

    public void sort(int col, short type) {
        this.model.sort(col, type);
    }

    public void onTableChanged(boolean onlyData) {
        this.data.tableChanged(onlyData ? new TableModelEvent(this.model) : null);
        this.lines.tableChanged(null);
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getValueIsAdjusting()) {
            return;
        }
        for (int i = 0; i < this.data.getColumnModel().getColumnCount(); ++i) {
            this.getHeaderRenderer(i).setSelected(this.getCurrentColumn() == i);
        }
        this.data.getTableHeader().repaint();
    }

    private class InternalCellRenderer
    extends DefaultTableCellRenderer {
        private InternalCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            super.setFont(Appearance.fontPLAIN);
            super.setOpaque(true);
            if (isSelected && !hasFocus) {
                super.setBackground(ContentView.this.data.getSelectionBackground());
            } else {
                super.setBackground(UIManager.getDefaults().getColor("Table.background"));
            }
            if (value == null) {
                super.setText("<null>");
                if (ContentView.this.model.isCellChanged(row, col)) {
                    super.setForeground(Color.green);
                } else {
                    super.setForeground(Color.lightGray);
                }
            } else if (ContentView.this.model.isCellChanged(row, col)) {
                super.setForeground(Color.blue);
            } else {
                super.setForeground(UIManager.getDefaults().getColor("Table.foreground"));
            }
            if (TaskRetrieve.isNumberType(ContentView.this.getColumnType(col))) {
                super.setHorizontalAlignment(4);
            } else {
                super.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    private class InternalHeaderCellRenderer
    extends DefaultTableCellRenderer {
        InternalHeaderCellRenderer() {
            this.setFont(Appearance.fontPLAIN);
            this.setHorizontalAlignment(0);
        }

        private void setSelected(boolean b) {
            this.setFont(b ? Appearance.fontBOLD : Appearance.fontPLAIN);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
            }
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

