/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.ContentModel;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;
import nickyb.sqleonardo.environment.ctrl.content.DialogPreview;
import nickyb.sqleonardo.environment.ctrl.content.TableMetaData;
import nickyb.sqleonardo.environment.ctrl.content.TaskRetrieve;
import nickyb.sqleonardo.environment.ctrl.content.TaskUpdate;
import nickyb.sqleonardo.environment.ctrl.editor._TaskSource;

public class ContentPane
extends BorderLayoutPanel
implements ChangeListener {
    private boolean readonly;
    private JSlider sld;
    private JLabel status;
    private JTextArea syntax;
    private ContentView view;
    private _TaskSource query;
    private Thread task;

    public ContentPane(_TaskSource query, boolean readonly, boolean retrieve) {
        super(2, 2);
        this.query = query;
        this.readonly = readonly;
        this.getActionMap().put("changes-save", new ActionSaveChanges());
        this.getActionMap().put("changes-show", new ActionShowChanges());
        this.getActionMap().put("record-insert", new ActionInsertRecord());
        this.getActionMap().put("record-delete", new ActionDeleteRecord());
        this.getActionMap().put("stop-task", new ActionStopTask());
        this.sld = new JSlider(1);
        this.sld.addChangeListener(this);
        this.sld.setSnapToTicks(true);
        this.sld.setInverted(true);
        this.sld.setValue(0);
        this.sld.setMinimum(0);
        this.sld.setMaximum(0);
        this.status = new JLabel("...");
        this.status.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 4, 2, 4)));
        this.syntax = new JTextArea();
        JScrollPane scroll = new JScrollPane(this.syntax);
        this.syntax.setRows(3);
        this.syntax.setText(query.getSyntax());
        this.syntax.setWrapStyleWord(true);
        this.syntax.setLineWrap(true);
        this.syntax.setEditable(false);
        this.syntax.setOpaque(false);
        BorderLayoutPanel pnlSouth = new BorderLayoutPanel(2, 2);
        pnlSouth.setComponentCenter(this.status);
        pnlSouth.setComponentNorth(scroll);
        this.setComponentWest(this.sld);
        this.setComponentSouth(pnlSouth);
        this.view = new ContentView(this);
        this.setComponentCenter(this.view);
        if (retrieve) {
            this.onBeginTask(new TaskRetrieve(this, query));
        } else {
            for (int i = 0; i < ((TableMetaData)query).getColumns().size(); ++i) {
                String name = ((TableMetaData)query).getColumnProperty(i, 3);
                String type = ((TableMetaData)query).getColumnProperty(i, 4);
                this.view.addColumn(name, Integer.valueOf(type));
            }
            this.onEndTask();
            this.doRefreshStatus();
            this.view.onTableChanged(false);
        }
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public _TaskSource getTaskSource() {
        return this.query;
    }

    public JSlider getSlider() {
        return this.sld;
    }

    public ContentView getView() {
        return this.view;
    }

    public void onBeginTask(Runnable r) {
        this.setCursor(new Cursor(3));
        this.getActionMap().get("changes-save").setEnabled(false);
        this.getActionMap().get("changes-show").setEnabled(false);
        this.getActionMap().get("record-insert").setEnabled(false);
        this.getActionMap().get("record-delete").setEnabled(false);
        this.task = new Thread(r);
        this.task.start();
        this.getActionMap().get("stop-task").setEnabled(true);
    }

    public boolean isBusy() {
        return this.task != null;
    }

    public void onEndTask() {
        this.task = null;
        this.getActionMap().get("stop-task").setEnabled(false);
        this.getActionMap().get("changes-save").setEnabled(!this.readonly);
        this.getActionMap().get("changes-show").setEnabled(!this.readonly);
        this.getActionMap().get("record-insert").setEnabled(!this.readonly);
        this.getActionMap().get("record-delete").setEnabled(!this.readonly);
        this.setCursor(new Cursor(0));
    }

    public void doRefreshStatus() {
        this.sld.setMaximum(this.view.getBlockCount() == 0 ? 0 : this.view.getBlockCount() - 1);
        if (this.view.getRowCount() > 0) {
            this.status.setText("block " + this.view.getBlock() + " of " + this.view.getBlockCount() + " | record " + this.view.getLineAt(0) + " to " + this.view.getLineAt(this.view.getRowCount() - 1) + " of " + this.view.getFlatRowCount() + " | changes " + this.view.getChanges().count());
        } else {
            this.status.setText("0 records");
        }
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int block = source.getValue() + 1;
            if (this.view != null && block != this.view.getBlock()) {
                this.view.setBlock(block);
                this.doRefreshStatus();
            }
        }
    }

    private class ActionStopTask
    extends AbstractAction {
        ActionStopTask() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.011"));
        }

        public void actionPerformed(ActionEvent ae) {
            ContentPane.this.onEndTask();
        }
    }

    private class ActionDeleteRecord
    extends AbstractAction {
        ActionDeleteRecord() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.161"));
            this.putValue("ShortDescription", "delete record");
            this.putValue("Name", "delete record");
        }

        public void actionPerformed(ActionEvent ae) {
            int row = ContentPane.this.view.getCurrentRow();
            int col = ContentPane.this.view.getCurrentColumn();
            if (row == -1) {
                return;
            }
            ContentPane.this.view.deleteRow(row);
            ContentPane.this.doRefreshStatus();
            if (ContentPane.this.view.getRowCount() == 0) {
                return;
            }
            if (row >= ContentPane.this.view.getRowCount()) {
                row = ContentPane.this.view.getRowCount() - 1;
            }
            ContentPane.this.view.setSelectedCell(row, col == -1 ? 0 : col);
        }
    }

    private class ActionInsertRecord
    extends AbstractAction {
        ActionInsertRecord() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.160"));
            this.putValue("ShortDescription", "insert record");
            this.putValue("Name", "insert record");
        }

        public void actionPerformed(ActionEvent ae) {
            int row = ContentPane.this.view.getCurrentRow();
            int col = ContentPane.this.view.getCurrentColumn();
            ContentPane.this.view.insertRow(++row);
            ContentPane.this.doRefreshStatus();
            if (row == ContentModel.MAX_BLOCK_RECORDS) {
                row = 0;
                ContentPane.this.sld.setValue(ContentPane.this.sld.getValue() + 1);
            }
            ContentPane.this.view.setSelectedCell(row, col == -1 ? 0 : col);
        }
    }

    private class ActionShowChanges
    extends AbstractAction {
        ActionShowChanges() {
            super("show changes...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (((TableMetaData)ContentPane.this.query).getPrimaryKeys().size() == 0) {
                Application.alert("SQLeonardo", "no primary keys founded!");
                return;
            }
            new DialogPreview(ContentPane.this.view, (TableMetaData)ContentPane.this.query).show();
        }
    }

    private class ActionSaveChanges
    extends AbstractAction {
        ActionSaveChanges() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.162"));
            this.putValue("ShortDescription", "save changes");
        }

        public void actionPerformed(ActionEvent ae) {
            if (((TableMetaData)ContentPane.this.query).getPrimaryKeys().size() == 0) {
                Application.alert("SQLeonardo", "no primary keys founded!");
                return;
            }
            ContentPane.this.onBeginTask(new TaskUpdate(ContentPane.this, ContentPane.this.query));
        }
    }
}

