/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;

public class ListView
extends BorderLayoutPanel {
    private static ClipboardOwner defaultClipboardOwner = new ClipboardObserver();
    private JTable table = new JTable();

    public ListView() {
        super(2, 2);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.getViewport().setBackground(Color.white);
        this.setComponentCenter(scroll);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.reset();
        this.table.getActionMap().put("copy", new ActionCopyCell());
        this.table.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
    }

    protected JTable getJavaComponent() {
        return this.table;
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.table.getSelectionModel().addListSelectionListener(l);
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.table.addMouseListener(l);
    }

    public void addColumn(String text) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.addColumn(text);
    }

    public void setColumnWidth(String text, int size) {
        TableColumn tableColumn = this.table.getColumn(text);
        tableColumn.setPreferredWidth(size);
        tableColumn.setWidth(size);
    }

    public void setHeaderVisible(boolean aFlag) {
        this.table.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.table.getTableHeader().setVisible(aFlag);
    }

    public void addRow(Object[] rowdata) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.addRow(rowdata);
    }

    public boolean isSelectionEmpty() {
        return this.table.getSelectedRowCount() < 1;
    }

    public String getColumnName(int col) {
        return this.table.getColumnName(col);
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public Object getValueAt(int row, int col) {
        return this.table.getValueAt(row, col);
    }

    public void setValueAt(Object value, int row, int col) {
        this.table.setValueAt(value, row, col);
    }

    public void removeRow(int row) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.removeRow(row);
    }

    public void removeSelectedRow() {
        this.removeRow(this.getSelectedRow());
    }

    public void removeAllRows() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setRowCount(0);
    }

    public void copyAllRows() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                String cell;
                String string = cell = this.table.getValueAt(i, j) == null ? null : this.table.getValueAt(i, j).toString();
                if (j > 0) {
                    sb.append("\t");
                }
                sb.append(cell);
            }
            sb.append("\n");
        }
        Clipboard cb = this.getToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(sb.toString());
        cb.setContents(contents, defaultClipboardOwner);
    }

    public void reset() {
        DefaultTableModel model = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(model);
    }

    public void tableDataChanged() {
        this.table.tableChanged(new TableModelEvent(this.table.getModel()));
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    private class ActionCopyCell
    extends AbstractAction {
        private ActionCopyCell() {
        }

        public void actionPerformed(ActionEvent ae) {
            int col = ListView.this.table.getSelectedColumn();
            int row = ListView.this.table.getSelectedRow();
            if (row != -1 && col != -1) {
                if (ListView.this.table.getValueAt(row, col) == null) {
                    return;
                }
                Clipboard cb = ListView.this.getToolkit().getSystemClipboard();
                String value = ListView.this.table.getValueAt(row, col).toString();
                StringSelection contents = new StringSelection(value);
                cb.setContents(contents, defaultClipboardOwner);
            }
        }
    }
}

