/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.modules.editor.fold.CustomProvider;
import org.netbeans.modules.editor.fold.LayerProvider;
import org.openide.filesystems.Repository;

public abstract class FoldManagerFactoryProvider {
    private static FoldManagerFactoryProvider defaultProvider;
    private static FoldManagerFactoryProvider emptyProvider;
    private static boolean forceCustom;

    public static synchronized FoldManagerFactoryProvider getDefault() {
        if (defaultProvider == null) {
            defaultProvider = FoldManagerFactoryProvider.findDefault();
        }
        return defaultProvider;
    }

    public static FoldManagerFactoryProvider getEmpty() {
        if (emptyProvider == null) {
            emptyProvider = new EmptyProvider();
        }
        return emptyProvider;
    }

    public static synchronized void setForceCustomProvider(boolean bl) {
        if (!forceCustom) {
            defaultProvider = null;
        }
        forceCustom = bl;
    }

    private static FoldManagerFactoryProvider findDefault() {
        FoldManagerFactoryProvider foldManagerFactoryProvider = null;
        if (!forceCustom) {
            try {
                Repository repository = Repository.getDefault();
                if (repository != null && repository.getDefaultFileSystem() != null) {
                    foldManagerFactoryProvider = new LayerProvider();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (foldManagerFactoryProvider == null) {
            foldManagerFactoryProvider = new CustomProvider();
        }
        return foldManagerFactoryProvider;
    }

    public abstract List getFactoryList(FoldHierarchy var1);

    private static final class EmptyProvider
    extends FoldManagerFactoryProvider {
        private EmptyProvider() {
        }

        public List getFactoryList(FoldHierarchy foldHierarchy) {
            return Collections.EMPTY_LIST;
        }
    }
}

