/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.PopUpActions;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;

public class MeasureElement
implements DimensionTreeElement,
QueryElement,
LanguageChangedListener {
    private String catalogName;
    private String cubeName;
    private String measureName;
    private String measureUniqueName;
    private String measureCaption;
    private String expression;
    private boolean nodeEnabled;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private ServerMetadata parent;
    static ImageIcon icon = S.getAppIcon("measure.gif");

    public MeasureElement(ServerMetadata svm, Node rowNode, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties) {
        I18n.addOnLanguageChangedListener(this);
        this.parent = svm;
        this.nodeEnabled = true;
        NodeList nl = rowNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("CATALOG_NAME")) {
                this.catalogName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("CUBE_NAME")) {
                this.cubeName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEASURE_NAME")) {
                this.measureName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEASURE_UNIQUE_NAME")) {
                this.measureUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("MEASURE_CAPTION")) {
                this.measureCaption = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("EXPRESSION")) continue;
            this.expression = DOM.getTextFromDOMElement(nl.item(i));
        }
    }

    public DimensionTreeElement[] getChildren(boolean noMatterWhat) {
        return null;
    }

    public String toString() {
        if (this.measureCaption == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return this.measureCaption;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public String getToolTip() {
        if (this.measureCaption == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "<html>" + I18n.getString("toolTip.measureName") + this.measureName + "<BR>" + I18n.getString("toolTip.measureUniqueName") + this.measureUniqueName + "<BR>" + I18n.getString("toolTip.measureCaption") + this.measureCaption + "<BR>" + I18n.getString("toolTip.measureExpression") + this.expression + "</html>";
    }

    public String[] getPopUpActionList() {
        if (this.isEnabled()) {
            return new String[]{PopUpActions.SEND_TO_MEASURES};
        }
        return null;
    }

    public String getUniqueName() {
        return this.measureUniqueName;
    }

    public String getCaption() {
        return this.measureCaption;
    }

    public String getQueryMembersExpression() {
        return this.measureUniqueName;
    }

    public boolean isEnabled() {
        return this.nodeEnabled;
    }

    public void setEnabled(boolean newValue) {
        this.nodeEnabled = newValue;
    }

    public String getHierarchyUniqueName() {
        return this.measureUniqueName.substring(0, this.measureUniqueName.lastIndexOf(".") - 1);
    }

    public String getDimensionUniqueName() {
        return "[Measures]";
    }

    public boolean isMeasure() {
        return true;
    }

    public int getChildrenCount() {
        return 0;
    }

    public ServerMetadata getServerMetadata() {
        return this.parent;
    }

    public XMLADiscoverRestrictions getRestrictions() {
        return this.restrictions;
    }

    public XMLADiscoverProperties getProperties() {
        return this.properties;
    }

    public void languageChanged(LanguageChangedEvent evt) {
        PopUpActions.popUpCaptions.put(PopUpActions.SEND_TO_MEASURES, I18n.getString("menu.sendToMeasures"));
    }
}

