/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.netbeans.modules.diff.options.CategoryRenderer;
import org.netbeans.modules.diff.options.ColorComboBox;
import org.netbeans.modules.diff.options.DiffOptionsPanel;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.spi.FontsColorsController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffColorsPanel
extends JPanel
implements ActionListener,
FontsColorsController,
PropertyChangeListener {
    private static final String ATTR_NAME_ADDED = "added";
    private static final String ATTR_NAME_DELETED = "deleted";
    private static final String ATTR_NAME_CHANGED = "changed";
    private boolean listen;
    private List<AttributeSet> categories;
    private boolean changed;
    private JComboBox cbBackground;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JList lCategories;

    public DiffColorsPanel() {
        this.initComponents();
        this.setName(DiffColorsPanel.loc("LBL_DiffOptions_Tab"));
        ColorComboBox.init(this.cbBackground);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!DiffColorsPanel.this.listen) {
                    return;
                }
                DiffColorsPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbBackground.addActionListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listen) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() == "color") {
            this.updateData();
            this.changed = true;
        }
    }

    public void update(ColorModel colorModel) {
        this.listen = false;
        this.lCategories.setListData(new Vector<AttributeSet>(this.getCategories()));
        this.lCategories.setSelectedIndex(0);
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    public void cancel() {
        this.changed = false;
    }

    public void applyChanges() {
        List<AttributeSet> list = this.getCategories();
        for (AttributeSet attributeSet : list) {
            if (ATTR_NAME_ADDED.equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setAddedColor((Color)attributeSet.getAttribute(StyleConstants.Background));
            }
            if (ATTR_NAME_CHANGED.equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) {
                DiffModuleConfig.getDefault().setChangedColor((Color)attributeSet.getAttribute(StyleConstants.Background));
            }
            if (!ATTR_NAME_DELETED.equals(attributeSet.getAttribute(StyleConstants.NameAttribute))) continue;
            DiffModuleConfig.getDefault().setDeletedColor((Color)attributeSet.getAttribute(StyleConstants.Background));
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setCurrentProfile(String string) {
        this.refreshUI();
    }

    public void deleteProfile(String string) {
    }

    public JComponent getComponent() {
        return this;
    }

    Collection<AttributeSet> getHighlightings() {
        return this.getCategories();
    }

    private static String loc(String string) {
        return NbBundle.getMessage(DiffColorsPanel.class, (String)string);
    }

    private void updateData() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            return;
        }
        List<AttributeSet> list = this.getCategories();
        AttributeSet attributeSet = list.get(this.lCategories.getSelectedIndex());
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        Color color = ColorComboBox.getColor(this.cbBackground);
        if (color != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, color);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Background);
        }
        list.set(n, simpleAttributeSet);
    }

    private void refreshUI() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            this.cbBackground.setEnabled(false);
            return;
        }
        this.cbBackground.setEnabled(true);
        List<AttributeSet> list = this.getCategories();
        AttributeSet attributeSet = list.get(n);
        this.listen = false;
        ColorComboBox.setColor(this.cbBackground, (Color)attributeSet.getAttribute(StyleConstants.Background));
        this.listen = true;
    }

    private List<AttributeSet> getCategories() {
        if (this.categories == null) {
            this.categories = this.getDiffHighlights();
            Collections.sort(this.categories, new CategoryComparator());
        }
        return this.categories;
    }

    private List<AttributeSet> getDiffHighlights() {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        SimpleAttributeSet simpleAttributeSet = null;
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, DiffModuleConfig.getDefault().getAddedColor());
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_ADDED);
        simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_AddedColor"));
        arrayList.add(simpleAttributeSet);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, DiffModuleConfig.getDefault().getDeletedColor());
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_DELETED);
        simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_DeletedColor"));
        arrayList.add(simpleAttributeSet);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, DiffModuleConfig.getDefault().getChangedColor());
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, ATTR_NAME_CHANGED);
        simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, NbBundle.getMessage(DiffOptionsPanel.class, (String)"LBL_ChangedColor"));
        arrayList.add(simpleAttributeSet);
        return arrayList;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lCategories = new JList();
        this.jLabel3 = new JLabel();
        this.cbBackground = new JComboBox();
        this.jLabel1.setLabelFor(this.lCategories);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DiffColorsPanel.class, (String)"DiffColorsPanel.jLabel1.text"));
        this.lCategories.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane1.setViewportView(this.lCategories);
        this.jLabel3.setLabelFor(this.cbBackground);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(DiffColorsPanel.class, (String)"DiffColorsPanel.jLabel3.text"));
        this.cbBackground.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 344, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.cbBackground, -2, 215, -2)).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbBackground, -2, -1, -2).add((Component)this.jLabel3)).add((Component)this.jScrollPane1, -1, 382, Short.MAX_VALUE)).addContainerGap()));
    }
}

