/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class DiffAction
extends NodeAction {
    public DiffAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffActionName");
    }

    static FileObject getFileFromNode(Node node) {
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                return project.getProjectDirectory();
            }
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            if (dataObject != null) {
                fileObject = dataObject.getPrimaryFile();
            }
        }
        return fileObject;
    }

    public boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 2) {
            FileObject fileObject = DiffAction.getFileFromNode(nodeArray[0]);
            FileObject fileObject2 = DiffAction.getFileFromNode(nodeArray[1]);
            if (fileObject != null && fileObject2 != null && fileObject.isData() && fileObject2.isData()) {
                Diff diff = Diff.getDefault();
                return diff != null;
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return true;
    }

    public void performAction(Node[] nodeArray) {
        FileObject fileObject;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            fileObject = DiffAction.getFileFromNode(nodeArray[i]);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        if (arrayList.size() < 2) {
            return;
        }
        FileObject fileObject2 = (FileObject)arrayList.get(0);
        fileObject = (FileObject)arrayList.get(1);
        DiffAction.performAction(fileObject2, fileObject);
    }

    public static void performAction(FileObject fileObject, FileObject fileObject2) {
        DiffAction.performAction(fileObject, fileObject2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performAction(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) {
        Component component;
        Object object;
        Diff diff = Diff.getDefault();
        if (diff == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DiffAction.class, (String)"MSG_NoDiffVisualizer")));
            return;
        }
        Reader reader = null;
        Reader reader2 = null;
        try {
            if (fileObject3 != null) {
                reader = new InputStreamReader(fileObject.getInputStream(), FileEncodingQuery.getEncoding((FileObject)fileObject3));
                reader2 = new InputStreamReader(fileObject2.getInputStream(), FileEncodingQuery.getEncoding((FileObject)fileObject3));
            } else {
                reader = new InputStreamReader(fileObject.getInputStream(), FileEncodingQuery.getEncoding((FileObject)fileObject));
                reader2 = new InputStreamReader(fileObject2.getInputStream(), FileEncodingQuery.getEncoding((FileObject)fileObject2));
            }
            object = fileObject3 != null ? fileObject3.getMIMEType() : fileObject.getMIMEType();
            final Thread thread = Thread.currentThread();
            Cancellable cancellable = new Cancellable(){

                public boolean cancel() {
                    thread.interrupt();
                    return true;
                }
            };
            String string = NbBundle.getMessage(DiffAction.class, (String)"BK0001");
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)cancellable);
            try {
                progressHandle.start();
                component = diff.createDiff(fileObject.getNameExt(), FileUtil.getFileDisplayName((FileObject)fileObject), reader, fileObject2.getNameExt(), FileUtil.getFileDisplayName((FileObject)fileObject2), reader2, (String)object);
            }
            finally {
                progressHandle.finish();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (reader2 != null) {
                    reader2.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (component != null) {
            object = component;
            SwingUtilities.invokeLater(new Runnable((Component)object){
                final /* synthetic */ Component val$ftp;
                {
                    this.val$ftp = component;
                }

                public void run() {
                    if (this.val$ftp instanceof TopComponent) {
                        ((TopComponent)this.val$ftp).open();
                        ((TopComponent)this.val$ftp).requestActive();
                    } else {
                        this.val$ftp.setVisible(true);
                        this.val$ftp.requestFocusInWindow();
                    }
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DiffAction.class);
    }
}

