/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.lang.reflect.Method;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.reflect.FastClass;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.tuple.AbstractComponentTuplizer;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.util.ReflectHelper;

public class PojoComponentTuplizer
extends AbstractComponentTuplizer {
    private final Class componentClass;
    private transient BulkBean optimizer;
    private transient FastClass fastClass;
    private final Getter parentGetter;
    private final Setter parentSetter;

    public Class getMappedClass() {
        return this.componentClass;
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        if (this.optimizer != null) {
            try {
                return this.optimizer.getPropertyValues(component);
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception getting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", false, this.componentClass, ReflectHelper.getPropertyName(t, this.optimizer));
            }
        }
        return super.getPropertyValues(component);
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        if (this.optimizer != null) {
            try {
                this.optimizer.setPropertyValues(component, values);
                return;
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", true, this.componentClass, ReflectHelper.getPropertyName(t, this.optimizer));
            }
        }
        super.setPropertyValues(component, values);
    }

    public Object getParent(Object component) {
        return this.parentGetter.get(component);
    }

    public boolean hasParentProperty() {
        return this.parentGetter != null;
    }

    public boolean isMethodOf(Method method) {
        for (int i = 0; i < this.propertySpan; ++i) {
            Method getterMethod = this.getters[i].getMethod();
            if (getterMethod == null || !getterMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    public void setParent(Object component, Object parent, SessionFactoryImplementor factory) {
        this.parentSetter.set(component, parent, factory);
    }

    protected Instantiator buildInstantiator(Component component) {
        return new PojoInstantiator(component.getComponentClass(), null, this.fastClass, false);
    }

    protected Getter buildGetter(Component component, Property prop) {
        return prop.getGetter(component.getComponentClass());
    }

    protected Setter buildSetter(Component component, Property prop) {
        return prop.getSetter(component.getComponentClass());
    }

    public PojoComponentTuplizer(Component component) {
        super(component);
        this.componentClass = component.getComponentClass();
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        String parentPropertyName = component.getParentProperty();
        if (parentPropertyName == null) {
            this.parentSetter = null;
            this.parentGetter = null;
        } else {
            PropertyAccessor pa = PropertyAccessorFactory.getPropertyAccessor(null);
            this.parentSetter = pa.getSetter(this.componentClass, parentPropertyName);
            this.parentGetter = pa.getGetter(this.componentClass, parentPropertyName);
        }
        if (this.hasCustomAccessors || !Environment.useReflectionOptimizer()) {
            this.fastClass = null;
            this.optimizer = null;
        } else {
            this.fastClass = ReflectHelper.getFastClass(this.componentClass);
            this.optimizer = ReflectHelper.getBulkBean(this.componentClass, getterNames, setterNames, propTypes, this.fastClass);
            if (this.optimizer == null) {
                this.fastClass = null;
            }
        }
    }
}

