/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.classic.ParserHelper;
import org.hibernate.util.StringHelper;

public final class QuerySplitter {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$QuerySplitter == null ? (class$org$hibernate$hql$QuerySplitter = QuerySplitter.class$("org.hibernate.hql.QuerySplitter")) : class$org$hibernate$hql$QuerySplitter));
    private static final Set BEFORE_CLASS_TOKENS = new HashSet();
    private static final Set NOT_AFTER_CLASS_TOKENS = new HashSet();
    static /* synthetic */ Class class$org$hibernate$hql$QuerySplitter;

    private QuerySplitter() {
    }

    public static String[] concreteQueries(String query, SessionFactoryImplementor factory) throws MappingException {
        String[] tokens = StringHelper.split(" \n\r\f\t(),", query, true);
        if (tokens.length == 0) {
            return new String[]{query};
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        StringBuffer templateQuery = new StringBuffer(40);
        int count = 0;
        String last = null;
        int nextIndex = 0;
        String next = null;
        boolean isSelectClause = false;
        templateQuery.append(tokens[0]);
        if ("select".equals(tokens[0].toLowerCase())) {
            isSelectClause = true;
        }
        for (int i = 1; i < tokens.length; ++i) {
            String token;
            if (!ParserHelper.isWhitespace(tokens[i - 1])) {
                last = tokens[i - 1].toLowerCase();
            }
            if ("from".equals(tokens[i].toLowerCase())) {
                isSelectClause = false;
            }
            if (!ParserHelper.isWhitespace(token = tokens[i]) || last == null) {
                String importedClassName;
                boolean process;
                if (nextIndex <= i) {
                    for (nextIndex = i + 1; nextIndex < tokens.length && ParserHelper.isWhitespace(next = tokens[nextIndex].toLowerCase()); ++nextIndex) {
                    }
                }
                boolean bl = process = !isSelectClause && QuerySplitter.isJavaIdentifier(token) && QuerySplitter.isPossiblyClassName(last, next);
                if (process && (importedClassName = QuerySplitter.getImportedClass(token, factory)) != null) {
                    String[] implementors = factory.getImplementors(importedClassName);
                    String placeholder = "$clazz" + count++ + "$";
                    if (implementors != null) {
                        placeholders.add(placeholder);
                        replacements.add(implementors);
                    }
                    token = placeholder;
                }
            }
            templateQuery.append(token);
        }
        String[] results = StringHelper.multiply(templateQuery.toString(), placeholders.iterator(), replacements.iterator());
        if (results.length == 0) {
            log.warn((Object)("no persistent classes found for query class: " + query));
        }
        return results;
    }

    private static boolean isPossiblyClassName(String last, String next) {
        return "class".equals(last) || BEFORE_CLASS_TOKENS.contains(last) && !NOT_AFTER_CLASS_TOKENS.contains(next);
    }

    private static boolean isJavaIdentifier(String token) {
        return Character.isJavaIdentifierStart(token.charAt(0));
    }

    public static String getImportedClass(String name, SessionFactoryImplementor factory) {
        return factory.getImportedClassName(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BEFORE_CLASS_TOKENS.add("from");
        BEFORE_CLASS_TOKENS.add(",");
        NOT_AFTER_CLASS_TOKENS.add("in");
        NOT_AFTER_CLASS_TOKENS.add("from");
        NOT_AFTER_CLASS_TOKENS.add(")");
    }
}

