/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.io.Serializable;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;

public class Order
implements Serializable {
    private boolean ascending;
    private String propertyName;

    public String toString() {
        return this.propertyName + ' ' + (this.ascending ? "asc" : "desc");
    }

    protected Order(String propertyName, boolean ascending) {
        this.propertyName = propertyName;
        this.ascending = ascending;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        StringBuffer fragment = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            fragment.append(columns[0]).append(this.ascending ? " asc" : " desc");
            if (i >= columns.length - 1) continue;
            fragment.append(", ");
        }
        return fragment.toString();
    }

    public static Order asc(String propertyName) {
        return new Order(propertyName, true);
    }

    public static Order desc(String propertyName) {
        return new Order(propertyName, false);
    }
}

