/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DG<N, E, K, V> {
    private Map<N, Node<N, E, K, V>> idToNode = new HashMap<N, Node<N, E, K, V>>();
    private Map<Node<N, E, K, V>, N> nodeToId = new HashMap<Node<N, E, K, V>, N>();
    private N start;
    private Set<N> ends = new HashSet<N>();
    private static Character NN = new Character('\n');
    private static Character NR = new Character('\n');
    private static Character NT = new Character('\n');
    private static Character NS = new Character('\n');
    private static final Character STAR = new Character('\u0000');

    static <N, E, K, V> DG<N, E, K, V> createDG(N n) {
        return new DG<N, E, K, V>(n);
    }

    static <N, E, K, V> DG<N, E, K, V> createDG() {
        return new DG<N, E, K, V>();
    }

    private DG() {
    }

    private DG(N n) {
        this.start = n;
        Node node = new Node();
        this.idToNode.put(n, node);
        this.nodeToId.put(node, n);
        this.ends.add(n);
    }

    N getStartNode() {
        return this.start;
    }

    void setStart(N n) {
        if (this.idToNode.get(n) == null) {
            new NullPointerException();
        }
        this.start = n;
    }

    Set<N> getEnds() {
        return Collections.unmodifiableSet(this.ends);
    }

    void setEnds(Set<N> set) {
        this.ends = new HashSet<N>(set);
    }

    void addEnd(N n) {
        assert (n != null);
        this.ends.add(n);
    }

    void removeEnd(N n) {
        this.ends.remove(n);
    }

    void addNode(N n) {
        assert (n != null);
        if (this.idToNode.containsKey(n)) {
            throw new IllegalArgumentException();
        }
        Node node = new Node();
        this.idToNode.put(n, node);
        this.nodeToId.put(node, n);
    }

    void removeNode(N n) {
        Node<N, E, K, V> node = this.idToNode.remove(n);
        this.nodeToId.remove(node);
    }

    boolean containsNode(N n) {
        return this.idToNode.containsKey(n);
    }

    Set<N> getNodes() {
        return Collections.unmodifiableSet(this.idToNode.keySet());
    }

    N getNode(N n, E e) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        Node<N, E, K, V> node2 = node.getNode(e);
        return this.nodeToId.get(node2);
    }

    void addEdge(N n, N n2, E e) {
        assert (n != null);
        assert (n2 != null);
        assert (e != null);
        Node<N, E, K, V> node = this.idToNode.get(n);
        Node<N, E, K, V> node2 = this.idToNode.get(n2);
        assert (node != null);
        assert (node2 != null);
        node.addEdge(e, node2);
    }

    Set<E> getEdges(N n) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        return node.edges();
    }

    E getEdge(N n, E e) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        return node.getEdge(e);
    }

    V getProperty(N n, K k) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        return node.getProperty(k);
    }

    Map<K, V> getProperties(N n) {
        Node<N, E, K, V> node;
        if (n == null) {
            System.out.println("!");
        }
        if ((node = this.idToNode.get(n)) == null) {
            System.out.println(n);
        }
        if (((Node)node).properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(((Node)node).properties);
    }

    void putAllProperties(N n, Map<K, V> map) {
        if (map.size() == 0) {
            return;
        }
        Node<N, E, K, V> node = this.idToNode.get(n);
        if (((Node)node).properties == null) {
            ((Node)node).properties = new HashMap();
        }
        ((Node)node).properties.putAll(map);
    }

    void setProperty(N n, K k, V v) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        node.setProperty(k, v);
    }

    V getProperty(N n, E e, K k) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        return node.getEdgeProperty(e, k);
    }

    Map<K, V> getProperties(N n, E e) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        if (((Node)node).idToProperties == null || ((Node)node).idToProperties.get(e) == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)((Node)node).idToProperties.get(e));
    }

    void putAllProperties(N n, E e, Map<K, V> map) {
        if (map.size() == 0) {
            return;
        }
        Node<N, E, K, V> node = this.idToNode.get(n);
        if (((Node)node).idToProperties == null) {
            ((Node)node).idToProperties = new HashMap();
        }
        if (((Node)node).idToProperties.get(e) == null) {
            ((Node)node).idToProperties.put(e, new HashMap());
        }
        ((Map)((Node)node).idToProperties.get(e)).putAll(map);
    }

    void setProperty(N n, E e, K k, V v) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        node.setEdgeProperty(e, k, v);
    }

    void changeKey(N n, N n2) {
        Node<N, E, K, V> node = this.idToNode.get(n);
        this.idToNode.remove(n);
        this.idToNode.put(n2, node);
        this.nodeToId.put(node, n2);
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" start: ").append(this.getStartNode()).append(" end: ");
        Iterator<N> iterator = this.getEnds().iterator();
        while (iterator.hasNext()) {
            N n = iterator.next();
            stringBuffer.append(n);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('\n');
        for (N n : this.getNodes()) {
            stringBuffer.append(n).append('(');
            object = this.getEdges(n).iterator();
            while (object.hasNext()) {
                Object e = object.next();
                Object object2 = this.getNode(n, e);
                stringBuffer.append(this.convert(e)).append(object2);
                if (!object.hasNext()) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(')');
            stringBuffer.append('\n');
        }
        for (N n : this.getNodes()) {
            object = this.idToNode.get(n);
            stringBuffer.append("  ").append(n).append(": ");
            if (((Node)object).properties != null) {
                stringBuffer.append(((Node)object).properties);
            }
            stringBuffer.append('\n');
            if (((Node)object).idToProperties == null) continue;
            for (Object object2 : ((Node)object).idToProperties.keySet()) {
                Map map = (Map)((Node)object).idToProperties.get(object2);
                stringBuffer.append("    ").append(this.convert(object2)).append(": ").append(map).append('\n');
            }
        }
        return stringBuffer.toString();
    }

    private String convert(E e) {
        if (STAR.equals(e)) {
            return ".";
        }
        if (NN.equals(e)) {
            return "\\n";
        }
        if (NR.equals(e)) {
            return "\\r";
        }
        if (NT.equals(e)) {
            return "\\t";
        }
        if (NS.equals(e)) {
            return "' '";
        }
        return e.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<N, E, K, V> {
        private Map<K, V> properties;
        private Map<E, Map<K, V>> idToProperties;
        private Map<E, Node<N, E, K, V>> edgeToNode;
        private Map<E, E> edges;

        private Node() {
        }

        V getProperty(K k) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.get(k);
        }

        void setProperty(K k, V v) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(k, v);
        }

        Node<N, E, K, V> getNode(E e) {
            if (this.edgeToNode == null) {
                return null;
            }
            return this.edgeToNode.get(e);
        }

        void addEdge(E e, Node<N, E, K, V> node) {
            if (this.edgeToNode == null) {
                this.edgeToNode = new HashMap<E, Node<N, E, K, V>>();
            }
            if (this.edges == null) {
                this.edges = new HashMap<E, E>();
            }
            this.edgeToNode.put(e, node);
            this.edges.put(e, e);
        }

        E getEdge(E e) {
            if (this.edges == null) {
                return null;
            }
            return this.edges.get(e);
        }

        Set<E> edges() {
            if (this.edgeToNode == null) {
                return Collections.emptySet();
            }
            return this.edgeToNode.keySet();
        }

        V getEdgeProperty(E e, K k) {
            if (this.idToProperties == null) {
                return null;
            }
            if (this.idToProperties.get(e) == null) {
                return null;
            }
            return this.idToProperties.get(e).get(k);
        }

        void setEdgeProperty(E e, K k, V v) {
            Map<K, V> map;
            if (this.idToProperties == null) {
                this.idToProperties = new HashMap<E, Map<K, V>>();
            }
            if ((map = this.idToProperties.get(e)) == null) {
                map = new HashMap();
                this.idToProperties.put(e, map);
            }
            map.put(k, v);
        }
    }
}

