/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.Language;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.LanguagesManager;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.languages.features.DatabaseContext;
import org.netbeans.modules.languages.features.DatabaseDefinition;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.FileNotParsedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    private static Map<Project, ProjectCache> projectToCache = new WeakHashMap<Project, ProjectCache>();
    private static List<FileObject> roots;
    private static File cacheFolder;

    public static Map<FileObject, List<DatabaseDefinition>> getGlobalItems(FileObject fileObject, boolean bl) throws FileNotParsedException {
        HashMap<FileObject, List<DatabaseDefinition>> hashMap = new HashMap<FileObject, List<DatabaseDefinition>>();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return hashMap;
        }
        Index.getProjectCache(project, bl).add(hashMap, null);
        return hashMap;
    }

    public static Map<FileObject, List<DatabaseDefinition>> getGlobalItem(FileObject fileObject, String string, boolean bl) throws FileNotParsedException {
        HashMap<FileObject, List<DatabaseDefinition>> hashMap = new HashMap<FileObject, List<DatabaseDefinition>>();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return hashMap;
        }
        Index.getProjectCache(project, bl).add(hashMap, string);
        return hashMap;
    }

    private static ProjectCache getProjectCache(Project project, boolean bl) throws FileNotParsedException {
        ProjectCache projectCache = projectToCache.get(project);
        if (projectCache == null) {
            projectCache = Index.readProjectCache(project);
        }
        if (projectCache == null) {
            if (!bl) {
                throw new FileNotParsedException();
            }
            projectCache = new ProjectCache(project);
            projectToCache.put(project, projectCache);
        }
        return projectCache;
    }

    private static ProjectCache readProjectCache(Project project) {
        try {
            File file = Index.getProjectCacheFile(project);
            if (file == null) {
                return null;
            }
            return ProjectCache.load(project, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getProjectCacheFile(Project project) {
        File file;
        FileObject fileObject = project.getProjectDirectory();
        File file2 = Index.getCacheFolder();
        if (roots != null) {
            int n = roots.indexOf(fileObject);
            if (n < 0) {
                return null;
            }
            return new File(file2, "s" + (n + 1));
        }
        roots = new ArrayList<FileObject>();
        File file3 = new File(file2, "segments");
        if (!file3.exists()) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file3));
        try {
            File file4 = null;
            int n = 1;
            String string = bufferedReader.readLine();
            while (string != null) {
                file = new File(string);
                FileObject fileObject2 = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
                if (fileObject2 == null) {
                    System.out.println(Index.class.getName() + " File not found: " + file);
                } else {
                    roots.add(fileObject2);
                    if (fileObject2.equals(fileObject)) {
                        file4 = new File(file2, "s" + n);
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
            file = file4;
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        bufferedReader.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() throws IOException {
        File file = Index.getCacheFolder();
        File file2 = new File(file, "segments");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        try {
            int n = 1;
            for (Project project : projectToCache.keySet()) {
                ProjectCache projectCache = projectToCache.get(project);
                File file3 = new File(file, "s" + n);
                projectCache.save(file3);
                bufferedWriter.write(project.getProjectDirectory().getPath());
                bufferedWriter.newLine();
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    private static synchronized File getCacheFolder() {
        if (cacheFolder == null) {
            String string = System.getProperty("netbeans.user");
            assert (string != null);
            String string2 = string + File.separatorChar + "var" + File.separatorChar + "cache" + File.separatorChar + "sindex" + File.separatorChar + "1.0";
            cacheFolder = FileUtil.normalizeFile((File)new File(string2));
            if (!cacheFolder.exists()) {
                boolean bl = cacheFolder.mkdirs();
                assert (bl) : "Cannot create cache folder";
            } else assert (cacheFolder.isDirectory() && cacheFolder.canRead() && cacheFolder.canWrite());
        }
        return cacheFolder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCache {
        private FileObject fileObject;
        private List<DatabaseDefinition> definitions;

        FileCache(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        private FileCache(FileObject fileObject, List<DatabaseDefinition> list) {
            this.fileObject = fileObject;
            this.definitions = list;
        }

        private DatabaseContext getRoot(FileObject fileObject) throws LanguageDefinitionNotFoundException, IOException, ParseException {
            Language language = LanguagesManager.get().getLanguage(fileObject.getMIMEType());
            ASTNode aSTNode = language.parse(fileObject.getInputStream());
            return DatabaseManager.parse(aSTNode, null, null);
        }

        private void add(Map<FileObject, List<DatabaseDefinition>> map, String string) {
            List<DatabaseDefinition> list;
            if (this.definitions == null) {
                this.definitions = new ArrayList<DatabaseDefinition>();
                try {
                    list = this.getRoot(this.fileObject);
                    this.definitions = ((DatabaseContext)((Object)list)).getDefinitions();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (ParseException parseException) {
                    Exceptions.printStackTrace((Throwable)parseException);
                }
            }
            if (string == null) {
                if (!this.definitions.isEmpty()) {
                    list = map.get(this.fileObject);
                    if (list == null) {
                        list = new ArrayList<DatabaseDefinition>();
                        map.put(this.fileObject, list);
                    }
                    list.addAll(this.definitions);
                }
            } else {
                list = map.get(this.fileObject);
                for (DatabaseDefinition databaseDefinition : this.definitions) {
                    if (!databaseDefinition.getName().equals(string)) continue;
                    if (list == null) {
                        list = new ArrayList<DatabaseDefinition>();
                        map.put(this.fileObject, list);
                    }
                    list.add(databaseDefinition);
                }
            }
        }

        static FileCache load(FileObject fileObject, DataInputStream dataInputStream) throws IOException {
            ArrayList<DatabaseDefinition> arrayList = new ArrayList<DatabaseDefinition>();
            for (int i = dataInputStream.readInt(); i > 0; --i) {
                arrayList.add(DatabaseDefinition.load(dataInputStream));
            }
            return new FileCache(fileObject, arrayList);
        }

        private void save(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.definitions.size());
            Iterator<DatabaseDefinition> iterator = this.definitions.iterator();
            while (iterator.hasNext()) {
                iterator.next().save(dataOutputStream);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectCache {
        private FileObject root;
        private Map<FileObject, FileCache> cache;

        ProjectCache(Project project) {
            this.root = project.getProjectDirectory();
        }

        ProjectCache(Project project, Map<FileObject, FileCache> map) {
            this.root = project.getProjectDirectory();
            this.cache = map;
        }

        private void add(Map<FileObject, List<DatabaseDefinition>> map, String string) {
            if (this.cache == null) {
                this.cache = new HashMap<FileObject, FileCache>();
                this.init(this.root);
            }
            for (FileCache fileCache : this.cache.values()) {
                fileCache.add(map, string);
            }
        }

        private void init(FileObject fileObject) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (fileObject2.isFolder()) {
                    this.init(fileObject2);
                    continue;
                }
                if (!"js".equals(fileObject2.getExt())) continue;
                FileCache fileCache = new FileCache(fileObject2);
                this.cache.put(fileObject2, fileCache);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ProjectCache load(Project project, File file) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            try {
                Object object;
                HashMap<FileObject, FileCache> hashMap = new HashMap<FileObject, FileCache>();
                for (int i = dataInputStream.readInt(); i > 0; --i) {
                    object = dataInputStream.readUTF();
                    File file2 = new File((String)object);
                    file2 = FileUtil.normalizeFile((File)file2);
                    FileObject fileObject = FileUtil.toFileObject((File)file2);
                    FileCache fileCache = FileCache.load(fileObject, dataInputStream);
                    hashMap.put(fileObject, fileCache);
                }
                object = new ProjectCache(project, hashMap);
                return object;
            }
            finally {
                dataInputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save(File file) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            try {
                dataOutputStream.writeInt(this.cache.size());
                for (FileObject fileObject : this.cache.keySet()) {
                    dataOutputStream.writeUTF(fileObject.getPath());
                    FileCache fileCache = this.cache.get(fileObject);
                    fileCache.save(dataOutputStream);
                }
            }
            finally {
                dataOutputStream.close();
            }
        }
    }
}

