/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.features.DatabaseContext;
import org.netbeans.modules.languages.features.DatabaseDefinition;
import org.netbeans.modules.languages.features.DatabaseItem;
import org.netbeans.modules.languages.features.DatabaseUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseManager {
    private NbEditorDocument document;
    private static Map<ASTNode, DatabaseContext> astNodeToDatabaseContext = new WeakHashMap<ASTNode, DatabaseContext>();

    public DatabaseManager(Document document) {
        this.document = (NbEditorDocument)document;
    }

    static DatabaseContext parse(ASTNode aSTNode, Document document, ParserManager parserManager) {
        DatabaseContext databaseContext = new DatabaseContext(null, null, aSTNode.getOffset(), aSTNode.getEndOffset());
        ArrayList<ASTItem> arrayList = new ArrayList<ASTItem>();
        arrayList.add(aSTNode);
        ArrayList<DatabaseItem> arrayList2 = new ArrayList<DatabaseItem>();
        DatabaseManager.process(arrayList, databaseContext, arrayList2, document, parserManager);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            if (parserManager != null && parserManager.getState() == ParserManager.State.PARSING) {
                return null;
            }
            DatabaseUsage databaseUsage = (DatabaseUsage)iterator.next();
            DatabaseContext databaseContext2 = (DatabaseContext)iterator.next();
            DatabaseDefinition databaseDefinition = databaseContext.getDefinition(databaseUsage.getName(), databaseUsage.getOffset());
            if (databaseDefinition == null) continue;
            databaseDefinition.addUsage(databaseUsage);
            databaseContext2.addUsage(databaseUsage);
            databaseUsage.setDatabaseDefinition(databaseDefinition);
        }
        return databaseContext;
    }

    private static void process(List<ASTItem> list, DatabaseContext databaseContext, List<DatabaseItem> list2, Document document, ParserManager parserManager) {
        ASTItem aSTItem = list.get(list.size() - 1);
        Iterator<ASTItem> iterator = aSTItem.getChildren().iterator();
        while (iterator.hasNext()) {
            if (parserManager != null && parserManager.getState() == ParserManager.State.PARSING) {
                return;
            }
            ASTItem aSTItem2 = iterator.next();
            list.add(aSTItem2);
            Language language = (Language)aSTItem2.getLanguage();
            if (language != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                ASTPath aSTPath = ASTPath.create(list);
                Feature feature = language.getFeature("SEMANTIC_DECLARATION", aSTPath);
                if (feature != null) {
                    object4 = SyntaxContext.create(document, aSTPath);
                    object3 = ((String)feature.getValue("name", (Context)object4)).trim();
                    object2 = (String)feature.getValue("type", (Context)object4);
                    if (object3 != null && ((String)object3).length() > 0) {
                        DatabaseContext databaseContext2;
                        object = (String)feature.getValue("local", (Context)object4);
                        if (object != null) {
                            for (databaseContext2 = databaseContext; databaseContext2 != null && !((String)object).equals(databaseContext2.getType()); databaseContext2 = databaseContext2.getParent()) {
                            }
                            if (databaseContext2 != null) {
                                object2 = "local";
                            }
                        }
                        databaseContext2 = databaseContext;
                        if ("method".equals(object2) && (databaseContext2 = databaseContext2.getParent()) == null) {
                            databaseContext2 = databaseContext;
                        }
                        databaseContext2.addDefinition(new DatabaseDefinition((String)object3, (String)object2, aSTItem2.getOffset(), aSTItem2.getEndOffset()));
                    }
                }
                if ((feature = language.getFeature("SEMANTIC_CONTEXT", aSTPath)) != null) {
                    object4 = (String)feature.getValue("type");
                    object3 = new DatabaseContext(databaseContext, (String)object4, aSTItem2.getOffset(), aSTItem2.getEndOffset());
                    databaseContext.addContext(aSTItem2, (DatabaseContext)object3);
                    DatabaseManager.process(list, (DatabaseContext)object3, list2, document, parserManager);
                    list.remove(list.size() - 1);
                    continue;
                }
                feature = language.getFeature("SEMANTIC_USAGE", aSTPath);
                if (feature != null) {
                    object4 = SyntaxContext.create(document, aSTPath);
                    object3 = (String)feature.getValue("name", (Context)object4);
                    object2 = databaseContext.getDefinition((String)object3, aSTItem2.getOffset());
                    object = new DatabaseUsage((String)object3, aSTItem2.getOffset(), aSTItem2.getEndOffset());
                    if (object2 != null) {
                        ((DatabaseDefinition)object2).addUsage((DatabaseUsage)object);
                        ((DatabaseUsage)object).setDatabaseDefinition((DatabaseDefinition)object2);
                        databaseContext.addUsage((DatabaseUsage)object);
                    } else {
                        list2.add((DatabaseItem)object);
                        list2.add(databaseContext);
                    }
                }
            }
            DatabaseManager.process(list, databaseContext, list2, document, parserManager);
            list.remove(list.size() - 1);
        }
    }

    public static DatabaseContext getRoot(ASTNode aSTNode) {
        return astNodeToDatabaseContext.get(aSTNode);
    }

    static void setRoot(ASTNode aSTNode, DatabaseContext databaseContext) {
        astNodeToDatabaseContext.put(aSTNode, databaseContext);
    }
}

