/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BraceHighlighting
implements BracesMatcher,
BracesMatcherFactory {
    private static final Logger LOG = Logger.getLogger(BraceHighlighting.class.getName());
    private static final Map<Language, Map<String, String>[]> PAIRS = new WeakHashMap<Language, Map<String, String>[]>();
    private final MatcherContext context;
    private final String topLevelMimeType;
    private TokenSequence<?> seq;
    private int seqStart;
    private int seqEnd;
    private String originText;
    private String matchingText;
    private boolean backwards;
    private BracesMatcher defaultMatcher;

    public BraceHighlighting(String string) {
        this(string, null);
    }

    public BraceHighlighting(String string, MatcherContext matcherContext) {
        this.topLevelMimeType = string;
        this.context = matcherContext;
    }

    public int[] findOrigin() throws InterruptedException, BadLocationException {
        String[] stringArray;
        Object object;
        Language language = null;
        try {
            language = LanguagesManager.getDefault().getLanguage(this.topLevelMimeType);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
        if (language == null || tokenHierarchy == null) {
            return this.defaultFindOrigin(this.context);
        }
        int n = this.context.getSearchOffset();
        boolean bl = this.context.isSearchingBackward();
        List list = tokenHierarchy.embeddedTokenSequences(n, bl);
        for (int i = list.size() - 1; i >= 0; --i) {
            object = (TokenSequence)list.get(i);
            if (!object.language().equals((Object)language)) continue;
            this.seq = object;
            if (i > 0) {
                stringArray = (String[])list.get(i - 1);
                this.seqStart = stringArray.offset();
                this.seqEnd = stringArray.offset() + stringArray.token().length();
                break;
            }
            this.seqStart = 0;
            this.seqEnd = this.context.getDocument().getLength();
            break;
        }
        if (this.seq == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("TokenSequence with wrong language " + language);
            }
            return null;
        }
        Map<String, String>[] mapArray = BraceHighlighting.getPairsMap(language);
        if (mapArray == null) {
            return this.defaultFindOrigin(this.context);
        }
        this.seq.move(n);
        if (this.seq.moveNext()) {
            object = new boolean[1];
            stringArray = new String[1];
            String string = ((Object)this.seq.token().text()).toString();
            if (BraceHighlighting.isOrigin(mapArray, string, stringArray, (boolean[])object) && (this.seq.offset() < n || !bl)) {
                this.originText = string;
                this.matchingText = stringArray[0];
                this.backwards = object[0];
                return new int[]{this.seq.offset(), this.seq.offset() + this.seq.token().length()};
            }
            while (BraceHighlighting.moveTheSequence(this.seq, bl, this.context.getLimitOffset())) {
                if (!BraceHighlighting.isOrigin(mapArray, string, stringArray, (boolean[])object)) continue;
                this.originText = string;
                this.matchingText = stringArray[0];
                this.backwards = object[0];
                return new int[]{this.seq.offset(), this.seq.offset() + this.seq.token().length()};
            }
        }
        return null;
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (this.defaultMatcher != null) {
            return this.defaultMatcher.findMatches();
        }
        assert (this.seq != null) : "No token sequence";
        int n = 1;
        while (BraceHighlighting.moveTheSequence(this.seq, this.backwards, -1)) {
            String string = ((Object)this.seq.token().text()).toString();
            if (this.matchingText.equals(string)) {
                if (--n != 0) continue;
                return new int[]{this.seq.offset(), this.seq.offset() + this.seq.token().length()};
            }
            if (!this.originText.equals(string)) continue;
            ++n;
        }
        return null;
    }

    public BracesMatcher createMatcher(MatcherContext matcherContext) {
        return new BraceHighlighting(this.topLevelMimeType, matcherContext);
    }

    private static Map<String, String>[] getPairsMap(Language language) {
        if (!PAIRS.containsKey(language)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            List<Feature> list = language.getFeatures("BRACE");
            for (Feature mapArray2 : list) {
                String string = (String)mapArray2.getValue();
                int n = string.indexOf(58);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                hashMap.put(string2, string3);
                hashMap2.put(string3, string2);
            }
            Map[] mapArray = new Map[]{hashMap, hashMap2};
            PAIRS.put(language, mapArray);
        }
        return PAIRS.get(language);
    }

    private static boolean moveTheSequence(TokenSequence<?> tokenSequence, boolean bl, int n) {
        if (bl) {
            if (tokenSequence.movePrevious()) {
                int n2 = tokenSequence.offset() + tokenSequence.token().length();
                return n == -1 ? true : n2 > n;
            }
        } else if (tokenSequence.moveNext()) {
            int n3 = tokenSequence.offset();
            return n == -1 ? true : n3 < n;
        }
        return false;
    }

    private static boolean isOrigin(Map<String, String>[] mapArray, String string, String[] stringArray, boolean[] blArray) {
        String string2 = mapArray[0].get(string);
        if (string2 != null) {
            stringArray[0] = string2;
            blArray[0] = false;
            return true;
        }
        string2 = mapArray[1].get(string);
        if (string2 != null) {
            stringArray[0] = string2;
            blArray[0] = true;
            return true;
        }
        return false;
    }

    private int[] defaultFindOrigin(MatcherContext matcherContext) throws InterruptedException, BadLocationException {
        this.defaultMatcher = BracesMatcherSupport.defaultMatcher((MatcherContext)matcherContext, (int)-1, (int)-1);
        return this.defaultMatcher.findOrigin();
    }
}

