/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.util.Collections;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.languages.dataobject.LanguagesEditorKit;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LanguagesOptions
extends BaseOptions {
    private static final Logger LOG = Logger.getLogger(LanguagesOptions.class.getName());
    public static String LANGUAGES = "Languages";
    private static final String OPTIONS_LANGUAGES = "OPTIONS_" + LANGUAGES;
    public static final String CODE_FOLDING_ENABLE_PROP = "codeFoldingEnable";
    private static LanguagesOptions defaultInstance;
    static final String[] LANGUAGES_PROP_NAMES;
    private static final String HELP_ID = "editing.editor.php";
    private String mimeType;

    public static synchronized LanguagesOptions create(FileObject fileObject) {
        if (defaultInstance == null) {
            String string = fileObject.getParent().getPath().substring(8);
            defaultInstance = new LanguagesOptions(string);
        }
        return defaultInstance;
    }

    private LanguagesOptions(String string) {
        super(LanguagesEditorKit.class, LANGUAGES);
        this.mimeType = string;
    }

    protected String getContentType() {
        return this.mimeType;
    }

    public boolean getCodeFoldingEnable() {
        return this.getSettingBoolean("code-folding-enable");
    }

    public void setCodeFoldingEnable(boolean bl) {
        this.setSettingBoolean("code-folding-enable", bl, CODE_FOLDING_ENABLE_PROP);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public MIMEOptionNode getMimeNode() {
        return null;
    }

    protected String getString(String string) {
        try {
            if (OPTIONS_LANGUAGES.equals(string)) {
                return LanguagesOptions.getMimeTypeDisplayName(this.getContentType());
            }
            return NbBundle.getMessage(LanguagesOptions.class, (String)string);
        }
        catch (MissingResourceException missingResourceException) {
            return super.getString(string);
        }
    }

    private static String getMimeTypeDisplayName(String string) {
        String string2 = null;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string);
        if (fileObject != null) {
            Object object;
            try {
                string2 = fileObject.getFileSystem().getStatus().annotateName(null, Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            if (string2 == null && (object = fileObject.getAttribute("SystemFileSystem.localizingBundle")) instanceof String) {
                try {
                    ResourceBundle resourceBundle = NbBundle.getBundle((String)((String)object));
                    if (resourceBundle != null) {
                        string2 = resourceBundle.getString(string);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    LOG.log(Level.WARNING, "Can't find display name for mime type '" + string + "'", missingResourceException);
                }
            }
        }
        return string2 == null ? string : NbBundle.getMessage(LanguagesOptions.class, (String)"Languages_options_name", string2);
    }

    static {
        LANGUAGES_PROP_NAMES = OptionSupport.mergeStringArrays((String[])BaseOptions.BASE_PROP_NAMES, (String[])new String[]{CODE_FOLDING_ENABLE_PROP});
    }
}

