/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.CompletionItem;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LibrarySupport {
    public static LibrarySupport create(String string) {
        return new LibraryImpl(string);
    }

    public static LibrarySupport create(List<String> list) {
        return new DelegatingLibrarySupport(list);
    }

    public abstract List<String> getItems(String var1);

    public abstract List<CompletionItem> getCompletionItems(String var1);

    public abstract String getProperty(String var1, String var2, String var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegatingLibrarySupport
    extends LibrarySupport {
        private List<LibrarySupport> libraries = new ArrayList<LibrarySupport>();

        DelegatingLibrarySupport(List<String> list) {
            for (String string : list) {
                this.libraries.add(new LibraryImpl(string));
            }
        }

        @Override
        public List<String> getItems(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (LibrarySupport librarySupport : this.libraries) {
                arrayList.addAll(librarySupport.getItems(string));
            }
            return arrayList;
        }

        @Override
        public List<CompletionItem> getCompletionItems(String string) {
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
            for (LibrarySupport librarySupport : this.libraries) {
                arrayList.addAll(librarySupport.getCompletionItems(string));
            }
            return arrayList;
        }

        @Override
        public String getProperty(String string, String string2, String string3) {
            for (LibrarySupport librarySupport : this.libraries) {
                String string4 = librarySupport.getProperty(string, string2, string3);
                if (string4 == null) continue;
                return string4;
            }
            return null;
        }
    }

    static class Handler
    extends DefaultHandler {
        Map<String, Map<String, List<Map<String, String>>>> result = new HashMap<String, Map<String, List<Map<String, String>>>>();

        Handler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (string3.equals("node")) {
                    Object object;
                    int n;
                    String string4 = attributes.getValue("context");
                    String string5 = attributes.getValue("key");
                    HashMap hashMap = null;
                    if (attributes.getLength() > 2) {
                        hashMap = new HashMap();
                        int n2 = attributes.getLength();
                        for (n = 0; n < n2; ++n) {
                            object = attributes.getQName(n);
                            if ("context".equals(object) || "key".equals(object)) continue;
                            hashMap.put(object, attributes.getValue(n));
                        }
                    }
                    while (true) {
                        ArrayList arrayList;
                        String string6;
                        if ((object = this.result.get(string6 = (n = string4.indexOf(44)) >= 0 ? string4.substring(0, n).trim() : string4)) == null) {
                            object = new HashMap();
                            this.result.put(string6, (Map<String, List<Map<String, String>>>)object);
                        }
                        if ((arrayList = (ArrayList)object.get(string5)) == null) {
                            arrayList = new ArrayList();
                            object.put(string5, arrayList);
                        }
                        arrayList.add(hashMap);
                        if (n >= 0) {
                            string4 = string4.substring(n + 1);
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryImpl
    extends LibrarySupport {
        private String resourceName;
        private Map<String, List<String>> keys = new HashMap<String, List<String>>();
        private Map<String, Map<String, List<Map<String, String>>>> items;

        LibraryImpl(String string) {
            this.resourceName = string;
        }

        @Override
        public List<String> getItems(String string) {
            List<String> list = this.keys.get(string);
            if (list == null) {
                Map<String, List<Map<String, String>>> map = this.getItems().get(string);
                if (map == null) {
                    return null;
                }
                list = new ArrayList<String>(map.keySet());
                Collections.sort(list);
                list = Collections.unmodifiableList(list);
                this.keys.put(string, list);
            }
            return list;
        }

        @Override
        public List<CompletionItem> getCompletionItems(String string) {
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
            Map<String, List<Map<String, String>>> map = this.getItems().get(string);
            if (map == null) {
                return arrayList;
            }
            for (String string2 : map.keySet()) {
                List<Map<String, String>> list = map.get(string2);
                for (Map<String, String> map2 : list) {
                    CompletionItem.Type type = null;
                    String string3 = map2.get("type");
                    if ("class".equals(string3)) {
                        type = CompletionItem.Type.CLASS;
                    } else if ("field".equals(string3)) {
                        type = CompletionItem.Type.FIELD;
                    } else if ("constant".equals(string3)) {
                        type = CompletionItem.Type.CONSTANT;
                    } else if ("constructor".equals(string3)) {
                        type = CompletionItem.Type.CONSTRUCTOR;
                    } else if ("interface".equals(string3)) {
                        type = CompletionItem.Type.INTERFACE;
                    } else if ("keyword".equals(string3)) {
                        type = CompletionItem.Type.KEYWORD;
                    } else if ("local".equals(string3)) {
                        type = CompletionItem.Type.LOCAL;
                    } else if ("method".equals(string3)) {
                        type = CompletionItem.Type.METHOD;
                    } else if ("parameter".equals(string3)) {
                        type = CompletionItem.Type.PARAMETER;
                    }
                    arrayList.add(CompletionItem.create(string2, map2.get("description"), map2.get("library"), type, 200));
                }
            }
            return arrayList;
        }

        @Override
        public String getProperty(String string, String string2, String string3) {
            Map<String, List<Map<String, String>>> map = this.getItems().get(string);
            if (map == null) {
                return null;
            }
            List<Map<String, String>> list = map.get(string2);
            if (list == null) {
                return null;
            }
            if (list.size() > 1) {
                throw new IllegalArgumentException();
            }
            return list.get(0).get(string3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Map<String, List<Map<String, String>>>> getItems() {
            if (this.items == null) {
                try {
                    XMLReader xMLReader = XMLUtil.createXMLReader();
                    Handler handler = new Handler();
                    xMLReader.setEntityResolver(handler);
                    xMLReader.setContentHandler(handler);
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    InputStream inputStream = classLoader.getResourceAsStream(this.resourceName);
                    try {
                        xMLReader.parse(new InputSource(inputStream));
                    }
                    finally {
                        inputStream.close();
                    }
                    this.items = handler.result;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                    this.items = Collections.emptyMap();
                }
            }
            return this.items;
        }
    }
}

