/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;

public abstract class Context {
    public abstract JTextComponent getJTextComponent();

    public abstract Document getDocument();

    public abstract int getOffset();

    public static Context create(Document document, int n) {
        return new CookieImpl(document, n);
    }

    private static class CookieImpl
    extends Context {
        private Document doc;
        private JTextComponent component;
        private int offset;

        CookieImpl(Document document, int n) {
            this.doc = document;
            this.offset = n;
        }

        public JTextComponent getJTextComponent() {
            DataObject dataObject;
            EditorCookie editorCookie;
            if (this.component == null && (editorCookie = (EditorCookie)(dataObject = NbEditorUtilities.getDataObject((Document)this.doc)).getLookup().lookup(EditorCookie.class)).getOpenedPanes().length > 0) {
                this.component = editorCookie.getOpenedPanes()[0];
            }
            return this.component;
        }

        public Document getDocument() {
            return this.doc;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

