/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTItem {
    private Language language;
    private int offset;
    private int length = -1;
    private List<ASTItem> children;
    private TreeMap<Integer, ASTItem> childrenMap = null;

    ASTItem(Language language, int n, int n2, List<? extends ASTItem> list) {
        this.language = language;
        this.offset = n;
        this.length = n2;
        this.children = list != null ? list : Collections.emptyList();
    }

    public int getOffset() {
        return this.offset;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getMimeType() {
        if (this.language == null) {
            return null;
        }
        return this.language.getMimeType();
    }

    public List<ASTItem> getChildren() {
        return this.children;
    }

    void addChildren(ASTItem aSTItem) {
        if (this.children == Collections.emptyList()) {
            this.children = new ArrayList<ASTItem>();
        }
        this.children.add(aSTItem);
        if (this.childrenMap != null) {
            this.childrenMap.put(aSTItem.getOffset(), aSTItem);
        }
    }

    void removeChildren(ASTItem aSTItem) {
        if (this.children == Collections.emptyList()) {
            return;
        }
        this.children.remove(aSTItem);
        if (this.childrenMap != null) {
            this.childrenMap.remove(aSTItem.getOffset());
        }
    }

    void setChildren(int n, ASTItem aSTItem) {
        if (this.children == Collections.emptyList()) {
            return;
        }
        int n2 = this.children.get(n).getOffset();
        this.children.set(n, aSTItem);
        if (this.childrenMap != null) {
            this.childrenMap.remove(n2);
            this.childrenMap.put(aSTItem.getOffset(), aSTItem);
        }
    }

    public void lock() {
        this.children = Collections.unmodifiableList(this.children);
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public int getLength() {
        if (this.length < 0) {
            List<ASTItem> list = this.getChildren();
            if (list.isEmpty()) {
                this.length = 0;
            } else {
                ASTItem aSTItem = list.get(list.size() - 1);
                this.length = aSTItem.getEndOffset() - this.getOffset();
            }
        }
        return this.length;
    }

    public ASTPath findPath(int n) {
        return this.findPath(new ArrayList<ASTItem>(), n);
    }

    ASTPath findPath(List<ASTItem> list, int n) {
        if (n < this.getOffset()) {
            return ASTPath.create(list);
        }
        if (n > this.getEndOffset()) {
            return ASTPath.create(list);
        }
        list.add(this);
        if (this.getChildren().isEmpty()) {
            return ASTPath.create(list);
        }
        if (this.getChildren().size() > 10) {
            return this.findPath2(list, n);
        }
        for (ASTItem aSTItem : this.getChildren()) {
            if (n >= aSTItem.getEndOffset() || aSTItem.getOffset() > n) continue;
            return aSTItem.findPath(list, n);
        }
        return ASTPath.create(list);
    }

    private ASTPath findPath2(List<ASTItem> list, int n) {
        TreeMap<Integer, ASTItem> treeMap = this.getChildrenMap();
        SortedMap<Integer, ASTItem> sortedMap = treeMap.headMap(new Integer(n + 1));
        if (sortedMap.isEmpty()) {
            return ASTPath.create(list);
        }
        Integer n2 = sortedMap.lastKey();
        ASTItem aSTItem = treeMap.get(n2);
        ASTPath aSTPath = aSTItem.findPath(list, n);
        if (aSTPath == null) {
            return ASTPath.create(list);
        }
        return aSTPath;
    }

    private TreeMap<Integer, ASTItem> getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new TreeMap();
            for (ASTItem aSTItem : this.getChildren()) {
                this.childrenMap.put(new Integer(aSTItem.getOffset()), aSTItem);
            }
        }
        return this.childrenMap;
    }
}

