/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.resources;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.ValidationUtils;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class NewResourceDialog
extends JDialog {
    private int dialogResult = 2;
    private String resourceType = "img";
    private JServer server = null;
    private String reportUnitUri = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private String parentUri;
    private JButton jButton1;
    private JButton jButtonClose;
    private JButton jButtonSave;
    private JComboBox jComboBoxResourceType;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelResourceFile;
    private JLabel jLabelResourceType;
    private JLabel jLabelUriString;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelFile;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTextField jTextFieldFile;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldUriString;

    public NewResourceDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.jTextFieldLabel.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }
        });
        this.jTextFieldFile.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }
        });
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                NewResourceDialog.this.updateSaveButton();
            }
        });
        this.jComboBoxResourceType.addItem(new Tag((Object)"img", "Image"));
        this.jComboBoxResourceType.addItem(new Tag((Object)"prop", "Resource bundle"));
        this.jComboBoxResourceType.addItem(new Tag((Object)"jrxml", "Jrxml"));
        this.jComboBoxResourceType.addItem(new Tag((Object)"jar", "Jar"));
        this.jComboBoxResourceType.addItem(new Tag((Object)"font", "Font"));
        this.applyI18n();
        this.jTextFieldName.requestFocusInWindow();
    }

    public void applyI18n() {
        this.jButtonClose.setText(JasperServerManager.getString("newResourceDialog.buttonCancel", "Cancel"));
        this.jButtonSave.setText(JasperServerManager.getString("newResourceDialog.buttonSave", "Save"));
        this.jLabel1.setText(JasperServerManager.getString("newResourceDialog.title", "New folder/resource"));
        this.jLabelDescription.setText(JasperServerManager.getString("newResourceDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(JasperServerManager.getString("newResourceDialog.labelLabel", "Label"));
        this.jLabelName.setText(JasperServerManager.getString("newResourceDialog.labelName", "Name"));
        this.jLabelUriString.setText(JasperServerManager.getString("newResourceDialog.labelParentFolder", "Parent folder"));
        this.jButton1.setText(JasperServerManager.getString("newResourceDialog.browse", "Browse"));
        this.jLabelResourceFile.setText(JasperServerManager.getString("newResourceDialog.labelResourceFile", "Resource file"));
        this.jLabelResourceType.setText(JasperServerManager.getString("newResourceDialog.labelResourceType", "Resource type"));
    }

    public void updateSaveButton() {
        if (!(this.jTextFieldLabel.getText().length() <= 0 || this.jTextFieldName.getText().length() <= 0 || this.jComboBoxResourceType.isVisible() && this.jTextFieldFile.getText().length() <= 0)) {
            this.jButtonSave.setEnabled(true);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelResourceType = new JLabel();
        this.jComboBoxResourceType = new JComboBox();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jLabelDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jSeparator2 = new JSeparator();
        this.jLabelResourceFile = new JLabel();
        this.jPanelFile = new JPanel();
        this.jTextFieldFile = new JTextField();
        this.jButton1 = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Import resource");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewResourceDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_new.png")));
        this.jLabel1.setText("New folder/resource");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setMaximumSize(new Dimension(126, 50));
        this.jLabel1.setOpaque(true);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jSeparator4.setMinimumSize(new Dimension(1, 2));
        this.jSeparator4.setPreferredSize(new Dimension(1, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator4, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(400, 200));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Parent Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelResourceType.setText("Resource type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelResourceType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jComboBoxResourceType, gridBagConstraints);
        this.jLabelName.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabelLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel1.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelResourceFile.setText("Resource file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelResourceFile, gridBagConstraints);
        this.jPanelFile.setMinimumSize(new Dimension(11, 19));
        this.jPanelFile.setPreferredSize(new Dimension(11, 19));
        this.jPanelFile.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFile.add((Component)this.jTextFieldFile, gridBagConstraints);
        this.jButton1.setText("Browse");
        this.jButton1.setMinimumSize(new Dimension(73, 19));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewResourceDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanelFile.add((Component)this.jButton1, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel1.add((Component)this.jPanelFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator3.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel2.setMinimumSize(new Dimension(10, 30));
        this.jPanel2.setPreferredSize(new Dimension(10, 30));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewResourceDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel2.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewResourceDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle("Pick a file....");
        String resType = "" + ((Tag)this.jComboBoxResourceType.getSelectedItem()).getValue();
        if (resType.equals("jrxml")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".xml") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "JasperReports XML *.xml, *.jrxml";
                }
            });
        } else if (resType.equals("font")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".ttf") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "TrueType font *.TTF";
                }
            });
        } else if (resType.equals("prop")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".properties") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "ResourceBundle *.properties";
                }
            });
        } else if (resType.equals("jar")) {
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.toLowerCase().endsWith(".jar") || file.isDirectory() || filename.toLowerCase().endsWith(".jrxml");
                }

                public String getDescription() {
                    return "Java Archive *.jar";
                }
            });
        }
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            this.jTextFieldFile.setText(jfc.getSelectedFile() + "");
            this.updateSaveButton();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.jButtonSave.isEnabled() && JOptionPane.showConfirmDialog(this, JasperServerManager.getString("newResourceDialog.message.resourceChanged", "The resource was changed.\n\nDo you want save the changes?")) == 0) {
            this.jButtonSaveActionPerformed(null);
            if (this.jButtonSave.isEnabled()) {
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        ResourceDescriptor rd = new ResourceDescriptor();
        File resourceFile = null;
        if (!this.getResourceType().equals("folder")) {
            rd.setWsType("" + ((Tag)this.jComboBoxResourceType.getSelectedItem()).getValue());
            rd.setHasData(true);
            resourceFile = new File(this.jTextFieldFile.getText());
            if (!resourceFile.exists()) {
                JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("newResourceDialog.message.fileNotFound", "{0}\n\nFile not found!", new Object[]{this.jTextFieldFile.getText()}));
                return;
            }
        } else {
            rd.setWsType("folder");
        }
        rd.setName(this.jTextFieldName.getText());
        String uri = this.getParentUri();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentUri());
        if (this.getReportUnitUri() != null && !this.getReportUnitUri().equals("/")) {
            rd.setParentFolder(this.getReportUnitUri() + "_files");
        }
        rd.setIsNew(true);
        try {
            this.validate(rd);
            this.newResourceDescriptor = this.getServer().getWSClient().modifyReportUnitResource(this.getReportUnitUri(), rd, resourceFile);
            this.setDialogResult(0);
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getParentUri() {
        return this.parentUri;
    }

    public void setParentUri(String parentUri) {
        this.parentUri = parentUri;
        if (this.reportUnitUri != null && this.reportUnitUri.length() > 0) {
            this.parentUri = this.reportUnitUri + "_files";
        }
        this.jTextFieldUriString.setText(parentUri);
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
        boolean newFolder = resourceType.equals("folder");
        this.jLabelResourceType.setVisible(!newFolder);
        this.jComboBoxResourceType.setVisible(!newFolder);
        this.jSeparator2.setVisible(!newFolder);
        this.jLabelResourceFile.setVisible(!newFolder);
        this.jPanelFile.setVisible(!newFolder);
        Misc.setComboboxSelectedTagValue((JComboBox)this.jComboBoxResourceType, (Object)resourceType);
    }

    public String getReportUnitUri() {
        return this.reportUnitUri;
    }

    public void setReportUnitUri(String reportUnitUri) {
        this.reportUnitUri = reportUnitUri;
        if (reportUnitUri != null && reportUnitUri.length() > 0) {
            this.setParentUri(reportUnitUri + "_files");
        }
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }
}

