/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class DropGlassPane
extends JPanel {
    private static HashMap<Integer, DropGlassPane> map = new HashMap();
    private static final int MIN_X = 0;
    private static final int MIN_Y = 0;
    private static final int MIN_WIDTH = 0;
    private static final int MIN_HEIGTH = 0;
    private static Component oldPane;
    private static JComponent originalSource;
    private static boolean wasVisible;
    Line2D line = null;
    Rectangle prevLineRect = null;

    private DropGlassPane() {
    }

    public static synchronized DropGlassPane getDefault(JComponent jComponent) {
        Integer n = System.identityHashCode(jComponent);
        if (map.get(n) == null) {
            DropGlassPane dropGlassPane = new DropGlassPane();
            dropGlassPane.setOpaque(false);
            map.put(n, dropGlassPane);
        }
        return map.get(n);
    }

    static void setOriginalPane(JComponent jComponent, Component component, boolean bl) {
        oldPane = component;
        originalSource = jComponent;
        wasVisible = bl;
    }

    static boolean isOriginalPaneStored() {
        return oldPane != null;
    }

    static void putBackOriginal() {
        if (oldPane == null) {
            return;
        }
        originalSource.getRootPane().setGlassPane(oldPane);
        oldPane.setVisible(wasVisible);
        oldPane = null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.setDropLine(null);
        }
    }

    public void setDropLine(Line2D line2D) {
        if (!this.isValid()) {
            return;
        }
        if (!(null == this.prevLineRect || (null == line2D || this.prevLineRect.contains(line2D.getP1()) && this.prevLineRect.contains(line2D.getP2())) && null != line2D)) {
            this.repaint(this.prevLineRect);
        }
        this.line = line2D;
        Rectangle rectangle = null;
        if (null != this.line) {
            this.checkLineBounds(this.line);
            rectangle = line2D.getBounds();
            rectangle.grow(5, 5);
        }
        if (null != rectangle && !rectangle.equals(this.prevLineRect)) {
            this.repaint(rectangle);
        }
        this.prevLineRect = rectangle;
    }

    private Line2D checkLineBounds(Line2D line2D) {
        Rectangle rectangle = this.getBounds();
        double d = Math.max(line2D.getX1(), (double)(rectangle.x + 0));
        double d2 = Math.max(line2D.getY1(), (double)(rectangle.y + 0));
        double d3 = Math.min(line2D.getX2(), (double)(rectangle.x + rectangle.width));
        double d4 = Math.min(line2D.getY2(), (double)(rectangle.y + rectangle.height - 0));
        line2D.setLine(d, d2, d3, d4);
        return line2D;
    }

    public void paint(Graphics graphics) {
        if (this.line != null) {
            int n;
            int n2 = (int)this.line.getX1();
            int n3 = (int)this.line.getX2();
            int n4 = (int)this.line.getY1();
            if (n4 == (n = (int)this.line.getY2())) {
                graphics.drawLine(n2 + 2, n4, n3 - 2, n4);
                graphics.drawLine(n2 + 2, n4 + 1, n3 - 2, n4 + 1);
                graphics.drawLine(n2, n4 - 2, n2, n4 + 3);
                graphics.drawLine(n2 + 1, n - 1, n2 + 1, n4 + 2);
                graphics.drawLine(n3, n4 - 2, n3, n4 + 3);
                graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 + 2);
            } else {
                graphics.drawLine(n2, n4 + 2, n3, n - 2);
                graphics.drawLine(n2 + 1, n4 + 2, n3 + 1, n - 2);
                graphics.drawLine(n2 - 2, n4, n2 + 3, n4);
                graphics.drawLine(n2 - 1, n4 + 1, n2 + 2, n4 + 1);
                graphics.drawLine(n3 - 2, n, n3 + 3, n);
                graphics.drawLine(n3 - 1, n - 1, n3 + 2, n - 1);
            }
        }
    }
}

