/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;

public class MultiAxisChartHyperlinkProvider
implements ChartHyperlinkProvider {
    private static final long serialVersionUID = 10200L;
    private Map datasetProviders = new HashMap();

    public void addHyperlinkProvider(Dataset dataset, ChartHyperlinkProvider provider) {
        this.datasetProviders.put(dataset, provider);
    }

    public boolean hasHyperlinks() {
        boolean hasHyperlinks = false;
        if (!this.datasetProviders.isEmpty()) {
            Iterator it = this.datasetProviders.values().iterator();
            while (it.hasNext()) {
                ChartHyperlinkProvider provider = (ChartHyperlinkProvider)it.next();
                if (!provider.hasHyperlinks()) continue;
                hasHyperlinks = true;
                break;
            }
        }
        return hasHyperlinks;
    }

    public JRPrintHyperlink getEntityHyperlink(ChartEntity entity) {
        JRPrintHyperlink hyperlink = null;
        ChartHyperlinkProvider provider = this.resolveEntityProvider(entity);
        if (provider != null && provider.hasHyperlinks()) {
            hyperlink = provider.getEntityHyperlink(entity);
        }
        return hyperlink;
    }

    protected ChartHyperlinkProvider resolveEntityProvider(ChartEntity entity) {
        ChartHyperlinkProvider provider = null;
        Dataset dataset = this.getEntityDataset(entity);
        if (dataset != null) {
            provider = (ChartHyperlinkProvider)this.datasetProviders.get(dataset);
        }
        return provider;
    }

    protected Dataset getEntityDataset(ChartEntity entity) {
        CategoryDataset dataset = null;
        if (entity instanceof CategoryItemEntity) {
            dataset = ((CategoryItemEntity)entity).getDataset();
        } else if (entity instanceof XYItemEntity) {
            dataset = ((XYItemEntity)entity).getDataset();
        }
        return dataset;
    }
}

