/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.editor.BaseKit;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacroSavePanel
extends JPanel {
    private final ResourceBundle bundle = NbBundle.getBundle(BaseKit.class);
    private Vector<String> bindings = new Vector();
    private final String mimeType;
    public JButton addButton;
    public JLabel bindingLabel;
    public JList bindingList;
    public JPanel bindingPanel;
    public JScrollPane bindingScrollPane;
    public JTextField macroField;
    public JLabel macroLabel;
    public JPanel macroPanel;
    public JTextField nameField;
    public JLabel nameLabel;
    public JButton removeButton;

    public MacroSavePanel(String string) {
        this.mimeType = string;
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(this.bundle.getString("MSP_Name_Mnemonic").charAt(0));
        this.macroLabel.setDisplayedMnemonic(this.bundle.getString("MSP_Macro_Mnemonic").charAt(0));
        this.bindingLabel.setDisplayedMnemonic(this.bundle.getString("MSP_Keys_Mnemonic").charAt(0));
        this.nameField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP_Name"));
        this.macroField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP_Macro"));
        this.bindingList.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP_Keys"));
        this.getAccessibleContext().setAccessibleName(this.bundle.getString("MDS_title"));
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP"));
        this.setMaximumSize(new Dimension(400, 200));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    private void initComponents() {
        this.macroPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.macroLabel = new JLabel();
        this.nameField = new JTextField();
        this.macroField = new JTextField();
        this.bindingPanel = new JPanel();
        this.bindingLabel = new JLabel();
        this.bindingScrollPane = new JScrollPane();
        this.bindingList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        this.macroPanel.setLayout(new GridBagLayout());
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(this.bundle.getString("MSP_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.macroPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.macroLabel.setLabelFor(this.macroField);
        this.macroLabel.setText(this.bundle.getString("MSP_Macro"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.macroPanel.add((Component)this.macroLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.macroPanel.add((Component)this.nameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.macroPanel.add((Component)this.macroField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.macroPanel, gridBagConstraints);
        this.bindingPanel.setLayout(new GridBagLayout());
        this.bindingLabel.setLabelFor(this.bindingList);
        this.bindingLabel.setText(this.bundle.getString("MSP_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.bindingPanel.add((Component)this.bindingLabel, gridBagConstraints);
        this.bindingScrollPane.setViewportView(this.bindingList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.bindingPanel.add((Component)this.bindingScrollPane, gridBagConstraints);
        this.addButton.setMnemonic(this.bundle.getString("MSP_Add_Mnemonic").charAt(0));
        this.addButton.setText(this.bundle.getString("MSP_Add"));
        this.addButton.setToolTipText(this.bundle.getString("MSP_AddToolTip"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroSavePanel.this.addBindingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.bindingPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setMnemonic(this.bundle.getString("MSP_Remove_Mnemonic").charAt(0));
        this.removeButton.setText(this.bundle.getString("MSP_Remove"));
        this.removeButton.setToolTipText(this.bundle.getString("MSP_RemoveToolTip"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacroSavePanel.this.removeBindingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.bindingPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.bindingPanel, gridBagConstraints);
    }

    private void removeBindingActionPerformed(ActionEvent actionEvent) {
        int n = this.bindingList.getSelectedIndex();
        if (n >= 0) {
            this.bindings.remove(n);
            this.bindingList.setListData(this.bindings);
        }
        if (this.bindingList.getModel().getSize() <= 0) {
            this.removeButton.setEnabled(false);
        } else {
            this.bindingList.setSelectedIndex(0);
        }
    }

    private void addBindingActionPerformed(ActionEvent actionEvent) {
        ShortcutsFinder shortcutsFinder = (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class);
        String string = shortcutsFinder.showShortcutsDialog();
        if (string != null) {
            this.bindings.add(string);
            this.bindingList.setListData(this.bindings);
            this.bindingList.setSelectedIndex(0);
            this.removeButton.setEnabled(true);
        }
    }

    public String getMacroName() {
        return this.nameField.getText();
    }

    public void setMacroName(String string) {
        this.nameField.setText(string);
    }

    public String getMacroBody() {
        return this.macroField.getText();
    }

    public void setMacroBody(String string) {
        this.macroField.setText(string);
    }

    public Set<String> getKeySequences() {
        return new HashSet<String>(this.bindings);
    }

    public void popupNotify() {
        this.nameField.requestFocus();
    }
}

